//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.* ;
import javax.swing.* ;
import java.awt.event.* ;
import java.util.* ;
import java.io.* ;
import java.awt.print.* ;
import java.awt.geom.Rectangle2D ;
import java.net.URL ;
import java.awt.image.BufferedImage ;
import javax.imageio.ImageIO ;
import java.nio.charset.Charset ;

public class zone extends JPanel  implements Printable , MouseListener , MouseMotionListener {


/** 
* L'application qui affiche cet objet.
*/
	edugraphe G ;
/** 
* L'applet qui affiche cet objet.
*/
	JApplet AG ;

/** 
* La barre d'outils affichée en haut de la fenêtre.
*/
	JToolBar T = new JToolBar() ;				

/** 
* La barre d'outils affichée en bas de la fenêtre.
*/
	dial D ;
	
/** 
* La fenêtre "À propos" associée à cet objet.
*/
	AboutBox B ;

/** 
* La fenêtre "Aspect" associée à cet objet.
*/
	AspectPane A ;

/** 
* La fenêtre "Préférences" associée à cet objet.
*/
	PrefsPane P ;
	
/** 
* La fenêtre "Manuel" associée à cet objet.
*/
	HelpPane H ;
	
	// drapeaux
    static boolean  create = false , modify = true , delete = false , accepte = true , 
					repereVisible = true , quadrillageVisible = false , 
					zoom = false , photo = false ; 
	boolean  affiche = true , repDetected = false ; 
	
	// objets graphiques
	static Vector  GR = new Vector() ;
	static objetG o , od ;
	
	// souris
	int X , Y ;
	Point Pd ;
	
	// tracés
    final static BasicStroke stroke = new BasicStroke(1.0f);
    final static float dash1[] = {3.0f};
    final static BasicStroke dashed = new BasicStroke(1.0f, 
                                                      BasicStroke.CAP_BUTT, 
                                                      BasicStroke.JOIN_MITER, 
                                                      3.0f, dash1, 0.0f);
	
	// io
	URL url ;
	ResourceBundle resbundle  = dessin.RB ;
	StringTokenizer st ;
	Toolkit tkt = Toolkit.getDefaultToolkit() ;
	
	String lcOSName = System.getProperty("os.name").toLowerCase() ;
	boolean MAC_OS_X = lcOSName.startsWith("mac os x") ;
	int FileKeyMask = MAC_OS_X ? KeyEvent.META_MASK : KeyEvent.CTRL_MASK ;
	int HelpKey = MAC_OS_X ? KeyEvent.VK_M : KeyEvent.VK_F1 ;
	int HelpKeyMask = MAC_OS_X ? KeyEvent.META_MASK : 0 ;
	
	boolean outOfApplet = false ;
	String dirName , fileName ;
	JFileChooser fc ;
	javax.swing.filechooser.FileFilter[] ff ;
	PrinterJob printJob ;
	PageFormat pageForm ;

	String tconfiguration = "barre()" ;
	
	public static String dconfiguration , dfenetre ;
	
	// actions
	public static String[] iconString = {
		"fenetre" , "courbe", "pointsurcourbe" , "suiterec" , "suitegen" ,
		"euler" , "domaine" , "droite" , "point" , "tangente" ,
		"select" , "effacer" , "palette" , "intersection" , "zoom" ,
		"zoomp" , "zoomm" , "equation" , "photo" , "help" , "marque"
	} ;
	
	public static String[] actionString = {
		"new" , "open" , "save" , "saveAs" , "print" ,  
		"page" , "quit" , "about" , "prefs" , "clear" , 
		"select" , "delete" , "rep" , "quad" , "norm" , 
		"tool" , "dial" , "aspect" , "zoom" , "zoomp" , 
		"zoomm" , "photo" , "help" , "curve" , "pointoncurve" , 
		"recsequence" , "gensequence" , "euler" , "domain" , "point" , 
		"line" , "tangent" , "intersection" , "equation" , "mark" ,
		"text"
	} ;
	
	AbstractAction actionForName(String name) {
		int n = -1 ;
		for(int i = 0 ; i < actionString.length ; i ++) {
			if (name.equals(actionString[i])) return action[i] ;
		}
		return null ;
	}
	
	ImageIcon[] icon = new ImageIcon[iconString.length] ;
	
	ImageIcon iconForName(String name) {
		int n = -1 ;
		for(int i = 0 ; i < iconString.length ; i ++) {
			if (name.equals(iconString[i])) return icon[i] ;
		}
		return null ;
	}
	
	protected AbstractAction
			newAction , openAction , saveAction , saveAsAction , printAction , 
			pageAction , quitAction , aboutAction , prefsAction , clearAction , 
			selectAction , deleteAction , repAction , quadAction , normAction , 
			toolAction , dialAction , aspectAction  , zoomAction , zoomPAction , 
			zoomMAction , photoAction , helpAction , curveAction , pointOnCurveAction , 
			recSequenceAction , genSequenceAction , eulerAction , domainAction , pointAction , 
			lineAction , tangentAction , intersectionAction , equationAction  , markAction,
			textAction
	;
		
	AbstractAction[] action ;
	
/* ———————————————————————— CONSTRUCTEUR -———————————————————————————————— */

	public zone(edugraphe g) { 
		G = g ; outOfApplet = true ; dirName = System.getProperty("user.dir", null) ;
		construct() ; 
		fc = new JFileChooser(dirName) ;
		fc.addChoosableFileFilter(new TsmFilter("tsm")) ;
		fc.addChoosableFileFilter(new TsmFilter("png")) ;
		fc.addChoosableFileFilter(new TsmFilter("html")) ;
		fc.addChoosableFileFilter(new TsmFilter("eps")) ;
		ff = fc.getChoosableFileFilters() ;
		printJob = PrinterJob.getPrinterJob() ;
		pageForm = printJob.defaultPage() ;
	}

	public zone(JApplet a) { 
		AG = a ; url = a.getCodeBase() ; dirName = url.getPath() ; 
		construct() ; 
	}

	void construct() {
		setLayout (new BorderLayout()) ;
		T.setFloatable(false) ; 
		URL u ; ClassLoader cl = getClass().getClassLoader() ; ;
		
		for(int i = 0 ; i < iconString.length ; i++) {
			u = cl.getResource("images/" + iconString[i] + ".png") ;
			icon[i] = new ImageIcon(tkt.getImage(u)) ;
		}	
		
		newAction = new actionClass(dessin.extract("new") , KeyEvent.VK_N , FileKeyMask) ;
		openAction = new actionClass(dessin.extract("open") , KeyEvent.VK_O , FileKeyMask) ;
		saveAction = new actionClass(dessin.extract("save") , KeyEvent.VK_S , FileKeyMask) ;
		saveAsAction = new actionClass(dessin.extract("saveAs")) ;
		printAction = new actionClass(dessin.extract("print") , KeyEvent.VK_P , FileKeyMask) ;
		
		pageAction = new actionClass(dessin.extract("page")) ;		
		quitAction = new actionClass(dessin.extract("quit") , KeyEvent.VK_Q , FileKeyMask) ;
		aboutAction = new actionClass(dessin.extract("about")) ;
		prefsAction = new actionClass(dessin.extract("prefs") , KeyEvent.VK_P , KeyEvent.SHIFT_MASK , iconForName("fenetre")) ;
		clearAction = new actionClass(dessin.extract("clear")) ;
		
		selectAction = new actionClass(dessin.extract("select") , iconForName("select")) ;		
		deleteAction = new actionClass(dessin.extract("delete") , iconForName("effacer")) ;
		repAction = new actionClass(dessin.extract("rep")) ;
		quadAction = new actionClass(dessin.extract("quad")) ;
		normAction = new actionClass(dessin.extract("norm")) ;
		
		toolAction = new actionClass(dessin.extract("tool")) ;
		dialAction = new actionClass(dessin.extract("dial")) ;
		aspectAction = new actionClass(dessin.extract("aspect") , KeyEvent.VK_A  , KeyEvent.SHIFT_MASK , iconForName("palette")) ;
		zoomAction = new actionClass(dessin.extract("zoom") , iconForName("zoom")) ;
		zoomPAction = new actionClass(dessin.extract("zoomp") , KeyEvent.VK_I  , KeyEvent.SHIFT_MASK , iconForName("zoomp")) ;
		
		zoomMAction = new actionClass(dessin.extract("zoomm") , KeyEvent.VK_O  , KeyEvent.SHIFT_MASK , iconForName("zoomm")) ;		
		photoAction = new actionClass(dessin.extract("photo") , iconForName("photo")) ;
		helpAction = new actionClass(dessin.extract("help") , HelpKey , HelpKeyMask , iconForName("help")) ;
		curveAction = new actionClass(dessin.extract("curve") , iconForName("courbe")) ;		
		pointOnCurveAction = new actionClass(dessin.extract("pointoncurve") , iconForName("pointsurcourbe")) ;
				
		recSequenceAction = new actionClass(dessin.extract("recsequence") , iconForName("suiterec")) ;
		genSequenceAction = new actionClass(dessin.extract("gensequence") , iconForName("suitegen")) ;		
		eulerAction = new actionClass(dessin.extract("euler") , iconForName("euler")) ;
		domainAction = new actionClass(dessin.extract("domain") , iconForName("domaine")) ;		
		pointAction = new actionClass(dessin.extract("point") , iconForName("point")) ;	
			
		lineAction = new actionClass(dessin.extract("line") , iconForName("droite")) ;
		tangentAction = new actionClass(dessin.extract("tangent") , iconForName("tangente")) ;		
		intersectionAction = new actionClass(dessin.extract("intersection") , iconForName("intersection")) ;
		equationAction = new actionClass(dessin.extract("equation") , iconForName("equation")) ;
		markAction = new actionClass(dessin.extract("mark") , iconForName("marque")) ;
		
		textAction = new actionClass(dessin.extract("text")) ;
		
		action = new AbstractAction[] {
			newAction , openAction , saveAction , saveAsAction , printAction , 
			pageAction , quitAction , aboutAction , prefsAction , clearAction , 
			selectAction , deleteAction , repAction , quadAction , normAction , 
			toolAction , dialAction , aspectAction  , zoomAction , zoomPAction , 
			zoomMAction , photoAction , helpAction , curveAction , pointOnCurveAction , 
			recSequenceAction , genSequenceAction , eulerAction , domainAction , pointAction , 
			lineAction , tangentAction , intersectionAction , equationAction  , markAction ,
			textAction
		} ;
		
		setPreferredSize(new Dimension(dessin.W , dessin.H)) ;
		addMouseListener(this) ; addMouseMotionListener(this) ;
		
		D = new dial(this) ;
		B = new AboutBox() ;
		A = new AspectPane(this) ;
		P = new PrefsPane(this) ;
		
		
		dessin.setDefault(this) ;
	}
	
/* ———————————————————————— MÉTHODES -————————————————————————————————---- */

	public void paintComponent(Graphics g) { drawShapes((Graphics2D) g) ; }

    public int print(Graphics gg, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) return Printable.NO_SUCH_PAGE ;
		select() ; 
		
		Rectangle r = gg.getClipBounds() ;
		BufferedImage bi = new BufferedImage(r.x + r.width , r.y + r.height , 1) ;
		Graphics2D g = bi.createGraphics() ; g.setBackground(Color.white) ;
		g.clearRect(0 , 0 , r.x + r.width , r.y + r.height) ;
		
		Rectangle z = getBounds() ; 
		int w = (r.width - z.width) / 2 ;
		int h = (r.height - z.height) / 2 ;
		
		g.translate(r.x + w , r.y + h) ; 
		g.clipRect(0 , 0 , z.width , z.height) ;
		drawShapes(g) ;
		g.translate(-r.x - w , -r.y - h) ;
		g.setColor(Color.gray) ; 
		g.draw(new Rectangle(
			r.x + ((w > 0) ? w : 0) , 
			r.y + ((h > 0) ? h : 0) , 
			((w < 0) ? r.width : z.width) - 1 , 
			((h < 0) ? r.height : z.height) - 1
		)) ;
		
		gg.drawImage(bi , 0 , 0 , this) ;		
		return Printable.PAGE_EXISTS;
    }
  
	public void drawShapes(Graphics2D g) {
		int W = getWidth() , H = getHeight() ;
		if ((dessin.GRAPHICS == null) || (g != dessin.GRAPHICS)) dessin.setGraphics(g) ; 
		if ((dessin.W != W) || (dessin.H != H)) dessin.setSize(W , H) ;
		dessin.traceFond() ;
		if (quadrillageVisible) dessin.traceQuadrillage() ;
		if (repereVisible) dessin.traceRepere() ;
		for(int i = 0 ; i < GR.size() ; i++) {
			o = (objetG)GR.elementAt(i) ;
			if ((o instanceof area) && o.visible) { 
				o.trace() ;
			}
		}
		for(int i = 0 ; i < GR.size() ; i++) {
			o = (objetG)GR.elementAt(i) ;
			if ((o instanceof line) && o.visible) { 
				o.trace() ;
			}
		}
		for(int i = 0 ; i < GR.size() ; i++) {
			o = (objetG)GR.elementAt(i) ;
			if ((o instanceof point) && o.visible) {
				o.trace() ;
			}
		}
		if (od != null) {
			g.setColor(od.col) ;
			g.drawString(od.getTTT() , X , Y) ;
		}
		if ((zoom || photo) && (Pd != null)) {
			int px = Pd.x , py = Pd.y , qx = X , qy = Y ;
			if (px > qx) { px = qx ; qx = Pd.x ; }
			if (py > qy) { py = qy ; qy = Pd.y ; }
			Graphics2D g2 = (Graphics2D) g ;
			g2.setStroke(dashed) ;
			g2.setColor((zoom) ? Color.gray : Color.blue) ;
			g2.draw(new Rectangle2D.Float(px , py , qx - px , qy - py)) ;
			g2.setStroke(stroke) ;
		}
		if (create && (D.PARAMS.size() > 0)) {
			objetG ot = null ;
			if ((D.status == 8) && (D.PARAMS.size() == 1))
				ot = new droite(((point)D.PARAMS.elementAt(0)).p , dessin.mousePoint()) ;
			if (ot != null) ot.trace() ;
		}
	}		

	void del(objetG og) {
		for(Enumeration en = og.F.elements() ; en.hasMoreElements() ; ) del((objetG)en.nextElement()) ;
		GR.remove(og) ; og = null ;
	}
	
	void setNumeros() {
		for(int i = 0 ; i < GR.size() ; i++)  ((objetG)GR.elementAt(i)).no = i ;
	}
	
	void setCreate() {
		create = true ; modify = false ; delete = false ;
	}
	
	void setModify(objetG o) { 
		create = false ; modify = true ; delete = false ; 
		D.setObject(o) ;
	}

	

/* souris ________________________________________________________________________________*/

	void pres() {
		od = null ; repDetected = false ; if (zoom || photo) return ;
		for(int i = 0 ; i < GR.size() ; i++) {
			o = (objetG)GR.elementAt(i) ;
			if (((o instanceof point) || (o instanceof boxicon)) && o.proche()) { od = o ; return ; }
		}
		for(int i = 0 ; i < GR.size() ; i++) {
			o = (objetG)GR.elementAt(i) ;
			if ((o instanceof line) && o.proche()) { od = o ; return ; }
		}
		for(int i = 0 ; i < GR.size() ; i++) {
			o = (objetG)GR.elementAt(i) ;
			if ((o instanceof area) && o.proche()) { od = o ; return ; }
		}
		repDetected = dessin.repereProche() ;
	}

	public void mousePressed(MouseEvent e) {
		e.consume () ; dessin.MOUSE.setLocation(X = e.getX() , Y = e.getY()) ;
		if (zoom || photo) Pd = new Point(X , Y) ;
		dessin.mouseStart(X , Y) ;
		pres() ; 
	}
		
	public void mouseDragged(MouseEvent e) {
		e.consume () ; dessin.MOUSE.setLocation(X = e.getX() , Y = e.getY()) ;
		if (od != null) {
			od.deplace() ;
			if (D.isVisible()) D.refresh() ; 
		}
		else if (repDetected) dessin.moveOrigin() ;
		repaint() ;
		
	}
		
	public void mouseClicked(MouseEvent e) {
		e.consume () ; dessin.MOUSE.setLocation(X = e.getX() , Y = e.getY()) ;
		pres() ;
		if (od == null) { D.ask(X , Y) ; return ; }
		if (od instanceof boxicon) {
			if (e.isShiftDown()) { A.setObject(od) ; return ; }
			else od = ((boxicon)od).o ;
		}
		if (e.isShiftDown() && od.hasicon && (od.name.length() > 0)) {
			od.BI.pf.setLocation(dessin.abs(X) , dessin.ord(Y)) ;
			od.BI.Xo = od.BI.Yo = 3 ;
			od.BI.recalc() ;
		}
		else if (create) D.ask(od) ;
		else if (modify) setModify(od) ;
		else if (delete) del(od) ; 
		repaint() ;
	}
		
	public void mouseReleased(MouseEvent e) { 
		e.consume () ; dessin.MOUSE.setLocation(X = e.getX() , Y = e.getY()) ;
		dessin.setShapes() ;
		if (zoom || photo) {
			double  xg = (X < Pd.x) ? dessin.abs(X) : dessin.abs(Pd.x) ,
					xd = (X < Pd.x) ? dessin.abs(Pd.x) : dessin.abs(X) ,
					yb = (Y > Pd.y) ? dessin.ord(Y) : dessin.ord(Pd.y) ,
					yh = (Y > Pd.y) ? dessin.ord(Pd.y) : dessin.ord(Y) ;
			if (photo) { 
				if (G != null) photo() ; photo = false ; 
			}
			else {
				if ((xg < xd) && (yb < yh)) dessin.coords(new double[]{xg , xd , yb , yh} , true) ;
				zoom = false ;
			}
			Pd = null ;
		}
		repaint() ;
	}
	
	public void mouseMoved(MouseEvent e) {
		e.consume () ; dessin.MOUSE.setLocation(X = e.getX() , Y = e.getY()) ;
		pres() ; repaint() ;
	}
	
	public void mouseExited(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}


// ===========================================================================================
	
	void nouveau_def() {
		parseLine(dfenetre) ;
		dessin.coords(new double[]{dessin.XG , dessin.XD , dessin.YB , dessin.YH} , true) ;
		parseLine("ajouter(barre)") ;
		tconfiguration = "barre(" ;
		parseLine(dconfiguration) ;
		tconfiguration += ")" ;
		parseLine("ajouter(dialogue)") ;
		setPreferredSize(new Dimension(dessin.W , dessin.H)) ; if (outOfApplet) G.pack() ;
		nouveau() ;
	}
			
	void nouveau() {
		o = od = null ; GR.clear() ; 
		if (outOfApplet) G.setTitle(dessin.RB.getString("frameConstructor")) ;
		D.setVisible(false) ;
		fileName = null ;
		repaint() ;
	}
    
	void ouvrir() {
		fc.setFileFilter(ff[1]) ;  
		if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
			readFile(fc.getSelectedFile()) ;
			dirName = fc.getCurrentDirectory().getName() ;
			String name = fc.getSelectedFile().getName() ;
			int n = name.lastIndexOf('.') ;
			if (n >= 0) name = name.substring(0 , n) ;
			G.setTitle(fileName = name) ;
		}
	}
	
	void sauver() {
		if (fileName == null) sauverSous() ;
		else {
			String name = new String(fileName) ;
			int n = name.lastIndexOf('.') ;
			if (n >= 0) name = name.substring(0 , n) ;
			if (name.length() > 0) writeFile(new File(fc.getCurrentDirectory() + "/" + name + ".tsm")) ;
			else sauverSous() ;
		}
	}
   
	void sauverSous() {
		fc.setFileFilter(ff[1]) ;
		if (fc.showSaveDialog(this) != JFileChooser.APPROVE_OPTION) return ;
		File dir = fc.getCurrentDirectory() , f ;
		String  name = (fc.getSelectedFile() != null) ? fc.getSelectedFile().getName() : "" ;
		int n = name.lastIndexOf('.') ;
		if (n >= 0) name = name.substring(0 , n) ;
		if (name.length() == 0) return ;
		String  desc = fc.getFileFilter().getDescription() ;
		f = new File(fc.getCurrentDirectory() + "/" + name + desc.substring(1)) ;
		try {
			if (desc.equals("*.tsm")) {
				writeFile(f) ; 
				fileName = name ; 
				G.setTitle(fileName) ;
			}
			else if (desc.equals("*.png")) {
				BufferedImage bi = new BufferedImage(dessin.W , dessin.H , 1) ; 
				drawShapes(bi.createGraphics()) ;
				ImageIO.write(bi, "png", f) ; 
			}
			else if (desc.equals("*.html")) writeHtml(f) ; 
			else if (desc.equals("*.eps")) {
				Graphics2D gg = new EpsGraphics2D() ;
				gg.clipRect(0 , 0 , dessin.W , dessin.H) ;
				drawShapes(gg) ;
				String output = gg.toString() ;
				PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f))) ;
				writer.println(output) ;
				writer.flush() ;
			}
			fc.setCurrentDirectory(dir) ;
			dirName = fc.getCurrentDirectory().getName() ;
		}
		catch(IOException ioexc) { System.err.println(ioexc) ; }
	}

	void enpage() {
		pageForm = printJob.pageDialog(pageForm);
        printJob.setPrintable(this , pageForm) ;
	}
	
	void imprimer() {
		printJob.setPrintable(this , pageForm) ;
		if (printJob.printDialog()) {
            try { printJob.print() ; }
            catch (Exception ex) { System.err.println(ex) ; }
        }
	}
	
	void quitter() { System.exit(0) ; }
	
	void about() {
		B.setResizable(false) ; B.setVisible(true) ; B.show() ;
	}
	
	void prefs() {
		P.setVisible(!P.isVisible()) ;
	}
	
	void clear() { o = od = null ; GR.clear() ; select() ; repaint() ; }
	
	void select() {
		create = false ; modify = true ; delete = false ; D.setVisible(false) ;
	}
	
	public void delete() {
		create = false ; modify = false ; delete = true ; 
		D.setVisible(false) ;
	}
	
	void affRepere() { 
		repereVisible = !repereVisible ; dessin.pathAxis() ; repaint() ;
		P.checkRep.setSelected(repereVisible) ;
		if (outOfApplet) G.checkRep.setSelected(repereVisible) ;
	}
	
	void affQuadrillage() { 
		quadrillageVisible = !quadrillageVisible ; dessin.pathGrid() ; repaint() ; 
		P.checkQuad.setSelected(quadrillageVisible) ;
		if (outOfApplet) G.checkQuad.setSelected(quadrillageVisible) ;
	}
	
	void normalise() { dessin.normal() ; repaint() ; }

	void affBarre() { T.setVisible(!T.isVisible()) ; repaint() ; }
	
	void affDial() { 
		if (D.vis) remove(D) ; else add(D , "South") ;
		D.vis = !D.vis ; revalidate() ; repaint() ;
		if (outOfApplet) G.checkDial.setSelected(D.vis) ;
	}
	
	void aspect() { A.setVisible(!A.isVisible()) ; }
	
	void photo() {
		int px = Pd.x , py = Pd.y , qx = X , qy = Y ;
		if (px > qx) { px = qx ; qx = Pd.x ; }
		if (py > qy) { py = qy ; qy = Pd.y ; }
		Graphics2D gg ; photo = false ;
		fc.setFileFilter(ff[4]) ;
		File dir = fc.getCurrentDirectory() , f ;
		if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
			String  desc = fc.getFileFilter().getDescription() ,
					name = fc.getSelectedFile().getName() ;
			int n = name.lastIndexOf('.') ;
			if (n >= 0) name = name.substring(0 , n) ;
			if (desc.equals("*.png")) {
				try {
					f = new File(fc.getCurrentDirectory() + "/" + name + ".png") ;
					BufferedImage bi = new BufferedImage(dessin.W , dessin.H , 1) ;
					gg = bi.createGraphics() ;
					drawShapes(gg) ;
					ImageIO.write(bi.getSubimage(px , py , qx - px , qy - py) , "png", f) ; 
				}
				catch(IOException ioexc) { } ;
			}
			else if (desc.equals("*.eps")) {
				try {
					f = new File(fc.getCurrentDirectory() + "/" + name + ".eps") ;
					EpsGraphics2D geps = new EpsGraphics2D(name + ".eps" , f , px , py , qx , qy ) ;
					geps.setClip(px , py , qx - px , qy - py) ; ///_____________________
					drawShapes(geps) ;
					geps.close() ;
				}
				catch(IOException ioexc) { } ;
			}
			fc.setCurrentDirectory(dir) ;
		}
	}

	void affManuel() { 
		if (H == null) H = new HelpPane(this) ; H.setVisible(!H.isVisible()) ;
	}
	
	

// ===========================================================================================

	public class actionClass extends AbstractAction {
		int n ; String id ;
		public actionClass(String[] arg) {
			super(arg[0]) ; 
			putValue(SHORT_DESCRIPTION, arg[1]) ;
			n = Integer.parseInt(arg[2]) ;
			id = actionString[n - 1] ;
		}
		
		public actionClass(String[] arg , int k , int m) {
			this(arg) ; 
			putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(k , m)) ;
		}
		
		public actionClass(String[] arg , int k , int m , ImageIcon ic) {
			this(arg) ;
			putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(k , m)) ;
			putValue(SMALL_ICON, ic) ;
		}
		
		public actionClass(String[] arg , ImageIcon ic) {
			this(arg) ;
			putValue(SMALL_ICON, ic) ;
		}
		
		public void actionPerformed(ActionEvent e) {
			zoom = false ;
			if (n > 23) { setCreate() ; D.setCreate(n - 23) ; }
			else switch(n) {
				case 1 : nouveau() ; break ;
				case 2 : ouvrir() ; break ;
				case 3 : sauver() ; break ;
				case 4 : sauverSous() ; break ;
				case 5 : imprimer() ; break ;
				case 6 : enpage() ; break ;
				case 7 : quitter() ; break ;
				case 8 : about() ; break ;
				case 9 : prefs() ; break ;
				case 10 : clear() ; break ;
				case 11 : select() ; break ;
				case 12 : delete() ; break ;
				case 13 : affRepere() ; break ;
				case 14 : affQuadrillage() ; break ;
				case 15 : normalise() ; break ;
				case 16 : affBarre() ; break ;
				case 17 : affDial() ; break ;
				case 18 : aspect() ; break ;
				case 19 : zoom = true ; break ;
				case 20 : dessin.zoomPlus() ; break ;
				case 21 : dessin.zoomMoins() ; break ;
				case 22 : photo = true ; break ;
				case 23 : affManuel() ; break ;
			}
		}
	}
	
// ===========================================================================================

// ===========================================================================================

	public class TsmFilter  extends javax.swing.filechooser.FileFilter {
	
		public String desc = "tsm" ;
	
		public TsmFilter(String d) { desc = d ; }

		public boolean accept(File f) { 
			if (f.isDirectory()) return true ;
			String name = f.getName() ;
			int n = name.lastIndexOf('.') ;
			if (n < 0) return false ;
			if (name.substring(n + 1).equalsIgnoreCase(desc)) return true ;
			else return false ;
		}
  
		public String getDescription() { return "*." + desc ; }  
  
	}
	
// ===========================================================================================

/* enregistrement  _________________________________________________________________________*/

	void activate(AbstractAction ac) { 
		if (ac != null) ac.actionPerformed(new ActionEvent(this , 0 , "")) ; 
	}

	void configureT(String[] A) {
		for(int i = 0 ; i < A.length ; i++) {
			if (A[i].equals("space")) T.add(Box.createRigidArea(new Dimension(20 , 5))) ;
			else if (A[i].equals("tab")) T.add(Box.createHorizontalGlue()) ;
			else T.add(actionForName(A[i])) ;
			if (tconfiguration.indexOf('(') < tconfiguration.length() - 1) tconfiguration += "," ;
			tconfiguration += A[i] ;
		}
	}
	
// ===========================================================================================

	void writeFile(File file) {
		PrintWriter writer = null ;
		try {
			FileOutputStream fos = new FileOutputStream(file) ; 
			Charset cs = Charset.forName("UTF-8") ;
			OutputStreamWriter osw = new OutputStreamWriter(fos , cs) ;
			BufferedWriter bw = new BufferedWriter(osw) ;
			writer = new PrintWriter(bw) ;
			writer.println(": tsm created by edugraphe 1.1 on " + new Date() + "  charset : " + cs) ;
			writer.println(dessin.getDatas()) ;
			if (T.isVisible()) {
				writer.println("ajouter(barre)") ;
				writer.println(tconfiguration) ;
			}
			if (D.vis) writer.println("ajouter(dialogue)") ;
			int cc = GR.size() ; ; objetG og ; 
			for (int i = 0 ; i < cc ; i++ ) {
				og = (objetG)GR.elementAt(i) ;
				og.no = i ;
			}
			for (int i = 0 ; i < cc ; i++ ) writer.println(((objetG)GR.elementAt(i)).getCommand()) ;
			writer.flush() ;
		}
		catch (Exception e) { System.err.println(e) ; }
		finally {
			try { writer.close() ; }
			catch (Exception e) { System.err.println(e) ; }
		}
	}
	
	void writeHtml(File file) {
		PrintWriter writer = null ;
		String fname = file.getName() ; 
		int j = fname.lastIndexOf('.') ;
		if (j >= 0) fname = fname.substring(0 , j) ;
		try {
			FileOutputStream fos = new FileOutputStream(file) ; 
			Charset cs = Charset.forName("UTF-8") ;
			OutputStreamWriter osw = new OutputStreamWriter(fos , cs) ;
			BufferedWriter bw = new BufferedWriter(osw) ;
			writer = new PrintWriter(bw) ;
			writer.println("<HTML>") ;
			writer.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">") ;
			writer.println("<HEAD>") ;
			writer.print("<TITLE>") ; writer.print(fname) ; writer.println("</TITLE>") ;
			writer.println("</HEAD>") ;
			writer.println("<BODY><center>") ;
			writer.println("<APPLET archive=\"edugraphe.jar\" code=\"applet_edugraphe\" width=700 height=500>") ;
			writer.println("<param name=\"fichier\" value=\"") ; 
			writer.println(dessin.getDatas() + " : ") ;
			if (T.isVisible()) {
				writer.println("ajouter(barre)" + " : ") ;
				writer.println(tconfiguration + " : ") ;
			}
			if (D.vis) writer.println("ajouter(dialogue)" + " : ") ;
			int cc = GR.size() ; objetG og ; 
			for (int i = 0 ; i < cc ; i++ ) {
				og = (objetG)GR.elementAt(i) ;
				og.no = i ;
			}
			for (int i = 0 ; i < cc ; i++ ) writer.println(((objetG)GR.elementAt(i)).getCommand() + " : " ) ;
			writer.println("\" >") ;
			writer.println("Votre navigateur ne supporte pas Java.") ;
			writer.println("</APPLET>") ;
			writer.println("</center></BODY>") ;
			writer.println("</HTML>") ;
			writer.flush() ;
		}
		catch (Exception e) { System.err.println(e) ; }
		finally {
			try { writer.close() ; }
			catch (Exception e) { System.err.println(e) ; }
		}
	}
	
	boolean exists(File file) {
		boolean b ;
		try { FileReader fr = new FileReader(file) ; b = true ; }
		catch (FileNotFoundException e) { b = false ; }
		return b ;
	}

	void setFile(File f) {
		File pf = f.getParentFile() ;
		if (pf != null) fc.setCurrentDirectory(new File(pf.getAbsolutePath())) ;
		fc.setSelectedFile(f) ;
		dirName = fc.getCurrentDirectory().getName() ;
		String  name = f.getName() ;
		int n = name.lastIndexOf('.') ;
		if (n >= 0) name = name.substring(0 , n) ;
		G.setTitle(fileName = name) ;
	}
	
	void readFile(File file) {
		if (!file.exists()) return ;
		removeAll() ; T.removeAll() ; GR.clear() ; o = od = null ; 
		tconfiguration = "barre(" ;
		BufferedReader lecteur = null , br = null ;
		try {
			FileInputStream fis = new FileInputStream(file) ; 
			Charset cs = Charset.forName("UTF-8") ;
			InputStreamReader isr = new InputStreamReader(fis , cs) ;
			br = new BufferedReader(isr) ; 
			
			lecteur = new BufferedReader (new FileReader(file)) ;
			String ligne ;
			while ((ligne = br.readLine()) != null)
				if ((ligne.length() > 0) && (ligne.charAt(0) != ':')) {
					parseLine(ligne) ;
				}
			;
		}
		catch (Exception e) { System.err.println(e) ; }
		finally {
			try { lecteur.close() ; br.close() ; }
			catch (Exception e) { System.err.println(e) ; }
		}
		tconfiguration += ")" ;
		
		setPreferredSize(new Dimension(dessin.W , dessin.H)) ;
		if (outOfApplet) G.pack() ;
		select() ; repaint() ;
	}

	void parseLine(String ligne) {
		int p = ligne.indexOf('(') , q = ligne.lastIndexOf(')') ; 
		if ((p < 0) || (q <= p)) return ;
		String com = (ligne.substring(0 , p)).trim() , args = ligne.substring(p + 1 , q) ; 
		Vector V = new Vector() ; int nargs ;
		StringTokenizer st = new StringTokenizer(args , ",") ;
		while (st.hasMoreTokens()) V.add(st.nextToken().trim()) ;
		String[] A = new String[nargs = V.size()] ; V.toArray(A) ;
		if (com.equals("barre")) configureT(A) ; 
		else parseCommand(com , A) ; 
	}
	
/* interpréter un fichier enregistré ____________________________________________________________________*/

	void parseCommand(String com , String[] A) {
		if (com.equals("ajouter")) {
			int nargs = A.length ; String a ;
			for (int i = 0 ; i < nargs ; i++) {
				a = A[i] ;
				if (a == null) continue ;
				if (a.equals("barre")) {
					if (outOfApplet) G.getContentPane().add(T , "North") ;
					else AG.getContentPane().add(T , "North") ;
				}
				else if (a.equals("dialogue")) {
					D.vis = true ; add(D , "South") ;
				}
			}
		}
		else if (com.equals("fenetre")) dessin.setDatas(A) ;
		else if (com.equals("courbe")) line.buildCurve(A) ;
		else if (com.equals("pointsurcourbe")) point.buildPointOnCurve(A) ;
		else if (com.equals("suiterec")) point.buildRecSequence(A) ;
		else if (com.equals("suitegen")) point.buildGenSequence(A) ;
		else if (com.equals("euler")) line.buildEuler(A) ;
		else if (com.equals("domaine")) area.buildDomain(A) ;
		else if (com.equals("droite")) line.buildLine(A) ;
		else if (com.equals("pointlibre")) point.buildPoint(A) ;
		else if (com.equals("tangente")) line.buildSlope(A) ;
		else if (com.equals("pointinter")) point.buildPointInter(A) ;
		else if (com.equals("equation")) line.buildEquation(A) ;
		else if (com.equals("marque")) point.buildMark(A) ;
		else if (com.equals("boxicon")) area.buildIcon(A) ;
		else if (com.equals("text")) area.buildText(A) ;
	}

}

