//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.geom.GeneralPath ;
import java.awt.geom.Point2D ;
import java.util.Vector ;

public class tangente extends line {

/*_______________________________________ VARIABLES ________________________________________*/

	line l ;
	Point2D.Float p ;
	boolean hasPoint = false ;
	pointsurcourbe pc ;
	float a ;
	boolean ta , tg , td ;
	droite tgd = new droite() ;
	demidroite tag = new demidroite() , tad = new demidroite() ;
	GeneralPath P = new GeneralPath() ;
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public tangente(line li , Point2D.Float pf) {
		l = li ; p = pf ; col = SLOPE_COLOR ; S = P ;
		li.F.add(this) ; tgd.type = tag.type = tad.type = 3 ;
		type = 0 ; recalc() ;
	}
	
	public tangente(pointsurcourbe pc) {
		this.pc = pc ; l = pc.l ; p = pc.p ; col = SLOPE_COLOR ; S = P ;
		pc.F.add(this) ; hasPoint = true ; tgd.type = tag.type = tad.type = 3 ;
		type = 1 ; recalc() ;
	}
	
/*________________________________________ MÉTHODES ________________________________________*/


// 1. MISE À JOUR __________________________________________________________________________

	void recalc() {
		if (hasPoint) p.setLocation(pc.p) ; else l.locate(p) ;
		visible = def(p) ; cid = "" ;
		a = (float)l.computeDerivative(p.x) ; ta = (def(a) || Double.isInfinite(a)) ;
		if (ta) {
			tgd.pa = p ;
			if (Float.isInfinite(a)) tgd.pb.setLocation(p.x , p.y + 1) ;
			else  tgd.pb.setLocation(p.x + 1 , p.y + a) ;
			tgd.recalc() ;
			cid = tgd.cid ;
			tg = td = false ;
		}
		else {
			a = (float)l.computeLeftDerivative(p.x) ; tg = (def(a) || Double.isInfinite(a)) ;
			if (tg) {
				tag.pa = p ;
				if (Float.isInfinite(a)) tag.pb.setLocation(p.x , p.y + ((a < 0) ? 1 : -1)) ;
				else tag.pb.setLocation(p.x - 1 , p.y - a) ;
				tag.recalc() ;
				cid = "(g) " + tag.cid ;
			}
			a = (float)l.computeRightDerivative(p.x) ; td = (def(a) || Double.isInfinite(a)) ;
			if (td) {
				tad.pa = p ;
				if (Float.isInfinite(a)) tad.pb.setLocation(p.x , p.y + ((a > 0) ? 1 : -1)) ;
				else tad.pb.setLocation(p.x + 1 , p.y + a) ;
				tad.recalc() ;
				if (cid.length() > 0) cid += "   " ; cid += "(d) " + tad.cid  ;
			}
		}
		isDef = (ta || tg || td) ;
		calcShape() ;
		refresh() ;
	}

	void calcShape() {
		P.reset() ; if (!isDef) return ;
		if (ta) { tgd.calcShape() ; P.append(tgd.S , false) ; }
		else {
			if (tg) { tag.calcShape() ; P.append(tag.S , false) ; }
			if (td) { tad.calcShape() ; P.append(tad.S , false) ; }
		}
	}

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________

	boolean proche(Point2D.Float p) {
		if (ta) return tgd.proche(p) ;
		else {
			if (tg && td) return (tag.proche(p) || tad.proche(p)) ;
			else if (tg) return tag.proche(p) ;
			else if (td) return tad.proche(p) ;
			else return false ;
		}
	}
	
	boolean proche() { 
		if (!isDef) return false ;
		if (ta) return tgd.proche() ;
		else {
			boolean pg = (tg) ? tag.proche() : false , pd = (td) ? tad.proche() : false ;
			return (pg || pd) ;
		}
	}

// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { if (ta) return strslope[0] ; else return strslope[1] ;}
	
//  4. DÉPLACEMENTS ________________________________________________________________________

	void deplace() {
		if (hasPoint) return ;
		p.setLocation(mousePoint()) ; recalc() ; 
	}

//  5. LOCALISATION ________________________________________________________________________

	Point2D.Float defaultLocation() {
		if (!isDef) return  p ;
		if (ta) return tgd.defaultLocation() ;
		else {
			if (tg && !td) return tag.defaultLocation() ;
			else if (!tg && td) return tad.defaultLocation() ;
			else {
				Point2D.Float   m = startPoint() ,
								mg = tag.pointProj(m) ,
								md = tad.pointProj(m) ;
				if (!tag.contains(mg)) mg.setLocation(tag.pa) ;
				if (!tad.contains(md)) md.setLocation(tad.pa) ;
				if (m.distance(mg) < m.distance(md)) return mg ;
				else return md ;
			}
		}
	}

	void locate(pointsurcourbe ps) {
		locate(ps.p) ;
	}
	
	void setParamFor(pointsurcourbe ps) {
		if (ta) tgd.setParamFor(ps) ;
		else {
			if (tg && td) {
				if (dotProduct(tag.pa , ps.p , tag.pb) < 0) tad.setParamFor(ps) ; else tag.setParamFor(ps) ;
			}
			else if (tg) tag.setParamFor(ps) ;
			else if (td) tad.setParamFor(ps) ;
		}
	}
			
	void locate(Point2D.Float p) {
		if (ta) tgd.locate(p) ;
		else {
			if (tg && td) {
				Point2D.Float pg = tag.pointProj(p) , pd = tad.pointProj(p) ;
				if (!tag.contains(pg)) pg.setLocation(tag.pa) ;
				if (!tad.contains(pd)) pd.setLocation(tad.pa) ;
				if (p.distance(pg) < p.distance(pd)) p.setLocation(pg) ; else p.setLocation(pd) ;
			}
			else if (tg) tag.locate(p) ;
			else if (td) tad.locate(p) ;
		}
	}

//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() { 
		StringBuffer sb = new StringBuffer("tangente(") ; 
		if (hasPoint) {
			sb.append(1) ; sb.append(',') ; sb.append(pc.no) ;
		}
		else {
			sb.append(0) ; sb.append(',') ; sb.append(l.no) ;
			sb.append(',') ; sb.append(p.x) ;
			sb.append(',') ; sb.append(p.y) ;
		}
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}
	
//  7. DIALOGUES ____________________________________________________________________________

	int getStatus() { return CREATE_TANGENT ; }
	
	void writeDatas() {
		D.setIcon(0 , strslope[2]) ;
		if (hasName()) D.addIcon(0 , new Object[]{getName() , (l.hasName()) ? null : strsymb[0]}) ;
		if (l.hasName()) D.addIcon(0 , new Object[]{strslope[3] , l.getName()}) ;
		if ((hasPoint)) {
			if (def(pc.p)) D.addIcon(0 , new Object[]{strslope[4] , (pc.hasName()) ? pc.getName() : form(pc.p) , strsymb[1]}) ;
			if (isDef) {
				if (ta) D.addIcon(0 , new Object[]{ tgd.getIdent() , strsymb[0]}) ;
				else {
					if (tg) D.addIcon(0 , new Object[]{strslope[6] ,  tag.getIdent() , strsymb[0]}) ;
					if (td) D.addIcon(0 , new Object[]{strslope[7] ,  tad.getIdent() , strsymb[0]}) ;
				}
			}
		}
		else {
			D.addIcon(0 , strslope[5]) ;
			D.TF[0].setText(def(p.x) ? form(p.x) : "") ;
			if (isDef) {
				D.setIcon(1) ;
				if (ta) D.addIcon(1 , new Object[]{ tgd.getIdent() , strsymb[0]}) ;
				else {
					if (tg) D.addIcon(1 , new Object[]{strslope[6] ,  tag.getIdent() , strsymb[0]}) ;
					if (td) D.addIcon(1 , new Object[]{strslope[7] ,  tad.getIdent() , strsymb[0]}) ;
				}
			}
		}
	}

	void readDatas() { 
		if(hasPoint) return ; 
		form f = calcul.toForm(D.TF[0].getText()) ;
		nbre n = (f != null) ? f.eval(calcul.EVAL_POLYS).getNbre() : null ;
		p.x = (n == null) ? Float.NaN : (float)n.val ;
		recalc() ;
	}

//  9. CALCULS _____________________________________________________________________________

	double computeDerivative(double xv) {  
		if (ta)  return - tgd.b / tgd.a ;
		else if (xv < p.x) { if (tg) return - tag.b / tag.a ; else return Double.NaN ; }
		else if (xv > p.x) { if (td) return - tad.b / tad.a ; else return Double.NaN ; }
		if (tg && td) {
			float xg = - tag.b / tag.a , xd = - tad.b / tad.a ;
			if (xg == xd) return xg ; else return Double.NaN ;
		}
		else if (tg) return - tag.b / tag.a ;
		else if (td) return - tad.b / tad.a ;
		else return Double.NaN ;
	}

//  10. INTERSECTION _______________________________________________________________________

	Vector getInterWith(line l) {
		Vector V = new Vector() ; if (!isDef) return V ;
		if (l instanceof droite) return ((droite)l).getInterWith(this) ;
		else if (l instanceof tangente) {
			tangente T = (tangente)l ;
			if (T.isDef) {
				if (ta) V.addAll(tgd.getInterWith(T)) ;
				else {
					if (tg) V.addAll(tag.getInterWith(T)) ;
					if (td) V.addAll(tad.getInterWith(T)) ;
				}
			}
		}
		else if (l instanceof courbe) {
			courbe C = (courbe)l ;
			if (ta) V.addAll(tgd.getInterWith(C)) ;
			else {
				if (tg) V.addAll(tag.getInterWith(C)) ;
				if (td) V.addAll(tad.getInterWith(C)) ;
			}
		}
		return V ;
	}

}
