//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

/**
POSITIONS. Cette classe représente un ensemble de réels vérifiant une relation avec un réel <i>a</i> donné.
Il y a exactement huit types de positions déterminés par la valeur des trois paramètres <i>left</i> , <i>exact</i> et <i>right</i>. <br>
La méthode toString() renvoie une chaîne décrivant chacun de ces types:
<table align="center" CELLPADDING="5" CELLSPACING="5">
	<tr> <td><i>chaîne</i></td> <td><i> nom </i></td> <td><i>ensemble ou relation</i></td> <td><i>left</i></td> <td><i>exact</i></td><td><i>right</i></td> </tr>
	<tr> <td><b>N</b></td> <td>non définie</td> <td> ensemble vide </td> <td>false</td><td>false</td><td>false</td></tr>
	<tr> <td><b>></b></td> <td>strictement supérieure</td> <td> x > <i>a</i> </td><td>false</td><td>false</td><td>true</td></tr>
	<tr> <td><b>=</b></td> <td>égale</td> <td>x = <i>a</i> </td><td>false</td><td>true</td><td>false</td></tr>
	<tr> <td><b><</b></td> <td>strictement inférieure</td> <td>x < <i>a</i> </td><td>true</td><td>false</td><td>false</td></tr>
	<tr> <td><b>I</b></td> <td>inconnue</td> <td> </td><td>true</td><td>true</td><td>true</td></tr>
	<tr> <td><b>=></b></td> <td>égale ou supérieure</td> <td>ensemble de tous les réels</td> <td>  x => <i>a</i> </td><td>false</td><td>true</td><td>true</td></tr>
	<tr> <td><b>!=</b></td> <td>différente</td> <td>  x < <i>a</i>  ou  x > <i>a</i> </td><td>true</td><td>false</td><td>true</td></tr>
	<tr> <td><b><=</b></td> <td>inférieure ou égale</td> <td> x <= <i>a</i> </td><td>true</td><td>true</td><td>false</td></tr>
</table>
*/


public class posi extends calcul {

/*__________________________________ VARIABLES STATIQUES ___________________________________*/

/**
Position <i>non définie</i>. 
*/
	public final static posi pNone = new posi(false , false , false) ;

/**
Position <i>strictement supérieure</i>. 
*/
	public final static posi pSupS = new posi(false , false , true) ;

/**
Position <i>égale</i>. 
*/
	public final static posi pEgal = new posi(false , true , false) ;

/**
Position <i>égale ou supérieure</i>. 
*/
	public final static posi pSupE = new posi(false , true , true) ;

/**
Position <i>strictement inférieure</i>. 
*/
	public final static posi pInfS = new posi(true , false , false) ;

/**
Position <i>différente</i>. 
*/
	public final static posi pDiff = new posi(true , false , true) ;

/**
Position <i>inférieure ou égale</i>. 
*/
	public final static posi pInfE = new posi(true , true , false) ;

/**
Position <i>inconnue</i>. 
*/
	public final static posi pAll = new posi(true , true , true) ;
	
/*_______________________________________ VARIABLES ________________________________________*/

/**
Indique si les réels strictement inférieurs à <i>a</i> appartiennent à l'ensemble. 
*/
	boolean left = false ;
	
/**
Indique si le réel <i>a</i> appartient à l'ensemble. 
*/
	boolean exact = false ;
	
/**
Indique si les réels strictement supérieurs à <i>a</i> appartiennent à l'ensemble. 
*/
	boolean right = false ;
	
/*______________________________________ CONSTRUCTION ______________________________________*/

/**
Crée une position <i>non définie</i>. 
*/
	public posi() {}

/**
Crée une position à partir de trois booléens.<br>
@param l indique si les réels strictement inférieurs à <i>a</i> appartiennent à l'ensemble
@param e indique si le réel <i>a</i> appartient à l'ensemble
@param r indique si les réels strictement supérieurs à <i>a</i> appartiennent à l'ensemble
*/
	public posi(boolean l , boolean e , boolean r) { left = l ; exact = e ; right = r ; }
	
/**
Crée une position à partir d'une position existante.
*/
	public posi(posi p) { left = p.left ; exact = p.exact ; right = p.right ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. TESTS _________________________________________________________________________________

/**
Indique si cette position est définie.
*/
	boolean isDef() { return (left || exact || right) ; }
	
/**
Indique si cette position est <i>inconnue</i>.
*/
	boolean isAll() { return (left && exact && right) ; }
	
/**
Indique si cette position est <i>égale</i>.
*/
	boolean isEqu() { return (!left && exact && !right) ; }
	
// 2. OPÉRATIONS LOGIQUES ___________________________________________________________________

/**
Renvoie une copie de cette position.
*/
	posi ide() { return new posi(left , exact , right) ; }

/**
Renvoie la négation de cette position.
*/
	posi neg() { return new posi(!left , !exact , !right) ; }
	
// 3. CALCULS _______________________________________________________________________________

/**
Renvoie l'opposée de cette position.
*/
	posi opp() { return new posi(right , exact , left) ; }

/**
Renvoie la combinaison de cette position avec une autre position.<br>
Cette opération est définie par la table suivante :
<table align="center" BORDER="0" CELLPADDING="5" CELLSPACING="5">
<tr> <td>    </td> <td> <b>N</b>  </td> <td> <b>></b>  </td> <td> <b>=</b>  </td> <td> <b><</b>  </td> <td> <b>I</b> </td> <td> <b>=></b> </td> <td> <b>!=</b> </td> <td> <b><=</b> </td> </tr>
<tr> <td> <b>N</b>  </td> <td> N  </td> <td> N  </td> <td> N  </td> <td> N  </td> <td> N </td> <td> N  </td> <td> N  </td> <td> N  </td> </tr>
<tr> <td> <b>></b>  </td> <td> N  </td> <td> >  </td> <td> >  </td> <td> I  </td> <td> I </td> <td> >  </td> <td> I  </td> <td> I  </td> </tr>
<tr> <td> <b>=</b>  </td> <td> N  </td> <td> >  </td> <td> =  </td> <td> <  </td> <td> I </td> <td> => </td> <td> != </td> <td> <= </td> </tr>
<tr> <td> <b><</b>  </td> <td> N  </td> <td> I  </td> <td> <  </td> <td> <  </td> <td> I </td> <td> I  </td> <td> I  </td> <td> <  </td> </tr>
<tr> <td> <b>I</b>  </td> <td> N  </td> <td> I  </td> <td> I  </td> <td> I  </td> <td> I </td> <td> I  </td> <td> I  </td> <td> I  </td> </tr>
<tr> <td> <b>=></b> </td> <td> N  </td> <td> >  </td> <td> => </td> <td> I  </td> <td> I </td> <td> => </td> <td> I  </td> <td> I  </td> </tr>
<tr> <td> <b>!=</b> </td> <td> N  </td> <td> I  </td> <td> != </td> <td> I  </td> <td> I </td> <td> I  </td> <td> I  </td> <td> I  </td> </tr>
<tr> <td> <b><=</b> </td> <td> N  </td> <td> I  </td> <td> <= </td> <td> <  </td> <td> I </td> <td> I  </td> <td> I  </td> <td> <= </td> </tr>
</table>
@param p une position
*/
	posi combine(posi p) {
		posi r = new posi() ;
		if ((left && p.right) || (right && p.left)) r.left = r.exact = r.right = true ;
		if (left && (p.left || p.exact)) r.left = true ;
		if (exact && p.left) r.left = true ;
		if (exact && p.exact) r.exact = true ;
		if (exact && p.right) r.right = true ;
		if (right && (p.exact || p.right)) r.right = true ;
		return r ;
	}
	
/**
Renvoie le produit <i>zéro - zéro</i> de cette position avec une autre position.<br>
Cette opération est définie par la table suivante :
<table align="center" BORDER="0" CELLPADDING="5" CELLSPACING="5">
<tr> <td>    </td> <td> <b>N</b>  </td> <td> <b>></b>  </td> <td> <b>=</b>  </td> <td> <b><</b>  </td> <td> <b>I</b> </td> <td> <b>=></b> </td> <td> <b>!=</b> </td> <td> <b><=</b> </td> </tr>
<tr> <td> <b>N</b>  </td> <td> N  </td> <td> N  </td> <td> N  </td> <td> N  </td> <td> N </td> <td> N  </td> <td> N  </td> <td> N  </td> </tr>
<tr> <td> <b>></b>  </td> <td> N  </td> <td> >  </td> <td> =  </td> <td> <  </td> <td> I </td> <td> =>  </td> <td> !=  </td> <td> <=  </td> </tr>
<tr> <td> <b>=</b>  </td> <td> N  </td> <td> =  </td> <td> =  </td> <td> =  </td> <td> = </td> <td> = </td> <td>= </td> <td> = </td> </tr>
<tr> <td> <b><</b>  </td> <td> N  </td> <td> <  </td> <td> =  </td> <td> >  </td> <td> I </td> <td> <=  </td> <td> !=  </td> <td> =>  </td> </tr>
<tr> <td> <b>I</b>  </td> <td> N  </td> <td> I  </td> <td> =  </td> <td> I  </td> <td> I </td> <td> I  </td> <td> I  </td> <td> I  </td> </tr>
<tr> <td> <b>=></b> </td> <td> N  </td> <td> =>  </td> <td> = </td> <td> <=  </td> <td> I </td> <td> => </td> <td> I  </td> <td> <= </td> </tr>
<tr> <td> <b>!=</b> </td> <td> N  </td> <td> !=  </td> <td> = </td> <td> !=  </td> <td> I </td> <td> I  </td> <td> !=  </td> <td> I  </td> </tr>
<tr> <td> <b><=</b> </td> <td> N  </td> <td> <=  </td> <td> = </td> <td> =>  </td> <td> I </td> <td> <=  </td> <td> I  </td> <td> => </td> </tr>
</table>
@param p une position
*/
	posi multZZ(posi p) {
		posi r = new posi() ;
		if (left) {
			if (p.left) r.right = true ;
			if (p.exact) r.exact = true ;
			if (p.right) r.left = true ;
		}
		if (exact && p.isDef()) r.exact = true ;
		if (right) {
			if (p.left) r.left = true ;
			if (p.exact) r.exact = true ;
			if (p.right) r.right = true ;
		}
		return r ;
	}
	
/**
Renvoie le produit <i>"zéro - plus"</i> de cette position avec une autre position.<br>
Cette opération est définie par la table suivante :
<table align="center" BORDER="0" CELLPADDING="5" CELLSPACING="5">
<tr> <td>    </td> <td> <b>N</b>  </td> <td> <b>></b>  </td> <td> <b>=</b>  </td> <td> <b><</b>  </td> <td> <b>I</b> </td> <td> <b>=></b> </td> <td> <b>!=</b> </td> <td> <b><=</b> </td> </tr>
<tr> <td> <b>N</b>  </td> <td> N  </td> <td> N  </td> <td> N  </td> <td> N  </td> <td> N </td> <td> N  </td> <td> N  </td> <td> N  </td> </tr>
<tr> <td> <b>></b>  </td> <td> N  </td> <td> >  </td> <td> >  </td> <td> >  </td> <td> > </td> <td> >  </td> <td> >  </td> <td> > </td> </tr>
<tr> <td> <b>=</b>  </td> <td> N  </td> <td> =  </td> <td> =  </td> <td> =  </td> <td> = </td> <td> = </td> <td>= </td> <td> = </td> </tr>
<tr> <td> <b><</b>  </td> <td> N  </td> <td> <  </td> <td> <  </td> <td> <  </td> <td> < </td> <td> <  </td> <td> <  </td> <td> <  </td> </tr>
<tr> <td> <b>I</b>  </td> <td> N  </td> <td> I  </td> <td> I  </td> <td> I  </td> <td> I </td> <td> I  </td> <td> I  </td> <td> I  </td> </tr>
<tr> <td> <b>=></b> </td> <td> N  </td> <td> =>  </td> <td> => </td> <td> =>  </td> <td> => </td> <td> => </td> <td> =>  </td> <td> => </td> </tr>
<tr> <td> <b>!=</b> </td> <td> N  </td> <td> !=  </td> <td> != </td> <td> !=  </td> <td> != </td> <td> !=  </td> <td> !=  </td> <td> !=  </td> </tr>
<tr> <td> <b><=</b> </td> <td> N  </td> <td> <=  </td> <td> <= </td> <td> <=  </td> <td> <= </td> <td> <=  </td> <td> <=  </td> <td> <= </td> </tr>
</table>
@param p une position
*/
	posi multZP(posi p) {
		posi r = new posi() ;
		if (left && p.isDef()) r.left = true ;
		if (exact && p.isDef()) r.exact = true ;
		if (right && p.isDef()) r.right = true ;
		return r ;
	}
	
/**
Renvoie une chaîne décrivant cette position.
*/
	public String toString() {
		if (!left && !exact && !right) return " N" ;
		if (!left && !exact &&  right) return " >" ;
		if (!left &&  exact && !right) return " =" ;
		if (!left &&  exact &&  right) return "=>" ;
		if ( left && !exact && !right) return " <" ;
		if ( left && !exact &&  right) return "!=" ;
		if ( left &&  exact && !right) return "<=" ;
		if ( left &&  exact &&  right) return " I" ;
		return "" ;
	}
	
}

/*

Table d'addition
 +  |   N  >  =  <  I => != <=
------------------------------
  N |   N  N  N  N  N  N  N  N
  > |   N  >  >  I  I  >  I  I
  = |   N  >  =  <  I => != <=
  < |   N  I  <  <  I  I  I  <
  I |   N  I  I  I  I  I  I  I
 => |   N  > =>  I  I =>  I  I
 != |   N  I !=  I  I  I  I  I
 <= |   N  I <=  <  I  I  I <=

Table de multiplication : 0 0		Table de multiplication : 0 P		Table de multiplication : 0 N	
 *  |   N  >  =  <  I => != <=		 *  |   N  >  =  <  I => != <=		 *  |   N  >  =  <  I => != <=
------------------------------		------------------------------		------------------------------
  N |   N  N  N  N  N  N  N  N		  N |   N  N  N  N  N  N  N  N		  N |   N  N  N  N  N  N  N  N
  > |   N  >  =  <  I => != <=		  > |   N  >  >  >  >  >  >  >		  > |   N  <  <  <  <  <  <  <
  = |   N  =  =  =  =  =  =  =		  = |   N  =  =  =  =  =  =  =		  = |   N  =  =  =  =  =  =  =
  < |   N  <  =  >  I <= != =>		  < |   N  <  <  <  <  <  <  <		  < |   N  >  >  >  >  >  >  >
  I |   N  I  =  I  I  I  I  I		  I |   N  I  I  I  I  I  I  I		  I |   N  I  I  I  I  I  I  I
 => |   N =>  = <=  I =>  I <=		 => |   N => => => => => => =>		 => |   N <= <= <= <= <= <= <=
 != |   N !=  = !=  I  I !=  I		 != |   N != != != != != != !=		 != |   N != != != != != != !=
 <= |   N <=  = =>  I <=  I =>		 <= |   N <= <= <= <= <= <= <=		 <= |   N => => => => => => =>

*/

