//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

/**
POLYNÔMES.
*/

public class poly extends form {

/*_______________________________________ VARIABLES ________________________________________*/

/**
Liste des coefficients.
*/
	liste C = new liste() ; 
	
/**
Chaîne représentant la variable.
*/
	String base = "" ; 
	
/**
Degré.
*/
	int deg = 0 ;
    
/**
Nombre de termes non nuls.
*/
	int nt = 0 ;
    
/**
Expression représentant cet objet.
*/
	form pform ;
    
/*______________________________________ CONSTRUCTION ______________________________________*/

    public poly() { }
	
    public poly(String b) { this(new nbre(1) , b , 1) ; }
	
    public poly(String b , int d) { this(new nbre(1) , b , d) ; }
	
    public poly(mono m) {  this(m.coeff , m.base , m.deg) ; }
	
	public poly(nbre c , String b , int d) { C.resize(1) ; C.set(c , 0) ; maj(C , b , d) ; } 
	
    public poly(liste c , String b) { maj(c , b , c.deg()) ; }
	
    public poly(poly p) { this(p.C.copie() , new String(p.base) , p.deg) ; }
	
    public poly(liste c , String b , int d) { maj(c , b , d) ; }

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void maj(liste c) { maj(c , deg) ; }

	void maj(liste c , String b , int d) { base = b.trim() ; maj(c , d) ; }

	void maj(liste co , int de) { 
		C = co ; 
		deg = de ; 		
		C.bot() ; while(C.hasNext()) { if (((nbre)C.next()).val != 0)  break ; C.remA() ; }
		C.top() ; while(C.hasPrev()) { if (((nbre)C.prev()).val != 0)  break ; deg -- ; C.remD() ; } 
		nt = 0 ; 
		nbre c ; 
		int d = deg + 1 ; 
		liste A = new liste() ; 
		C.top() ; while(C.hasPrev()) {
			c = (nbre)C.prev() ; d -- ;
			if (c.val == 0) continue ;
			nt++ ;
			if (d == 0) A.add(new nbre(c)) ;
			else A.add(new mono(c , base , d)) ;
		}
		if (nt == 0) { pform = new nbre(0) ; deg = 0 ; }
		else if (nt == 1) pform = A.first() ;
		else pform = nsom(A) ;
		str = pform.toString() ;		
	}

	form ascentForm() { 
		nbre c ; int d = deg - C.deg() - 1 ; 
		liste A = new liste() ; form r ;
		C.bot() ; while(C.hasNext()) {
			c = (nbre)C.next() ; 
			d ++ ; 
			if (c.val == 0) continue ;
			if (d == 0) A.add(new nbre(c)) ; 
			else A.add(new mono(c , base , d)) ;
		}
		if (A.length() == 0) r = new nbre(0) ; 
		else if (A.length() == 1) r = A.first() ; 
		else r = nsom(A) ;
		return r ;
	}

// 2. TESTS _________________________________________________________________________________

	boolean estNbre() { return ((nt == 0) || ((nt == 1) && (deg == 0))) ; }
	
	boolean estMono() { return ((nt == 1) && (deg != 0)) ; }
	
	boolean estPoly() { return (nt > 1) ; }

	boolean estDef() {
		boolean r = true ;
		C.bot() ; while(C.hasNext()) { if (Double.isNaN(((nbre)C.next()).val)) r = false ; break ; }
		return r ;
	}

	boolean hasCoeff(int i) {
		if (i > deg) return false ;
		int l = C.length() ; if (l == 0) return false ;
		if (i < deg - C.deg()) return false ;
		return ((i <= deg) && (i >= deg - C.deg())) ;
	}
	
// 3. COPIE & INFO __________________________________________________________________________
	
	form copie() { return new poly(this) ; }
    
	form getForm() { return pform ; }
	
	int getPrior() { return pform.getPrior() ; }
	
	nbre getNbre() { if (pform instanceof nbre) return (nbre)pform ; else return null ; }

	mono getMono() { if (pform instanceof mono) return (mono)pform ; else return null ; }

	poly getPoly() { if (pform instanceof poly) return (poly)pform ; else return null ; }

	double getDoubleValue() { if (pform instanceof nbre) return ((nbre)pform).val ; else return Double.NaN ; }
	
	nbre getLCoeff() { if (estNbre()) return (nbre)getForm() ; else return (nbre)C.last() ; }

	mono getLMono() { return new mono(getLCoeff() , base , deg) ; }

	nbre getTCoeff() { if (estNbre()) return (nbre)getForm() ; else return (nbre)C.first() ; }

	mono getTMono() { return new mono(getTCoeff() , base , deg - C.deg()) ; }

	void addCoeffs(int i , int j) {
		if (j < i) return ;
		if (C.length() == 0) {
			C.resize(j - i + 1) ; for (int k = 0 ; k < j - i + 1 ; k++) C.set(new nbre(0) , k) ;
			deg = j ;
		}
		else {
			int mind = deg - C.deg() ;
			for(int k = i ; k < mind ; k++) C.ins(new nbre(0) , 0) ;
			for(int k = deg ; k < j ; k++) C.add(new nbre(0)) ;
			if (j > deg) deg = j ;
		}
	}
	
	nbre getCoeff(int i) {
		if (!hasCoeff(i)) return null ; else return (nbre)C.get(i + C.deg() - deg) ; 
	}
	
	void setCoeff(form f , int i) {
		if (!hasCoeff(i)) return ; else C.set(f , i + C.deg() - deg) ; 
	}
	
// 4. CALCULS _______________________________________________________________________________

	void Popp() { C.bot() ; while(C.hasNext()) ((nbre)C.next()).Nopp() ; maj(C) ; }

	void Padd(nbre n) { addCoeffs(0 , 0) ; getCoeff(0).Nadd(n) ; maj(C) ; }

	void Pmult(nbre n) { 
		C.bot() ; while(C.hasNext()) ((nbre)C.next()).Nmult(n) ; maj(C) ;
	}

	void Pmult(mono m) { 
		C.bot() ; while(C.hasNext()) ((nbre)C.next()).Nmult(m.coeff) ; maj(C , base , deg + m.deg) ;
	}

	void Pdiv(nbre k) { 
		nbre n = new nbre(k) ; n.Ninv() ;
		C.bot() ; while(C.hasNext()) ((nbre)C.next()).Nmult(n) ; maj(C) ;
	}

	void Padd(poly P) {
		if (P.C.length() == 0) return ;
		addCoeffs(P.deg - P.C.deg() , P.deg) ;
		for(int k = P.deg - P.C.deg() ; k <= P.deg ; k++) getCoeff(k).Nadd(P.getCoeff(k)) ;
		maj(C) ;
	}

	void Pmult(poly P) {
		nbre a = new nbre(0) , b ;
		P.C.top() ; while (a.estEgal(0) && P.C.hasNext()) a = (nbre)P.C.prev() ;
		if ((C.length() == 0) || a.estEgal(0)) {
			C.resize(1) ; C.set(new nbre(0) , 0) ; maj(C , base , 0) ; return ;
		}
		liste L = C.copie() ;
		C.bot() ; while (C.hasNext()) ((nbre)C.next()).Nmult(a) ;
		
		while(P.C.hasPrev()) {
			a = (nbre)P.C.prev() ;
			C.ins(new nbre(0) , 0) ;
			if (a.val != 0) {
				C.bot() ; L.bot() ; while(L.hasNext()) {
					b = new nbre((nbre)L.next()) ; b.Nmult(a) ; ((nbre)C.next()).Nadd(b) ;
				}
			}
		}
		maj(C , base , deg + P.deg) ;
	}

    void Ppow(int n) { 
		if (n == 0) { C.resize(1) ; C.set(new nbre(1) , 0) ; maj(C , base , 0) ; }
		else if (n < 2) return ;
		poly R = new poly(this) ;
		for(int i = 1 ; i < n ; i++) R.Pmult(this) ;
		maj(R.C , R.deg) ;
	}

	form Gopp() { poly p = new poly(this) ; p.Popp() ; return p ; }

	form Ginv() { 
		if (nt == 1) return getLMono().Ginv() ;
		else return ninv(this) ; 
	}

	form Gadd(form f) {
		poly p = new poly (this) , pf ;
		if (f instanceof nbre) { p.Padd((nbre)f) ; return p ; }
		if (f instanceof mono) { 
			pf = new poly((mono)f) ;
			if (pf.base.equals(base)) { p.Padd(pf) ; return p ; }
		}
		if (f instanceof poly) {
			pf = (poly)f ; if (pf.base.equals(base)) { p.Padd(pf) ; return p ; }
		}
		return nsom(this , f) ;
	}

	form Gmult(form f) {
		poly p = new poly (this) , pf ;
		if (f instanceof nbre) { p.Pmult((nbre)f) ; return p ; }
		if (f instanceof mono) {
			pf = new poly((mono)f) ;
			if (pf.base.equals(base)) { p.Pmult(pf) ; return p ; }
		}
		if (f instanceof poly) {
			pf = (poly) f ;
			if (pf.base.equals(base)) { p.Pmult(pf) ; return p ; }
		}
		return npro(this , f) ;
	}

// 5. CHAÎNES _______________________________________________________________________________

	public String toString() { return pform.toString() ; }

// 6. BOÎTES ________________________________________________________________________________

    public box toBox() { return pform.toBox() ; }

// 7. SUBSTITUTIONS _________________________________________________________________________

	form subst(String s , form t) {
		form res ;
		if (t instanceof nbre) res = subst((nbre)t) ;
		else if (t instanceof mono) res = subst((mono)t) ;
		else if (t instanceof poly && ((poly)t).base.equals(s)) res = subst((poly)t) ;
		else res = pform.subst(s , t) ;
		return res ;
	}
	
	form subst(nbre N) {
		nbre c , v ; nbre r = new nbre(0) ;
		for (int i = deg - C.deg() ; i <= deg ; i++) {
			c = getCoeff(i) ; if (c.val == 0) continue ;
			v = new nbre(N) ;
			if (i < 0) { v.Npow(-i) ; v.Ninv() ; }
			else v.Npow(i) ;
			v.Nmult(c) ;
			r.Nadd(v) ;
		}
		return r ;
	}

	form subst(mono M) {
		nbre c ; poly r = new poly(new nbre(0) , M.base , 0) , p ; mono m ;
		for (int i = deg - C.deg() ; i <= deg ; i++) {
			c = getCoeff(i) ; if (c.val == 0) continue ;
			m = new mono(M) ;
			if (i < 0) { m.Mpow(-i) ; m.Minv() ; }
			else m.Mpow(i) ;
			m.Mmult(c) ;
			r.Padd(new poly(m)) ;
		}
		return r ;
	}

	form subst(poly P) {
		nbre c ; liste L = new liste() ; poly p ;
		if (deg < C.deg()) {
			for (int i = deg - C.deg() ; i < 0 ; i++) {
				c = getCoeff(i) ; if (c.val == 0) continue ;
				L.add(npro(new nbre(c) , npow(new poly(P) , new nbre(i)))) ;
			}
		}
		poly r = new poly(new nbre(0) , P.base , 0) ;
		for (int i = 0 ; i <= deg ; i++) {
			c = getCoeff(i) ; if ((c == null) || (c.val == 0)) continue ;
			p = new poly(P) ; p.Ppow(i) ; p.Pmult(c) ;
			r.Padd(p) ;
		}
		if (L.length() > 0) L.ins(r , 0) ;
		form res = (L.length() == 0) ? r : nsom(L) ;
		return res.eval() ;
	}

// 8. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(String s , double v) { return toDouble(s , v , s , v) ; }

	double toDouble(String s , double v , String t , double w) {
		double x =  (s.equals(base)) ? v : (t.equals(base)) ? w : Double.NaN ;
		if (Double.isNaN(x)) return x ;
		double r = 0d ; nbre c ;
		for (int i = deg - C.deg() ; i <= deg ; i++) {
			c = getCoeff(i) ;
			if ((c != null) && (c.val != 0)) r += c.val * Math.pow(x , i) ;
		}
		return r ;
	}

// 9. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(int l) { return new poly(this) ; }
	
// 10. DÉRIVÉE ______________________________________________________________________________

	form toDer(String v) {
		if (!base.equals(v) || estNbre()) return new nbre(0) ;
		liste A = new liste() ; nbre c ;
		for (int i = deg - C.deg() ; i <= deg ; i++) {
			c = new nbre(getCoeff(i)) ;
			c.Nmult(new nbre(i)) ;
			A.add(c) ;
		}
		poly p = new poly(A , base , deg - 1) ;
		if (p.estNbre()) return p.getCoeff(0) ; else return p ;
	}

// 11. LIMITES ______________________________________________________________________________

	equg toEquivG(String sx , vois k) {
		if (sx.equals(base)) return new equg(this , k) ;
		else return null ; 
	}
	
	form taylorForm (String sv , nbre l , int o) {
		if (!sv.equals(base) || Double.isNaN(l.val) || Double.isInfinite(l.val) || (l.val == 0)) return copie() ;
		poly s = new poly(base) ; s.Padd(l) ;
		poly p = new poly(this) ; 
		return p.subst(s).eval() ; 
	}
	
	vois operLimit(String sx , vois k) { 
		double l = k.L.val ;
		if (!estDef() || !base.equals(sx) || Double.isNaN(l)) return vois.vndef("ndef") ;
		mono m ;
		if (Double.isInfinite(l)) {
			m = getLMono() ; return m.operLimit(sx , k) ;
		}
		else if (l == 0) {
			m = getTMono() ; vois r = m.operLimit(sx , k) ; double vl = r.L.val ;
			if (Double.isNaN(vl) || Double.isInfinite(vl) || (vl == 0) || k.plim.isEqu() || (deg == 0)) return r ;
			nbre n ;
			for(int i = 1 ; i <= C.deg() ; i++) {
				n = (nbre)C.get(i) ; if (n.val == 0) continue ;
				m = new mono(n , sx , deg - C.deg() + i) ;
				vois vd = m.operLimit(sx , k) ;
				r.plim = vd.plim ;
				break ;
			}
			return r ;
		}
		else {
			form tf = taylorForm(sx , k.L , 3) ;
			return tf.operLimit(sx , new vois(new nbre(0) , k.plim)) ;
		}
	}
	
}
