//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.geom.Point2D ;

public class pointsurcourbe extends point {
	
/*_______________________________________ VARIABLES ________________________________________*/

/**
*   L'objet sur lequel est situé ce point.
*/
	line l ;

/**
*   Distance à un point de la droite sur laquelle est situé ce point.
*/
	double radius ;
	
/**
*   Paramètre permettant de placer ce point. 
* <ul>
* <li> si ce point M est sur une courbe , c'est son abscisse x<sub>M</sub> </li>
* <li> si ce point M est sur la droite (AB) , c'est le réel k tel que M est barycentre 
* du système (A , 1 - k) (B , k) </li>
* </ul>
*/
	double param ;
	
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public pointsurcourbe(line li , Point2D.Float pf) {
		S = E ; 
		l = li ; 
		l.F.add(this) ; 
		col = colf = l.col ;
		type = (l instanceof droite) ? 1 : 0 ;
		p.setLocation(pf) ; 
		maj() ;
	}
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void maj() { 
		l.setParamFor(this) ; 
		recalc() ; 
	}
	
	void recalc() { 
		l.locate(this) ; 
		isDef = (l.isDef && def(p)) ;
		calcShape() ;
		refresh() ; 
	}

//  4. DÉPLACEMENTS ________________________________________________________________________

	void deplace() { 
		p.setLocation(absG(MOUSE.x) , ord(MOUSE.y)) ; 
		maj() ; 
	}
	
//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() { 
		StringBuffer sb = new StringBuffer("pointsurcourbe(") ; sb.append(p.x) ;
		sb.append(',') ; sb.append(p.y) ;
		sb.append(',') ; sb.append(l.no) ;
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}
	
// 7. DIALOGUES ____________________________________________________________________________

	int getStatus() { return CREATE_POINT_ON_CURVE ; }
	
	void writeDatas() {
		D.setIcon(0 , strpoint[1]) ;
		if (hasName()) D.addIcon(0 , new Object[]{getName() , strsymb[0]}) ;
		if (l.hasName()) D.addIcon(0 , new Object[]{strpointon[0] , l.getName() , strsymb[0]}) ;
		if ((l instanceof droite) || (l instanceof tangente)) {
			D.TF[0].setText(def(p) ? form(p) : "") ;
			D.setIcon(1) ;
		}
		else if (l instanceof courbe) {
			D.addIcon(0 , new Object[]{strpointon[1] , ((courbe)l).sv , strsymb[3]}) ;
			D.TF[0].setText(def(p.x) ? form(p.x) : "") ;
			D.setIcon(1 , strpointon[2]) ;
			if (def(p.y)) D.addIcon(1 , new Object[]{ strsymb[3] , form(p.y) }) ;
			else D.addIcon(1 , strpointon[3]) ;
		}
	}

	void readDatas() {
		putValues(p , D.TF[0].getText()) ;
		maj() ;
	}
	
}