//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.geom.Point2D ;
import java.awt.geom.Ellipse2D ;
import java.util.Vector ;
import java.util.StringTokenizer ;

/**
*   OBJETS 0D : objets dont le dessin est assimilé à un ou plusieurs points.
*   Les méthodes statiques de cette classe permettent de créer ou de reconstruire les objets qui en héritent .
*/

public class point extends objetG  {

/*_______________________________________ VARIABLES ________________________________________*/

/**
*   Point-utilisateur.
*/
	Point2D.Float p =  new Point2D.Float(Float.NaN , Float.NaN) ;
	
/**
*   Forme du point.
*/
	Ellipse2D.Float E = new Ellipse2D.Float() ;

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void calcShape() {
		E.setFrame(p.x - t * UNIT / UX , p.y - t * UNIT / UY , 2 * t * UNIT / UX , 2 * t * UNIT / UY) ;
	}

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________

	boolean proche() { 
		if (!isDef) return false ;
		return mouseIsNear(p) ; 
	}
		
	void trace() {
		if (!isDef || (S == null)) return ;
		GRAPHICS.setColor(colf) ; GRAPHICS.fill(TO_SCREEN.createTransformedShape(S)) ;
		GRAPHICS.setColor(col) ; GRAPHICS.draw(TO_SCREEN.createTransformedShape(S)) ;
	}	
	
// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { return strpoint[0] ; }
	
	String getAcceptTTT(int c , int n) {
		String s = "" ;
		switch (c) {
			case CREATE_LINE : s = strline[1 + n] + strpoint[0] ; break ;
			case CREATE_TANGENT : if (this instanceof pointsurcourbe) s = strslope[4] + getDefaultTTT() ; break ;
		}
		return s ;
	}
	
//  4. DÉPLACEMENTS ________________________________________________________________________

//  5. LOCALISATION ________________________________________________________________________

	Point2D.Float defaultLocation() { return new Point2D.Float(p.x , p.y) ; }

	void locate (Point2D.Float pf) { pf.setLocation(p) ; }

//  6. ENREGISTREMENT ______________________________________________________________________

/**
*   Construit un point libre.
*/
	static void buildPoint(String[] A) {
		pointlibre pl = new pointlibre(new Point2D.Float(fltv(A[0]) , fltv(A[1]))) ;
		affectNameColor(pl , 2 , A) ;
		Z.GR.add(pl) ;
	}

/**
*   Construit un point sur une courbe.
*/
	static void buildPointOnCurve(String[] A) {
		Point2D.Float pf = new Point2D.Float(fltv(A[0]) , fltv(A[1])) ;
		line bl = (line) Z.GR.elementAt(intv(A[2])) ;
		pointsurcourbe ps = new pointsurcourbe(bl , pf) ;
		affectNameColor(ps , 3 , A) ;
		Z.GR.add(ps) ;
	}

/**
*   Construit une suite définie par récurrence.
*/
	static void buildRecSequence(String[] A) {
		suiterec sr = new suiterec(
			(courbe) Z.GR.elementAt(intv(A[0])) , 
			new Point2D.Float(fltv(A[1]) , fltv(A[2])) , 
			intv(A[5])
		) ;
		affectNameColor(sr , 3 , A) ;
		Z.GR.add(sr) ;
	}

/**
*   Construit une suite définie par une fonction.
*/
	static void buildGenSequence(String[] A) {
		suitegen sg = new suitegen(
			calcul.toForm(A[0]) ,
			intv(A[1]) ,
			dblv(A[2]) ,
			intv(A[5])
		) ;
		affectNameColor(sg , 3 , A) ;
		Z.GR.add(sg) ;
	}

/**
*   Construit un point d'intersection.
*/
	static void buildPointInter(String[] A) {
		pointinter pi = new pointinter(
			new Point2D.Float(fltv(A[0]) , fltv(A[1])) ,
			(line) Z.GR.elementAt(intv(A[2])) ,
			(line) Z.GR.elementAt(intv(A[3]))
		) ;
		affectNameColor(pi , 4 , A) ;
		Z.GR.add(pi) ;
	}

/**
*   Construit une marque.
*/
	static void buildMark(String[] A) {
		marque m = new marque(boolv(A[0]) , fltv(A[1])) ;
		affectNameColor(m , 2 , A) ;
		Z.GR.add(m) ;
	}

// 7. DIALOGUES ____________________________________________________________________________

	String getId() {
		if (hasName()) return name ;
		else return "(" + form(p.x) + " , " + form(p.y) + ")" ;
	}

//  8. CRÉATION ____________________________________________________________________________

/**
*   Crée un point libre qui a les coordonnées de la souris.
*/
	static pointlibre createPoint() { return new pointlibre(gridPoint()) ; }

/**
*   Crée un point libre.
*/
	static pointlibre createPoint(String[] info) {
		if(info[0].length() == 0) return null ;
		boolean accepte = true ; form f ; nbre n = null ;
		double nval[] = new double[] { Double.NaN , Double.NaN} ; int i = 0 ;
		if (info.length == 1) {
			StringTokenizer st = new StringTokenizer(info[0] , "\u0028\u0029" + ISEP) ;
			while(st.hasMoreTokens() && (i < 2)) {
				f = calcul.toForm(st.nextToken()) ;
				n = (f != null) ? f.eval(calcul.EVAL_POLYS).getNbre() : null ;
				if (n != null) nval[i] = n.val ;
				i ++ ;
			}
		}
		else {
			for(i = 0 ; i < 2 ; i++) {
				f = calcul.toForm(info[i]) ;
				n = (f != null) ? f.eval(calcul.EVAL_POLYS).getNbre() : null ;
				if (n != null) nval[i] = n.val ;
			}
		}
		Point2D.Float pf = new Point2D.Float((float)nval[0] , (float)nval[1]) ;
		if (def(pf)) return new pointlibre(pf) ; else return null ;
	}
	
/**
*   Crée un point sur une courbe.
*/
	static pointsurcourbe createPointOnCurve(objetG og) {
		if (og instanceof line) return new pointsurcourbe((line)og , mousePoint()) ;
		else return null ;
	}

/**
*   Crée une suite définie par une fonction.
*/
	static suitegen createGenSequence(String[] info) {
		nbre n = null ;
		form f ;
		form e = calcul.toForm(info[0]) ; if (e == null) return null ;
		int n0 = 0 ;
		f = calcul.toForm(info[1]) ; 
		if (f != null) {
			n = f.eval(calcul.EVAL_POLYS).getNbre() ;
			n0 = ((Math.floor(n.val) != n.val) || (n.val < 0)) ? 0 : (int)n.val ;
		}
		double u0 = Double.NaN ; 
		f = calcul.toForm(info[2]) ;
		if (f != null) {
			n = f.eval(calcul.EVAL_POLYS).getNbre() ;
			u0 = (n == null) ? Double.NaN : n.val ;
		}
		int it = 5 ;
		f = calcul.toForm(info[3]) ;
		if (f != null) {
			n = f.eval(calcul.EVAL_POLYS).getNbre() ;
			it = ((n == null) || (Math.floor(n.val) != n.val) || (n.val < 0)) ? 5 : (int)n.val ;
		}
		return new suitegen(e , n0 , u0 , it) ;
	}
	
/**
*   Crée un point d'intersection.
*/
	static pointinter createPointInter(Vector PA) {
		if (PA.size() > 1) {
			Object o1 = PA.elementAt(0) , o2 = PA.elementAt(1) ;
			if ((o1 instanceof line) && (o2 instanceof line)) return new pointinter(mousePoint() , (line)o1 , (line)o2) ;
		}
		return null ;
	}
}

