//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
OPÉRATEURS.
*/

public class oper extends calcul {

/**
Chaîne qui représente l'opérateur.
*/
	String nom = "" ; 
	
/**
Priorité.
*/
	int prior = 0 ;

/**
Poids : nombre d'opérandes.
*/
	int poids = 0 ;

/**
Niveau d'évaluation.
*/
	int level = NO_EVAL ;

/**
Applique ou pas l'associativité.
*/
	boolean assoc = false ;
	
/**
Applique ou pas la distributivité.
*/
	boolean expandable = true ;
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public oper() {}
	
	public oper(String s) { nom = s ; prior = Oprs.indexOf(s) ; }

	public oper(String s , int p) { nom = s ; prior = Oprs.indexOf(s) ; poids = p  ; }

	public oper(String s , int pr , int po) { nom = new String(s) ; prior = pr ; poids = po  ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. COPIE & INFO __________________________________________________________________________
	
	oper copie() { return this ; }
	
// 2. CHAÎNES _______________________________________________________________________________

	static String listeToString(liste F , String sep , boolean par) {
		StringBuffer r = new StringBuffer((F.length() > 0) ? F.first().toString() : "") ; 
		while (F.hasNext()) {
			r.append(sep) ; r.append(F.next().toString()) ; 
		}
		if (par) return "(" + new String(r) + ")" ;
		else return new String(r) ;
	}
	
	String toOrdString(liste F) { 
		if (poids == 0) return "" ; 
		else return listeToString(F , "  " + nom + "  " , false) ; 
	}
	
	String toOrdStringBinaire(liste F) { 
		if (F.length() != 2) return "" ;
		form a = F.first() ; boolean b = (a.getPrior() <= prior) ;
		StringBuffer r = new StringBuffer() ;
		if (b) r.append('(') ; r.append(a.toString()) ; if (b) r.append(')') ;
		r.append(nom) ;
		a = F.next() ; b = (a.getPrior() < prior) ;
		if (b) r.append('(') ; r.append(a.toString()) ; if (b) r.append(')') ;
		return new String(r) ;
	}

	String toOrdString(liste F , String sep , String p , String nsep) { 
		if (F.length() == 0) return "" ;
		form a = F.first() ; 
		StringBuffer r = new StringBuffer(a.toString()) ; 
		if (F.length() == 1) return new String(r) ;
		else if (a.getPrior() < prior) { r.insert(0 , '(') ; r.append(')') ; }
		boolean b , c ; String sa ;
		while(F.hasNext()) {
			a = F.next() ; 
			b = (a.getPere().equals(p) && (a.op != null) && (a.op.prior == pru)) ;
			c = false ;
			if (b) { 
				r.append(nsep) ; 
				a = a.F.first() ;
				sa = a.toString() ;
				c = (a.getPrior() <= prior) ;
			} 
			else {
				sa = a.toString() ;
				if ((sa.length() > 0) && p.equals(sa.substring(0,1))) {
					r.append(nsep) ;
					sa = sa.substring(1) ;
				}
				else {
					r.append(sep) ; 
					c = (a.getPrior() < prior) ;
				}
			}
			if (c) r.append('(') ; 
			r.append(sa) ; 
			if (c) r.append(')') ;
		}
		return new String(r) ; 
	}

// 3. BOÏTES ________________________________________________________________________________

	boolean estFonctionConnue() { return ((prior == pri) && (indice(nom , FONCTIONS_CONNUES) >= 0) && (poids == 1)) ; }

	boolean noParenth() { return (estFonctionConnue() && (indice(nom , new String[]{"abs" , "rac" , "sqrt" , "exp"}) >= 0)) ; }
	
	static box listeToBox(liste F , String sep , boolean par) {
		box r = new box() ; if (F.length() == 0) return r ;
		r = F.first().toBox() ; 
		while (F.hasNext()) { r.append(sep) ; r.append(F.next().toBox()) ; }
		if (par) r.parenth() ;
		return r ;
	}
	
	box toBox(liste F) { 
		if (poids == 0) return new box() ; 
		else return listeToBox(F , "  " + nom + "  " , false) ; 
	}
	
	box toBox(liste F , String sep , String p , String nsep) { 
		box r = new box() ; 
		if (F.length() == 0) return r ;
		form a = F.first() ; box s = a.toBox() ;
		if (F.length() == 1) return s ;
		else if (a.getPrior() < prior) s.parenth() ; 
		r.append(s) ;
		boolean b , c ; String sa ;
		while(F.hasNext()) {
			a = F.next() ; 
			b = (a.getPere().equals(p) && (a.op != null) && (a.op.prior == pru)) ;
			c = false ;
			if (b) { 
				r.append(nsep) ; 
				a = a.F.first() ; 
				c = (a.getPrior() <= prior) ;
			} 
			else {
				sa = a.toString() ;
				if ((sa.length() > 0) && p.equals("-") && p.equals(sa.substring(0,1))) {
					r.append(nsep) ;
					a = a.Gopp().eval(EVAL_SIGNS) ;
				}
				else r.append(sep) ; 
			}
			c = (a.getPrior() < prior) ;
			s = a.toBox() ;
			if (c) s.parenth() ; 
			r.append(s) ; 
		}
		return r ;
	}

	box knownToBox(box r , form a) {
		box s = a.toBox() ; String t = a.toString() ; boolean b = ((t.indexOf('(') >= 0) || (t.indexOf(')') >= 0)) ;
		if (b || (a.getPrior() <= Oprs.indexOf("+"))) {	
			if (b) s.parenth("\u005B" , "\u005D") ; else s.parenth() ;
		}
		else r.append("\u0020") ;
		r.append(s) ; return r ;
	}

	box unknownToBox(box r , liste F) {
		if (F.length() > 0) { box s = listeToBox(F , "," , true ) ; r.append(s) ; }
		else r.append(new String[]{"\u0028" , "\u0029"}) ;
		return r ;
	}

// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { return Double.NaN ; }
	
// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) { return new form(this , R) ; }

// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) { return new form(this , D) ; }

// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) { return null ; }
	
	vois operLimit(Vector R) { return vois.vndef("unknown") ; }
	
}
