//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
SOMME.
*/

public class op_somme extends oper {
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public op_somme(int p) { super("+" , p) ; assoc = true ; }

/*________________________________________ MÉTHODES ________________________________________*/

// 2. CHAÎNES _______________________________________________________________________________
	
	String toOrdString(liste F) { 
		if (poids == 0) return "" ; else return toOrdString(F , " + " , "-" , " - ") ; 
	}

// 3. BOÎTES ________________________________________________________________________________

	box toBox(liste F) {
		if (poids == 0) return new box() ; else return toBox(F , " + " , "-" , " - ") ; 
    }
	
// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { 
		double r = 0 ;
		for (int i = 0 ; i < v.length ; i++) r += v[i] ;
		return r ; 
	}

// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) {
		if (level == NO_EVAL) return resultForSum(R) ;
		liste S = new liste() ; 
		form a ; 
		R.bot() ; while(R.hasNext()) {
			a = R.next() ; if (a.operIsSum()) S.V.addAll(a.F.V) ; else S.add(a) ;
		}
		R = S ; 
		if (level == EVAL_SIGNS) return resultForSum(R) ;
		boolean hasNbre = false ; 
		nbre n = new nbre(0) ;
		R.bot() ; while(R.hasNext()) {
			a = R.next() ; 
			if (a instanceof nbre) { n.Nadd((nbre)a) ; hasNbre = true ; R.remA() ; }
		}
		if (level == EVAL_NBRES) return resultForSum(R , n) ;
		return resultForSumPolys(R , n) ; 
	}
			
// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) {
		D.top() ; while(D.hasPrev()) if (D.prev().estEgal(0)) D.remD() ;
		int l = D.length() ; 
		if (l == 0) return new nbre(0) ; else if (l == 1) return D.first() ; else return nsom(D) ;
	}

// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) { 
		equg a , r = (equg)V.elementAt(0) ; if (V.size() == 1) return r ;
		int c ; liste R = new liste() ;
		for (int i = 1 ; i < V.size() ; i++) {
			a = (equg) V.elementAt(i) ; 
			c = r.compareTo(a) ; if (c < 0) r = a ;
		}
		for (int i = 0 ; i < V.size() ; i++) {
			a = (equg) V.elementAt(i) ; 
			c = r.compareTo(a) ;
			if (c != 0) {
				a.quon(r.lnpart , r.monopart , r.exppart) ;
				R.add(a.getForm().eval()) ;
			}
			else R.add(a.factor.eval()) ;
		}
		r.factor = nsom(R) ;
		r.computeLimit() ;
		return r ;
	}
	
	vois operLimit(Vector R) {
		if (R.size() == 0) return vois.vndef("ndef") ;
		vois r = (vois)R.elementAt(0) ;
		for (int i = 1 ; i < R.size() ; i++) {
			r = r.add((vois)R.elementAt(i)) ; if (r.info.equals("∞ - ∞") || r.info.equals("ndef")) break ;
		}
		return r ;
	}

}
