//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
QUOTIENT.
*/

/*______________________________________ CONSTRUCTION ______________________________________*/

public class op_quotient extends oper {

	public op_quotient() { super("/" , Oprs.indexOf("*") , 2) ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 2. CHAÎNES _______________________________________________________________________________

	String toOrdString(liste F) { return toOrdStringBinaire(F) ; }

// 3. BOÏTES ________________________________________________________________________________

	box toBox(liste F) { 
		form a = F.first() , b = F.next() ;
		return box.boxQuot(a.toBox() , b.toBox()) ;
	}
	
// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { 
		if (v.length != 2) return Double.NaN ; else return v[0] / v[1] ;
	}
	
// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) {
		if ((R.length() != 2) || (level == NO_EVAL)) return new form(this , R) ;
		form a = R.first() , b = R.next() ;
		if ((a instanceof nbre) && (b instanceof nbre)) return a.Gdiv(b) ;
		else return eval(a , b) ;
	}
	
	form eval(form a , form b) {
		int sgn = 1 ; Vector V = new Vector() ; nbre n ;
		if (a.operIsOpp()) { sgn *= -1 ; a = a.F.first() ; }
		if (a.operIsProd()) V.addAll(a.F.V) ; else V.add(a) ;
		liste A = new liste(V) ;
		V.clear() ;
		if (b.operIsOpp()) { sgn *= -1 ; b = b.F.first() ; }
		if (b.operIsProd()) V.addAll(b.F.V) ; else V.add(b) ;
		liste B = new liste(V) ;
		if (level == EVAL_SIGNS) return resultForQuotient(false , sgn , A , B) ;
		form r ; nbre nb ;
		B.bot() ; while(B.hasNext()) {
			r = B.next() ; if (r instanceof nbre) { nb = new nbre((nbre)b) ; nb.Ninv() ; A.add(nb) ; B.remA() ; }
		}
		liste N = A.extractNbres() ; 
		boolean hasNbre = (N.length() > 0) ; n = N.Nmult(sgn) ; sgn = 1 ;
		if (hasNbre && ((n.val == 0) || Double.isNaN(n.val) || (A.length() + B.length() == 0))) return n ;
		if (level == EVAL_NBRES) {
			if (n.val < 0) { sgn *= -1 ; n.Nopp() ; } 
			if (hasNbre) {
				if (n.num != 1) A.ins(new nbre(n.num) , 0) ;
				if (n.den != 1) B.ins(new nbre(n.den) , 0) ;
			}
			return resultForQuotient(false , sgn , A , B) ;
		}
		mono ma , mb ;
		B.bot() ; while(B.hasNext()) {
			r = B.next() ; if (r instanceof mono) { mb = new mono((mono)r) ; mb.Minv() ; A.add(mb) ; B.remA() ; }
		}
		liste MA = A.extractMonos() ;
		hasNbre = (hasNbre || (MA.length() > 0)) ; n = MA.Mmult(n) ; 
		if (hasNbre && ((n.val == 0) || Double.isNaN(n.val))) return n ;
		MA = MA.monosProd() ; liste MB = new liste() ; 
		MA.bot() ; while(MA.hasNext()) {
			ma = (mono)MA.next() ; if (ma.deg < 0) { ma.Minv() ; MB.add(ma) ; MA.remA() ; }
		}
		MA.V.addAll(A.V) ; MB.V.addAll(B.V) ; 
		if (hasNbre && ((n.val == 0) || Double.isNaN(n.val) || (MA.length() + MB.length() == 0))) return n ;
		if (n.val < 0) { sgn *= -1 ; n.Nopp() ; }
		if (hasNbre) {
			if (n.num != 1) insere(new nbre(n.num) , MA) ;
			if (n.den != 1) insere(new nbre(n.den) , MB) ;
		}
		if ((level == EVAL_MONOS) || !expandable) return resultForQuotient(true , sgn , MA , MB) ;
		SUM.level = level ; PROD.level = EVAL_MONOS ;
		form ra = expandProducts(1 , MA) , rb = expandProducts(1 , MB) ;
		int s = ra.getSign() ; sgn *= s ; if (s < 0) ra = ra.Gopp() ;
		s = rb.getSign() ; sgn *= s ; if (s < 0) rb = rb.Gopp() ;
		r = resultForQuotient(true , ra , rb) ; if (sgn < 0) r = r.Gopp() ;
		return r ;
	}
			
// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) {
		form a = F.first() , b = F.next() , da = D.first() , db = D.next() , r ;
		if (db.estEgal(0)) r = npro(b.Ginv() , da) ;
		else if (da.estEgal(0)) r = npro(a , nquo(db.Gopp() , npow(b , new nbre(2) , false))) ;
		else {
			r = npow(b , new nbre(2) , false) ; 
			r = nquo(nsom(npro(da,b) , nopp(npro(a,db))) , r) ;
		}
		return r ;
	}
	
// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) { 
		if (V.size() != 2) return null ;
		equg a = (equg)V.elementAt(0) , b = (equg)V.elementAt(1) ; 
		return a.quog(b) ;
	}
	
	vois operLimit(Vector R) {
		if (R.size() != 2) return vois.vndef("ndef") ;
		vois r = (vois)R.elementAt(0) , s = (vois)R.elementAt(1) ;
		return r.div(s) ;
	}
	
}
