//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
PUISSANCE.
*/

public class op_puissance extends oper {

/*______________________________________ CONSTRUCTION ______________________________________*/

	public op_puissance(int p) { super("^" , p) ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 2. CHAÎNES _______________________________________________________________________________

	String toOrdString(liste F) { return toOrdStringBinaire(F) ; }

// 3. BOÏTES ________________________________________________________________________________

	box toBox(liste F) {
		if (poids != 2) return new box() ; form a = F.first() , b = F.next() ;
		oper o = a.op ; String sb = b.toString() ; double d = valD(sb) ;
		box r , s ;
		boolean ae = false , np = false ;
		if ((o != null) && o instanceof op_fonction) {
			ae = (indice(o.nom , new String[] {"abs" , "rac" , "exp" }) < 0) ;
			np = (indice(o.nom , new String[]{"abs" , "rac"}) >= 0) ;
		}
		if (ae && (d == Math.floor(d))) {
			r = new box(o.nom , false) ; box.redSize(.8f) ; s = new box(sb) ; box.prevSize() ;
			r = box.boxPow(r , s) ;
			if (estFonctionConnue()) r = knownToBox(r , a.F.first()) ; else r = unknownToBox(r , a.F) ;
		}
		else {
			if (np) r = a.toBox() ; else r = a.toBox(pri + 1) ;
			box.redSize(.8f) ; s = b.toBox() ; box.prevSize() ;
			r = box.boxPow(r , s) ;
		}
		return r ;
	}
	
// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { 
		if (v.length != 2) return Double.NaN ; else return Math.pow(v[0] , v[1]) ;
	}
	
// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) {
		if ((R.length() != 2) || (level == NO_EVAL)) return new form(this , R) ;
		form a = R.first() , b = R.next() , r ;
		if (!(b instanceof nbre) || (b instanceof nbre && (((nbre)b).type != 2))) 
			return nftn("exp" , npro(b , nftn("ln" , a))).eval(level) ;
		int e = (int)b.getNbre().num ;
		int sgn = a.getSign() ; 
		if (e == 0) return new nbre(1) ;
		if (e == 1) return a ;
		if (e == -1) { if (sgn < 0) return a.Gopp().Ginv().Gopp() ; else return a.Ginv() ; }
		if ((a instanceof nbre) && (b instanceof nbre)) return a.Gpow(b) ;
		if (!expandable) return npow(a , b , false) ;
		if (sgn > 0) r = npow(a , b) ; else r = npow(a.Gopp() , b) ; 
		if (e%2 == 0) sgn = 1 ; if (sgn < 0) r = r.Gopp() ;
		if (level == EVAL_SIGNS) return r ;
		if (a instanceof nbre) { nbre n = new nbre((nbre)a) ; n.Npow(e) ; return n ; }
		if (level == EVAL_NBRES) return r ; 
		if (a instanceof mono) { mono m = new mono((mono)a) ; m.Mpow(e) ; return m ; }
		if ((level < EVAL_POLYS) || !expandable || (e < 0)) return r ; 
		if (a instanceof poly) { poly p = new poly((poly)a) ; p.Ppow(e) ; return p ; }
		SUM.level = level ; PROD.level = EVAL_MONOS ; PROD.expandable = expandable ;
		r = a.copie() ;
		for(int i = 1 ; i < e ; i++) r = expandProducts(1 , new liste(r , a.copie())) ;
		return r ;
	}

// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) { 
		if (poids != 2) return new nbre(0) ; 
		form	a = F.first() ,
				b = F.next() ,
				da = D.first() ,
				db = D.next() ; nbre n ;
		if (a instanceof nbre) return new nbre(0) ;
		else if (b instanceof nbre) {
			n = new nbre((nbre)b) ; if (n.val == 0) return n ;
			b = da ; if (n.val == 1) return b ;
			liste P = new liste(3) ; P.set(new nbre(n) , 0) ; P.set(b , 1) ;
			n.Nadd(new nbre(-1)) ; if (n.val == 1) P.set(a , 2) ; else P.set(npow(a , n , false) , 2) ;
			return npro(P) ;
		}
		else return (nftn("exp" , npro(b , nftn("ln" , a)))).toDer(v) ;
	}
	
// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) { 
		if (V.size() != 2) return null ;
		equg a = (equg)V.elementAt(0) , b = (equg)V.elementAt(1) ; 
		return a.powg(b) ;
	}
	
	vois operLimit(Vector R) {
		if (R.size() != 2) return vois.vndef("ndef") ;
		vois r = (vois)R.elementAt(0) , s = (vois)R.elementAt(1) ;
		return r.pow(s) ;
	}

}
