//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
PRODUIT.
*/

public class op_produit extends oper {
	
/**
Détermine si les facteurs sont regroupées au numérateur et au dénominateur.
*/
	boolean boxquot = true ;

/*______________________________________ CONSTRUCTION ______________________________________*/

	public op_produit(int p) { super("*" , p) ; assoc = true ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 2. CHAÎNES _______________________________________________________________________________

	String toOrdString(liste F) {
		if (poids == 0) return "" ; else return toOrdString(F , "*" , "/" , "/") ; 
	} 
	
// 3. BOÎTES ________________________________________________________________________________

	box toBox(liste  F) {
		if (boxquot) return toBoxQ(F) ;
		else return createBox(F) ;
	}

	box toBoxQ(liste F) {
		liste N = new liste() , D = new liste() ; form a ; int sgn = 1 ;
		nbre n ; mono m ;
		for (int i = 0 ; i < F.length() ; i++) { 
			a = F.get(i) ; 
			if (a instanceof nbre) {
				n = (nbre)a ; if (n.val < 0) { sgn *= -1 ; n.Nopp() ; }
				if ((n.type != 3) || (n.num != 1)) N.add(new nbre(n.num)) ; 
				if (n.den != 1) D.add(new nbre(n.den)) ; 
			}
			else if (a instanceof mono) {
				m = (mono)a ; n = m.coeff ;
				if (n.val < 0) { sgn *= -1 ; n.Nopp() ; }
				if (n.num != 1) N.add(new nbre(n.num)) ; 
				if (n.den != 1) D.add(new nbre(n.den)) ; 
				if (m.deg < 0) D.add(new mono(m.base , -m.deg)) ;
				else N.add(new mono(m.base , m.deg)) ;
			}
			else if (a.operIsInv()) D.add(a.F.first()) ; 
			else N.add(a) ;
		}
		box A = createBox(N) ; if (sgn < 0) A = box.boxOpp(A) ;
		if (D.length() == 0) return A ; 
		else return box.boxQuot(A , createBox(D)) ;
	}
	
    box createBox(liste F) {
		if (F.length() == 0) return new box("1") ;
		if (F.length() == 1) return F.first().toBox() ;
        form p , a = F.first() ;
		p = F.next() ;
		box r = a.toBox(prior) , A , bsep ;
		if (p.operIsFC() && a.operIsFC()) r.parenth() ;
		String sep = "." ; boolean b , c ;
        for (int i = 1 ; i < F.length() ; i++) { 
			b = c = false ; p = a ;  
			a = F.get(i) ;
			if (a.toString().charAt(0) == '-') b = true ;
			else if (p instanceof nbre || p instanceof mono) {
				if ((a instanceof nbre) && !((nbre)a).specialString) b = true ;
				else if (a instanceof mono && (((mono)a).coeff.val != 1)) b = true ;
				else if (p instanceof mono && a.op instanceof op_fonction) b = true ;
				else if (a.op instanceof op_quotient || a.op instanceof op_inverse) b = true ;
			}
            A = a.toBox(prior) ; 
			if (a.operIsFC()) {
				if (p.operIsFC()) b = true ;
				if (p instanceof mono) c = true ;
			}
			if ((p.getPrior() < pri + 1) && (a.op != null) && a.op instanceof op_fonction) c = true ;
			if (p.op instanceof op_quotient || p.op instanceof op_inverse) c = true ;
			if (b) { bsep = new box(sep , false) ; bsep.centre("\u0020") ; r.append(bsep) ; }
			else if (c) r.append(new box("\u0020" , false)) ;
			r.append(A) ;
        }
        return r ;
    }
	
// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { 
		double r = 1 ;
		for (int i = 0 ; i < v.length ; i++) r *= v[i] ;
		return r ; 
	}

// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) {
		if (level == NO_EVAL) return resultForProduct(R) ;
		form a , r ; 
		int sgn = 1 ; 
		Vector V = new Vector() ;
		R.bot() ; while(R.hasNext()) {
			a = R.next() ; while (a.operIsOpp()) { sgn *= -1 ; a = a.F.first() ; }
			if (a.operIsProd()) V.addAll(a.F.V) ; else V.add(a) ;
		}
		R = new liste(V) ;
		liste N = R.extractNbres() ; 
		boolean hasNbre = (N.length() > 0) ; nbre n = N.Nmult(sgn) ; sgn = 1 ;
		if (hasNbre && ((R.length() == 0) || (n.val == 0) || Double.isNaN(n.val))) return n ;
		if (level == EVAL_NBRES) {
			if (n.val < 0) { sgn *= -1 ; n.Nopp() ; }
			if (hasNbre) R.ins(n , 0) ;
			return resultForProduct(sgn , R) ;
		}
		liste M = R.extractMonos() ;
		hasNbre = (hasNbre || (M.length() > 0)) ; n = M.Mmult(n) ; M = M.monosProd() ; M.V.addAll(R.V) ;
		if (hasNbre && ((M.length() == 0) || (n.val == 0) || Double.isNaN(n.val))) return n ;
		if (n.val < 0) { sgn *= -1 ; n.Nopp() ; }
		insere(n , M) ;
		if ((level == EVAL_MONOS) || !expandable) return resultForProduct(sgn , M) ;
		if (M.length() < 2) r = resultForProduct(sgn , M) ; 
		else {
			SUM.level = level ; PROD.level = EVAL_MONOS ;
			r = expandProducts(sgn , M) ;
		}
		return r ; 
	}

// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) {
		int l = D.length() ; if (l == 0) return new form() ; else if (l == 1) return D.first() ;
		liste A = new liste(F.V) , S = new liste() ; form r , d ;
		for (int i = 0 ; i < F.length() ; i ++) {
			d = D.get(i) ;
			A.set(d , i) ; if (i > 0) A.set(F.get(i - 1) , i - 1) ;
			if (!d.estEgal(0)) S.add(npro(new liste(A.V))) ;
		}
		l = S.length() ; if (l == 0) r = new nbre(0) ; else if (l == 1) r = S.first() ; else r = nsom(S) ;
		return r ;
	}

// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) { 
		equg a , r = (equg)V.elementAt(0) ; if (V.size() == 1) return r ;
		for (int i = 1 ; i < V.size() ; i++) r = r.multg((equg) V.elementAt(i)) ;
		return r ;
	}
	
	vois operLimit(Vector R) {
		if (R.size() == 0) return vois.vndef("ndef") ;
		vois r = (vois)R.elementAt(0) ;
		for (int i = 1 ; i < R.size() ; i++) {
			r = r.mult((vois)R.elementAt(i)) ; if (r.info.equals("0 * ∞") || r.info.equals("ndef")) break ;
		}
		return r ;
	}

}
