//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
INVERSE.
*/

public class op_inverse extends oper {

/*______________________________________ CONSTRUCTION ______________________________________*/

	public op_inverse(int p) { super("/" , pru , p) ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 2. CHAÎNES _______________________________________________________________________________

	String toOrdString(liste F) { 
		if (poids == 0) return "" ;
		else return "1/" + F.first().toString(prior) ;
	}

// 3. BOÏTES ________________________________________________________________________________

	box toBox(liste F) { 
		if (poids != 1) return new box() ; 
		else return box.boxQuot(new box("1") , F.first().toBox()) ;
	}

// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { 
		if (v.length != 1) return Double.NaN ; else return 1 / v[0] ;
	}
	
// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) {
		if (R.length() != 1) return new form(this , R) ;
		form r = R.first() ; if (!r.operIsProd()) return r.Ginv() ; 
		PROD.level = level ; 
		liste p = new liste() ;
		while (r.F.hasNext()) p.V.add(r.F.next().Ginv()) ;
		return PROD.eval(p) ;
	}
		
// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) {
		return nquo(D.first().Gopp() , npow(F.first() , new nbre(2) , false)) ; 
	}

// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) {
		equg r = (equg)V.elementAt(0) ; return r.invg() ;
	}
	
	vois operLimit(Vector R) {
		if (R.size() != 1) return vois.vndef("ndef") ;
		vois r = (vois)R.elementAt(0) ;
		return r.inv() ;
	}

}

