//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Vector ;

/**
FONCTIONS.
*/

public class op_fonction extends oper {

/*_______________________________________ VARIABLES ________________________________________*/

/**
Détermine si les calculs numériques sont effectués ou non.
*/
	boolean evalNbre = true ;

/*______________________________________ CONSTRUCTION ______________________________________*/

	public op_fonction(String s , int p) { super(s , pri , p) ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 2. CHAÎNES _______________________________________________________________________________

	String toOrdString(liste F) { return nom + listeToString(F , "" + dessin.ISEP , true) ; }	
	
// 3. BOÏTES ________________________________________________________________________________

	box toBox(liste F) {
		box r = new box(nom , false) ;
		if (estFonctionConnue()) {
			form a = F.first() ;
			if (nom.equals("abs")) { r = a.toBox() ; r.parenth("\u007C" , "\u007C") ; return r ; }
			else if (nom.equals("rac") || nom.equals("sqrt")) return box.boxRac(a.toBox()) ;
			else if (nom.equals("exp")) return box.boxPow(new box("\u0065" , false) , a.toBox()) ;
			else if (nom.equals("pth")) { r = a.toBox() ; r.parenth("\u0028" , "\u0029") ; return r ; }
			else if (nom.equals("cro") || nom.equals("bra")) { r = a.toBox() ; r.parenth("\u005B" , "\u005D") ; return r ; }
			else r = knownToBox(r , a) ;
		}
		else r = unknownToBox(r , F) ;
		return r ;
    }

// 4. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(double[] v) { 
		if (!estFonctionConnue() || (v.length != 1)) return Double.NaN ; 
		int p = indice(nom , FONCTIONS_CONNUES) ;
        double x = v[0] ; 
		double y = Double.NaN ; 
		if (Double.isNaN(x)) return y ;
		switch (p ) {
			case 0 : y = Math.abs(x) ; break ;
			case 1 : case 17 : y = Math.sqrt(x) ; break ;
			case 2 : y = Math.sin(x) ; break ;
			case 3 : y = Math.cos(x) ; break ;
			case 4 : y = Math.tan(x) ; break ;
			case 5 : y = Math.asin(x) ; break ;
			case 6 : y = Math.acos(x) ; break ;
			case 7 : y = Math.atan(x) ; break ;
			case 8 : y = Math.log(x) ; break ;
			case 9 : y = Math.log(x)/Math.log(10) ; break ;
			case 10 : y = Math.exp(x) ; break ;
			case 11 : y = Math.floor(x) ; break ;
			case 12 : if (x > 0) y = 1 ; else if (x < 0) y = -1 ; break ;
			case 13 : if (x != Math.floor(x)) y = 0 ; break ;
			case 14 : case 15 : case 16 : y = x ; break ;
		}
        return y ;
	}
		
// 5. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(liste R) { 
		if (!estFonctionConnue() || !(R.first()instanceof nbre) || !evalNbre) return new form(this , R) ;
		nbre a = (nbre)R.first() ; int p = indice(nom , FONCTIONS_CONNUES) ;
        double x = a.val , y = ndef ; nbre N ; if (Double.isNaN(x)) return new nbre(ndef) ;
		if (p == 0) { y = Math.abs(x) ; N = new nbre(Math.abs(a.num) , Math.abs(a.den)) ; }
		else if ((p == 1) || (p == 16)) { y = Math.sqrt(x) ; N = new nbre(Math.sqrt(a.num) , Math.sqrt(a.den)) ; }
		else {
			switch (p ) {
				case 2 : y = Math.sin(x) ; break ;
				case 3 : y = Math.cos(x) ; break ;
				case 4 : y = Math.tan(x) ; break ;
				case 5 : y = Math.asin(x) ; break ;
				case 6 : y = Math.acos(x) ; break ;
				case 7 : y = Math.atan(x) ; break ;
				case 8 : if (x > 0) y = Math.log(x) ; break ;
				case 9 : if (x > 0) y = Math.log(x)/Math.log(10) ; break ;
				case 10 : y = Math.exp(x) ; break ;
				case 11 : y = Math.floor(x) ; break ;
				case 12 : if (x > 0) y = 1 ; else if (x < 0) y = -1 ; break ;
				case 13 : if (x != Math.floor(x)) y = 0 ; break ;
				case 14 : case 15 : y = x ; break ;
			}
			if (!Double.isNaN(y)) y = arr(y) ; N = new nbre(y) ;
		}
        return N ;
	}
			
// 6. DÉRIVÉE _______________________________________________________________________________

	form toDer(liste F , String v , liste D) {
		liste A = new liste() ; form r ;
		if (!estFonctionConnue()) {
			A.add(new form(this , F)) ; A.add(new form(v)) ; return nftn("derive" , A) ;
		}
		form a = F.first() , d = D.first() ; boolean b = true ;
		int p = indice(nom , FONCTIONS_CONNUES) , sgn = 1 ;
		while(d.operIsOpp()) { d = d.F.first() ; sgn *= -1 ; }
		switch (p ) {
			case 0 : A.add(nftn("dabs" , a)) ; break ;
			case 1 : A.add(new nbre(1 , 2)) ; A.add(ninv(nftn("rac" , a))) ; break ;
			case 2 : A.add(nftn("cos" , a)) ; break ;
			case 3 : sgn *= -1 ; A.add(nftn("sin" , a)) ; break ;
			case 4 : A.add(ninv(npow(nftn("cos" , a) , new nbre (2) , false))) ; break ;
			case 8 : A.add(ninv(a)) ; break ;
			case 9 :  A.add(ninv(nftn("ln" , new nbre (10) , false))) ; A.add(ninv(a)) ; break ;
			case 10 : A.add(nftn("exp" , a)) ; break ;
			case 11 : A.add(nftn("dent" , a)) ; break ;
			case 14 : case 15 : case 16 : A = D ; break ;
			case 17 : A.add(new nbre(1 , 2)) ; A.add(ninv(nftn("sqrt" , a))) ; break ;
			default : A.add(nftn(nom , F)) ; A.add(new form(v)) ; b = false ;
		}
        if (b) {
			if (sgn < 0) d = d.Gopp() ; A.ins(d , 0) ;
			return resultForProduct(1 , A) ; 
		}
		else r = nftn("derive" , A) ;
		return r ;
	}
	
// 7. LIMITES _______________________________________________________________________________

	equg toEquivG(Vector V) {
		if (!estFonctionConnue() || (V.size() != 1)) return null ;
		equg r = null , a = (equg)V.elementAt(0) ; 
		int p = indice(nom , FONCTIONS_CONNUES) ; 
		switch (p ) {
			//case 0 : r = a.abs() ; break ;
			case 1 : case 17 : r = a.powg(new nbre(1 , 2)) ; break ;
			//case 2 : r = a.sin() ; break ;
			//case 3 : r = a.cos() ; break ;
			//case 4 : r = a.tan() ; break ;
			//case 5 : r = a.asin() ; break ;
			//case 6 : r = a.acos() ; break ;
			//case 7 : r = a.atan() ; break ;
			case 8 : r = a.ln() ; break ;
			case 9 : r = a.log() ; break ;
			case 10 : r = a.exp() ; break ;
			case 11 : break ;
			//case 12 : r = a.dabs() ;
			case 13 : break ;
			case 14 : case 15 : case 16 : r = a ; break ;
		}
		return r ;
	}
	
	vois operLimit(Vector R) {
		if (!estFonctionConnue() || (R.size() != 1)) return vois.vndef("unknown") ;
		int p = indice(nom , FONCTIONS_CONNUES) ; 
		vois a = (vois) R.elementAt(0) , r = a.ftn(nom) ;
		switch (p ) {
			case 0 : r = a.abs() ; break ;
			case 1 : case 17 : r = a.rac() ; break ;
			case 2 : r = a.sin() ; break ;
			case 3 : r = a.cos() ; break ;
			case 4 : r = a.tan() ; break ;
			case 5 : r = a.asin() ; break ;
			case 6 : r = a.acos() ; break ;
			case 7 : r = a.atan() ; break ;
			case 8 : r = a.ln() ; break ;
			case 9 : r = a.log() ; break ;
			case 10 : r = a.exp() ; break ;
			case 11 : r = a.ent() ; break ;
			case 12 : r = a.dabs() ; break ;
			case 13 : r = a.dent() ; break ;
			case 14 : case 15 : case 16 : r = a ; break ;
		}
		return r ;
	}

}
