//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.Shape ;
import java.awt.geom.Point2D ;
import java.util.Vector ;

/**
  OBJETS GRAPHIQUES. Classe racine des objets représentés à l'écran. 
*/
public class objetG extends dessin {



/*_______________________________________ VARIABLES ________________________________________*/

/**
  Détermine si l'objet est défini ou non.
*/
	boolean isDef = false ;
	
/**
  Détermine si l'objet est visible ou non.
*/
	boolean visible = true ;
	
/**
  Détermine si l'objet affiche des résultats supplémentaires ou non.
*/
	boolean affiche = false ;

/**
  Détermine si le nom de cet objet doit être interprété comme une formule ou non.
*/
	boolean prettyprint = true ; 

/**
  Détermine si cet objet a une ligne de texte associée ou non.
*/
	boolean hasicon = false ;

/**
  Type de l'objet : différencie dans une même classe plusieurs sortes d'objets.
*/
	int type = 0 ; 

/**
  Nombre de points : paramètre utilisé dans les calculs et les tracés.
*/
	int np = 0 ;

/**
  Numéro de cet objet : utilisé pour les enregistrements.
*/
	int no = -1 ;

/**
  Trait de l'objet.
*/
	float t = 2f ;

/**
  Couleur de l'objet.
*/
	Color col = Color.black ;
	
/**
  Couleur de fond de l'objet.
*/
	Color colf ;
	
/**
  Chaîne de caractères qui identifie (partiellement) cet objet.
*/
	String  id = "" ;

/**
  Chaîne de caractères qui identifie (complètement) cet objet.
*/
	String  cid = "" ;
	
/**
  Chaîne de caractères qui représente le nom de cet objet.
*/
	String  name = ""   ;

/**
  Tableau avec lequel est construit le cadre contenant les résultats supplémentaires.
*/
	Object[][] O ;
	
/**
  Cadre associé à cet objet dans lequel sont affichées les résultats supplémentaires.
*/
	box B ; 

/**
  Ligne de texte associée à cet objet.
*/
	boxicon BI ; 

/**
  Forme qui représente cet objet et qui est tracée à l'écran lorsque l'objet est visible.
*/	
	Shape S ;
	
/**
  Fils de l'objet : collection qui rassemble tous les objets qui dépendent directement de cet objet.
*/
	Vector F = new Vector() ;

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

/**
  Mise à jour de l'objet à partir des valeurs initiales qui lui ont été attribuées.
*/	
	void recalc() {}
	
/**
  Mise à jour des fils de l'objet.
*/	
	void refresh() {
		for(int i = 0 ; i < F.size() ; i++) ((objetG)F.elementAt(i)).recalc() ;
	}
	
/**
  Redéfinit la forme associée à cet objet.
*/	
	void calcShape() {}

/**
  Détermine si cet objet a un nom ou pas.
*/	
	boolean hasName() { return (name.length() > 0) ; }
	
/**
  Renvoie un objet représentant le nom : <i>form</i> en cas de prettyprint et <i>String</i> dans le cas général.
*/	
	Object getName() {
		if (prettyprint && (BI != null)) return BI.e ;
		else return name ;
	}
	
/**
  Crée si c'est possible une ligne de texte.
*/	
	void setIcon() {
		BI = area.createIcon(this) ;
		hasicon = (BI != null) ;
		if (hasicon) Z.GR.add(BI) ;
	}
	
/**
  Redessine la ligne de texte attribuée à cet objet.
*/	
	void changeFont() { if (hasicon) BI.maj() ; }

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________
	
/**
  Teste si la souris est proche de cet objet.
*/	
	boolean proche() { return false ; }
	
/**
  Trace à l'écran la forme assocciée à cet objet.
*/	
	void trace() {
		GRAPHICS.setColor(col) ;
		if (isDef && (S != null)) GRAPHICS.draw(TO_SCREEN.createTransformedShape(S)) ;
	}		
	
/**
  Trace à l'écran les résultats supplémentaires.
*/	
	void traceinfo() {
		if (!affiche || (D.o == null) || (D.o != this) || (B == null)) return ;
		GRAPHICS.setColor(Color.gray) ;
		float   lm = 10f , 
				tm = 10f ;
		B.trace(lm , tm) ; 
	}
	
// 3. AIDE CONTEXTUELLE ____________________________________________________________________

/**
  Texte affiché lorsque la souris est proche de cet objet.
*/	
	String getTTT() { 
		if (Z.create) return getAcceptTTT(Z.D.status , Z.D.PARAMS.size()) ; 
		else return getDefaultTTT() ; 
	}
	
/**
  Texte affiché lorsque la souris est proche de cet objet et qu'il peut participer 
à la construction d'un nouvel objet.
*/	
	String getAcceptTTT(int c , int n) { return getDefaultTTT() ; }
	
/**
  Aide contextuelle par défaut.
*/	
	String getDefaultTTT() { return "" ; }

//  4. DÉPLACEMENTS ________________________________________________________________________

/**
  Enregistre les coordonnées d'un point quand la souris est appuyée en prévision d'un éventuel déplacement.
*/	
	void savePoint() {}

/**
  Déplace cet objet à l'écran.
*/	
	void deplace() {}
	
	
//  5. LOCALISATION ________________________________________________________________________

/**
  Renvoie un point d'ancrage par défaut pour cet objet.
*/	
	Point2D.Float defaultLocation() { return null ; }
		
/**
  Replace un point sur cet objet.
*/	
	void locate(Point2D.Float pf) {}
			
/**
  Replace un <i>point sur courbe</i> sur cet objet.
*/	
	void locate(pointsurcourbe ps) {}
			
/**
  Attribue des paramètres à un  <i>point sur courbe</i> pour pouvoir le replacer sur cet objet.
*/	
	void setParamFor(pointsurcourbe ps) {}
			
//  6. ENREGISTREMENT ______________________________________________________________________

/**
  Renvoie une chaîne permettant de reconstituer cet objet.
*/	
	String getCommand() { return "" ; }

/**
Renvoie un objet <i>StringBuffer</i> contenant l'information relative aux paramètres de base de cet objet.
Les informations concernent :
<ul>
<li> le drapeau <i>visible</i> </li>
<li> le drapeau <i>affiche</i> </li>
<li> l'entier <i>np</i> </li>
<li> le nom </li>
<li> le drapeau <i>prettyprint</i> </li>
<li> trois entiers décrivant la couleur RGB du <i>trait</i> </li>
<li> si la couleur de fond est définie, trois entiers décrivant la couleur RGB du <i>fond</i> </li>
</ul> 
*/	
	StringBuffer getNameColorCommand() {
		StringBuffer sb = new StringBuffer() ; 
		sb.append(',') ; sb.append(visible) ;
		sb.append(',') ; sb.append(affiche) ;
		sb.append(',') ; sb.append(np) ;
		sb.append(',') ; sb.append('[') ; sb.append(name) ; sb.append(']') ;
		sb.append(',') ; sb.append(prettyprint) ;
		sb.append(',') ; sb.append(col.getRed()) ;
		sb.append(',') ; sb.append(col.getGreen()) ;
		sb.append(',') ; sb.append(col.getBlue()) ;
		if (colf != null) {
			sb.append(',') ; sb.append(colf.getRed()) ;
			sb.append(',') ; sb.append(colf.getGreen()) ;
			sb.append(',') ; sb.append(colf.getBlue()) ;
		}
		return sb ;
	}
	
/**
Interprète les informations relatives au nom et à la couleur.
*/	
	static void affectNameColor(objetG o , int i , String[] A) {
		String s ;
		o.visible = boolv(A[i]) ;
		i++ ; o.affiche = boolv(A[i]) ;
		i++ ; o.np = intv(A[i]) ;
		i++ ; s = A[i] ; o.name = s.substring(1 , s.length() - 1) ;
		i++ ; s = A[i] ; o.prettyprint = Boolean.valueOf(s).booleanValue() ;
		i++ ; s = A[i] ; int r = Integer.parseInt(s) ;
		i++ ; s = A[i] ; int g = Integer.parseInt(s) ;
		i++ ; s = A[i] ; int b = Integer.parseInt(s) ;
		o.col = new Color(r , g , b) ;
		if (i == A.length - 1) return ;
		i++ ; s = A[i] ; r = Integer.parseInt(s) ;
		i++ ; s = A[i] ; g = Integer.parseInt(s) ;
		i++ ; s = A[i] ; b = Integer.parseInt(s) ;
		o.colf = new Color(r , g , b , (o instanceof domaine) ? 128 : 255) ;
	}
	
// 7. DIALOGUES ____________________________________________________________________________

/**
Renvoie le statut de cet objet. L'entier renvoyé correspond à la construction de cet objet.
*/	
	int getStatus() { return -1 ; }

/**
Renvoie une chaîne identifiant cet objet.
*/	
	String getId() { return "" ; }
	
/**
Met à jour la barre de dialogue.
*/	
	void writeDatas() {}

/**
Lit et interprète les données de la barre de dialogue et met à jour cet objet.
*/	
	void readDatas() {}

/**
Modifie le paramètre <i>nombre de points</i>.
*/	
	void changeNbPoints(int n) { np = n ; }
		
/**
Renvoie une chaîne décrivant cet objet.
*/	
	public String toString() { return getCommand() ; }
	
//  8. CRÉATION ____________________________________________________________________________
}
