//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

/**
NOMBRES.
*/

public class nbre extends form {

/*_______________________________________ VARIABLES ________________________________________*/

/**
Valeur numérique.
*/
    double val = Double.NaN ; 
	
/**
Numérateur.
*/
    double num = val ; 

/**
Dénominateur.
*/
    double den = 1 ; 

/**
Entier permettant de classer les nombres.<br>
La valeur du type est :
 <ul>
   <li> 0 pour les nombres non définis ou infinis</li>
   <li> 1 pour les nombres réels non rationnels</li>
   <li> 2 pour les nombres entiers</li>
   <li> 3 pour les nombres rationnels non entiers</li>
 </ul>
*/
	int type = 0 ;
	
/** 
Indique si le nombre est représenté par une lettre
*/
	boolean specialString = false ;
    
/*______________________________________ CONSTRUCTION ______________________________________*/

    public nbre() { }
	
    public nbre(double n) { maj(n , 1) ; }
	
    public nbre(double n , double d) { maj(n , d) ; }
	
    public nbre(nbre N) { maj(N) ; }

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

    void maj(nbre n) {
		val = n.val ; 
		num = n.num ; 
		den = n.den ;
		str = n.str ;
		type = n.type ; 
	}
	    
    void maj(double n) { maj(n , 1) ; }

    void maj(double n , double d) {
        den = 1 ; 
		type = 0 ; 
        if (d == 0) num = val = Double.NaN ; else num = val = n/d ;
        if (!Double.isNaN(val) && !Double.isInfinite(val)) {
			type = 1 ;
			if (val == Math.floor(val)) type = 2 ;
			else if((n == Math.floor(n)) && (d == Math.floor(d))) { 
				double p = pgcd (n , d) ;
				num = n/p ; den = d/p ; 
				if (den < 0) {num *= -1 ; den *= -1 ; }
				type = 3 ;
			}
		}
		
		StringBuffer s = new StringBuffer() ;
		specialString = false ;
		if (type < 2) {
            if (Double.isNaN(val)) s.append(dessin.strline[5]) ;
            else if (Double.isInfinite(val)) { s.append('\u221E') ; specialString = true ; }
            else if (env(Math.abs(val) , Math.PI)) { s.append('\u03C0') ; specialString = true ; }
            else if (env(Math.abs(val) , Math.E)){  s.append('e') ; specialString = true ; }
            else s.append(Math.abs(val)) ;
			if (val < 0) s.insert(0 , '-') ;
		}
		else if (type == 2) s.append((int)val) ;
		else {
			s.append((int)num) ; s.append('/') ; s.append((int)den) ;
		}
		str = new String(s) ;
    }
	
// 3. COPIE & INFO __________________________________________________________________________
	
	form copie() { return new nbre(this) ; }
    
	int getPrior() { if (type == 3) return Oprs.indexOf("*") ; else return pri + 1 ; }
	
	nbre getNbre() { return new nbre(this) ; }
    
	double getDoubleValue() { return val ; }
	
	int getSign() { return (val < 0) ? -1 : (val == 0) ? 0 : 1 ; }

	posi getSigne() {
		if (Double.isNaN(val)) return posi.pNone ;
		int s = getSign() ;
		if (s == -1) return posi.pInfS ;
		else if (s == 0) return posi.pEgal ;
		else return posi.pSupS ;
	}
	
// 4. CALCULS _______________________________________________________________________________

    void Nopp() { maj(-num , den) ; }
	
    void Ninv() { maj(den , num) ; }
	
	void Nadd(nbre b) { maj(num * b.den + den * b.num , den * b.den) ; }
	
	void Nsub(nbre b) { maj(num * b.den - den * b.num , den * b.den) ; }
	
    void Nmult(nbre b) { maj(num * b.num , den * b.den) ; }
    
    void Ndiv(nbre b) { maj(num * b.den , den * b.num) ; }
    
    void Npow(int n) { maj(Math.pow(num , n) , Math.pow(den , n)) ; }
	
    void Npow(nbre n) { maj(Math.pow(num , n.val) , Math.pow(den , n.val)) ; }
	
	form Gopp() { nbre n = new nbre(this) ; n.Nopp() ; return n ; }
	
	form Ginv() { nbre n = new nbre(this) ; n.Ninv() ; return n ; }

	form Gadd(form f) {
		nbre n ; mono m ; poly p ;
		if (f instanceof nbre) { n = new nbre(this) ; n.Nadd((nbre)f) ; return n ; }
		else if (f instanceof mono) { 
			m = (mono)f ;
			p = new poly((mono)f) ;
			p.Padd(this) ; 
			return p ;
		}
		else if (f instanceof poly) {
			p = new poly((poly)f) ; 
			p.Padd(this) ; 
			return p ;
		}
		else return nsom(this , f) ;
	}

	form Gmult(form f) {
		nbre n ; mono m ; poly p ;
		if (val == 1) return f.copie() ;
		else if (val == -1) return f.Gopp() ;		
		else if (f instanceof nbre) { n = new nbre((nbre)f) ; n.Nmult(this) ; return n ; }
		else if (f instanceof mono) { 
			p = new poly((mono)f) ;
			p.Pmult(this) ; 
			return p ;
		}
		else if (f instanceof poly) {
			p = new poly((poly)f) ; 
			p.Pmult(this) ; 
			return p ;
		}
		else return npro(this , f) ;
	}

	form Gpow(form f) {
		if (f instanceof nbre) { nbre n = new nbre(this) ; n.Npow((nbre)f) ; return n ; }
		else return npow(this , f) ;
	}

    form Gftn(String s) {
		int p = indice(s , FONCTIONS_CONNUES) ;
		if (p < 0) return nftn(s , this) ;
        if (Double.isNaN(val)) return new nbre(ndef) ;
        double x = val , y = ndef ; nbre N ;
		if (p == 0) { y = Math.abs(x) ; N = new nbre(Math.abs(num) , Math.abs(den)) ; }
		else if ((p == 1) || (p == 16)) { y = Math.sqrt(x) ; N = new nbre(Math.sqrt(num) , Math.sqrt(den)) ; }
		else {
			switch (p ) {
				case 2 : y = Math.sin(x) ; break ;
				case 3 : y = Math.cos(x) ; break ;
				case 4 : y = Math.tan(x) ; break ;
				case 5 : y = Math.asin(x) ; break ;
				case 6 : y = Math.acos(x) ; break ;
				case 7 : y = Math.atan(x) ; break ;
				case 8 : if (x > 0) y = Math.log(x) ; break ;
				case 9 : if (x > 0) y = Math.log(x)/Math.log(10) ; break ;
				case 10 : y = Math.exp(x) ; break ;
				case 11 : y = Math.floor(x) ; break ;
				case 12 : if (x > 0) y = 1 ; else if (x < 0) y = -1 ; break ;
				case 13 : if (x != Math.floor(x)) y = 0 ; break ;
				case 14 : case 15 : y = x ; break ;
			}
			if (!Double.isNaN(y)) y = arr(y) ; N = new nbre(y) ;
		}
        return N ;
    }
    
// 5. CHAÎNES _______________________________________________________________________________

	public String toString() { return str ; }

// 6. BOÎTES ________________________________________________________________________________

    public box toBox() {
        if (type == 3) return box.boxQuot(new box("" + (int)num , false) , new box("" + (int)den , false)) ;
        else return new box(str , false) ;
   }
    
// 8. CALCULS NUMÉRIQUES ____________________________________________________________________
	
	double toDouble(String s , float v) { return val ; }
	
	double toDouble(String s , float v , String t , float w) { return val ; }
	
// 9. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(int l) { return new nbre(this) ; }
	
// 10. DÉRIVÉE ______________________________________________________________________________

	form toDer(String v) { return new nbre(0) ; }
	
// 11. LIMITES ______________________________________________________________________________

	equg toEquivG(String sx , vois k) { return new equg(this , sx , k) ; }
	
	form taylorForm (String sv , nbre l , int o) { return copie() ; }

	vois operLimit(String sx , vois k) {
		if (Double.isNaN(val)) return vois.vndef("ndef") ;
		return new vois(new nbre(this) , posi.pEgal) ;
	}
	
}
