//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

/**
MONÔMES.
*/

public class mono extends form {

/*_______________________________________ VARIABLES ________________________________________*/

/**
Coefficient du monôme.
*/
	nbre coeff = new nbre(1) ; 
	
/**
Chaîne représentant la variable.
*/
	String base = "" ; 
	
/**
Degré.
*/
	int deg = 0 ;
	
/**
Expression représentant cet objet.
*/
	form pform ;
    
/*______________________________________ CONSTRUCTION ______________________________________*/

    public mono() { }
	
    public mono(String b) { maj(coeff , b , 1) ; }
	
    public mono(nbre c , String b) { maj(c , b , 1) ; }
	
    public mono(String b , int d) { maj(coeff , b , d) ; }
	
    public mono(nbre c , String b , int d) { maj(c , b , d) ; }
	
    public mono(mono M) { maj(M) ; }

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

    void maj(mono m) { maj(new nbre(m.coeff) , new String(m.base) , m.deg) ; }
	
	void maj(nbre c , String b , int d) { base = b ; maj(c , d) ; }

	void maj(nbre co , int de) { 
		coeff = co ; deg = de ; form r ;
		if ((Double.isNaN(coeff.val)) || (coeff.val == 0) || (deg == 0)) r = coeff ; 
		else {
			r = new form(base) ;
			int ad = (deg > 0) ? deg : -deg ;
			if (ad != 1) r = npow(r , new nbre(ad)) ;
			if (deg < 0) r = ninv(r) ;
			if (coeff.val == -1) r = nopp(r) ;
			else if (coeff.val != 1) r = npro(coeff , r) ;
		}
		pform = r ;
	}
	
// 2. TESTS _________________________________________________________________________________

	boolean estNbre() { return (deg == 0) ; }
	
	boolean estMono() { return (deg != 0) ; }
	
	boolean estPoly() { return false ; }

	boolean estDef() { return !Double.isNaN(coeff.val) ; }

// 3. COPIE & INFO __________________________________________________________________________
	
	form copie() { return new mono(this) ; }
    
	int getPrior() { return pform.getPrior() ; }
	
	nbre getNbre() { if (pform instanceof nbre) return (nbre)pform ; else return null ; }

	mono getMono() { if (pform instanceof mono) return (mono)pform ; else return null ; }

	poly getPoly() { if (pform instanceof poly) return (poly)pform ; else return null ; }

	double getDoubleValue() { if (pform instanceof nbre) return ((nbre)pform).val ; else return Double.NaN ; }
	
	posi getSigne() {
		if (!estDef()) return posi.pNone ;
		posi p = coeff.getSigne() ; if (deg == 0) return p ;
		p.exact = true ;
		if (deg > 0) { if (deg % 2 == 0) return p ; else return posi.pAll ; }
		p.exact = false ;
		if (deg % 2 == 0) return p ; else return posi.pDiff ;
	}
	
// 4. CALCULS _______________________________________________________________________________

    void Madd(mono m) { coeff.Nadd(m.coeff) ;  maj(coeff , deg) ; }

    void Msub(mono m) { coeff.Nsub(m.coeff) ;  maj(coeff , deg) ; }

    void Mmult(nbre n) { coeff.Nmult(n) ; maj(coeff , deg) ; }
	
    void Mdiv(nbre n) { coeff.Ndiv(n) ;  maj(coeff , deg) ; }
	
    void Mmult(mono m) { coeff.Nmult(m.coeff) ;  maj(coeff , deg + m.deg) ; }
	
    void Mdiv(mono m) { coeff.Ndiv(m.coeff) ;  maj(coeff , deg - m.deg) ; }

    void Mopp() { coeff.Nopp() ; maj(coeff , deg) ; }
	
    void Minv() { coeff.Ninv() ; maj(coeff , -deg) ; }
	
    void Mpow(int n) { coeff.Npow(n) ; maj(coeff , deg * n) ; }

	form Gopp() { mono m = new mono(this) ; m.Mopp() ; return m ; }
	
	form Ginv() { mono m = new mono(this) ; m.Minv() ; return m ; }

	form Gadd(form f) {
		poly p = new poly(this) ;
		if (f instanceof nbre) { p.Padd((nbre)f) ; return p ; }
		if (f instanceof mono) { 
			mono m = new mono(this) , mf = (mono)f ;
			if (mf.base.equals(base)) {
				if (mf.deg == deg) { m.Madd(mf) ; return m ; }
				else { p.Padd(new poly(mf)) ; return p ; }
			}
		}
		if (f instanceof poly) {
			poly pf = (poly) f ; if (pf.base.equals(base)) { p.Padd(pf) ; return p ; }
		}
		return nsom(this , f) ;
	}

	form Gmult(form f) {
		mono m = new mono(this) ;
		if (f instanceof nbre) { m.Mmult((nbre)f) ; return m ; }
		if (f instanceof mono) {
			mono mf = (mono)f ;
			if (mf.base.equals(base)) { m.Mmult(mf) ; return m ; }
		}
		if (f instanceof poly) {
			poly p = new poly(this) , pf = (poly) f ;
			if (pf.base.equals(base)) { p.Pmult(pf) ; return p ; }
		}
		return npro(this , f) ;
	}

	form Gpow(form f) {
		if (f instanceof nbre) { 
			nbre n = (nbre)f ;
			if (n.type == 2) {
				mono m = new mono(this) ; m.Mpow((int)n.num) ; return m ; 
			}
		}
		return npow(this , f) ;
	}

// 5. CHAÎNES _______________________________________________________________________________

	public String toString() { return pform.toString() ; }

// 6. BOÎTES ________________________________________________________________________________

    public box toBox() { return pform.toBox() ; }

// 7. SUBSTITUTIONS _________________________________________________________________________

	form subst(String s , form t) { return pform.subst(s , t) ; }

// 8. CALCULS NUMÉRIQUES ____________________________________________________________________

	double toDouble(String s , double v) {
		return (s.equals(base)) ? coeff.val * Math.pow(v , deg) : Double.NaN ;
	}

	double toDouble(String s , double v , String t , double w) {
		return  (s.equals(base)) ? coeff.val * Math.pow(v , deg) : 
				(t.equals(base)) ? coeff.val * Math.pow(w , deg) : 
				Double.NaN ;
	}

// 9. CALCULS SYMBOLIQUES ___________________________________________________________________

	form eval(int l) { return new mono(this) ; }
	
// 10. DÉRIVÉE ______________________________________________________________________________

	form toDer(String v) {
		if (!base.equals(v)) return new nbre(0) ;
		if (deg == 1) return new nbre(coeff) ; 
		else {
			nbre c = new nbre(coeff) ; c.Nmult(new nbre(deg)) ;
			return new mono(c , base , deg - 1) ;
		}
	}
	
// 11. LIMITES ______________________________________________________________________________

	equg toEquivG(String sx , vois k) {
		if (sx.equals(base)) return new equg(this , k) ;
		else return null ; 
	}
	
	form taylorForm (String sv , nbre l , int o) {
		if (!sv.equals(base) || Double.isNaN(l.val) || Double.isInfinite(l.val) || (l.val == 0)) return copie() ;
		poly s = new poly(base) ; s.Padd(l) ;
		poly p = new poly(this) ; 
		return p.subst(s) ; 
	}
	
	vois operLimit(String sx , vois k) {
		if (!estDef() || !base.equals(sx)) return vois.vndef() ;
		if ((coeff.val == 0) || (deg == 0)) return new vois(new nbre(coeff) , posi.pEgal) ;
		vois r = k.pow(deg) ; r.L.Nmult(coeff) ; if (coeff.val < 0) r.plim = r.plim.opp() ;
		return r ;
	}
	
}

