//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Collection ;
import java.util.Vector ;
/**
LISTES. Une liste est une collection d'objets <i>form</i>. Cette collection peut être parcourue dans les deux sens.


*/
public class liste extends calcul {

/*_______________________________________ VARIABLES ________________________________________*/

/**
Collection des éléments constituant la liste.
*/
    Vector V = new Vector() ;

/**
Indice utilisé pour l'énumération des objets.
*/
	int ind = 0 ;
    
/*______________________________________ CONSTRUCTION ______________________________________*/

/**
Création d'une liste vide.
*/
	public liste() {}
	
/**
Création d'une liste vide de taille donnée.
@param n le nombre d'éléments de la liste
*/
	public liste(int n) { V.setSize(n) ; }
	
/**
Création d'une liste contenant une formule.
@param a une formule
*/
	public liste(form a) { V.add(a) ; }
	
/**
Création d'une liste contenant deux formules.
@param a une première formule
@param b une seconde formule
*/
	public liste(form a , form b) { V.add(a) ; V.add(b) ; }
	
/**
Création d'une liste à partir d'une collection.
*/
	public liste(Collection c) { V.addAll(c) ; }
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. COPIE & INFO __________________________________________________________________________
	
/**
Renvoie une copie de cettte liste.
*/
	liste copie() {
		liste R = new liste() ;
		bot() ; while(hasNext()) R.add(next().copie()) ;
		return R ; 
	}

/**
Renvoie le nombre d'éléments de cette liste.
*/
	int length() { return V.size() ; }
	
/**
Renvoie le degré de cette liste, c'est-à-dire le nombre d'éléments moins une unité.
*/
	int deg() { return V.size() - 1 ; }
	
// 2. LECTURE & ÉCRITURE ____________________________________________________________________

/**
Renvoie la formule d'indice donné.
@param i un indice
*/
	form get(int i) { return (form)V.get(i) ; }
	
/**
Range une formule à un indice donné.
@param f une formule
@param i un indice
*/
	void set(form f , int i) { V.setElementAt(f , i) ; }
	
/**
Range une formule lors d'une énumération ascendante.
@param f une formule
*/
	void setA(form f) { set(f , ind - 1) ; }
	
/**
Range une formule lors d'une énumération descendante.
@param f une formule
*/
	void setD(form f) { set(f , ind + 1) ; }
	
// 3. ÉNUMÉRATION _____________________________________________________________________________
	
/**
Initialise une énumération ascendante.
*/
	void bot() { ind = 0 ; }
	
/**
Initialise une énumération descendante.
*/
	void top() { ind = deg() ; }
	
/**
Au cours d'une énumération ascendante, indique si le successeur existe.
*/
	boolean hasNext() { return (ind < length()) ; }
	
/**
Au cours d'une énumération descendante, indique si le prédécesseur existe.
*/
	boolean hasPrev() { return (ind > -1) ; }
	
/**
Au cours d'une énumération ascendante, renvoie le successeur.
*/
	form next() { ind ++ ; return (form)V.get(ind - 1) ; }
		
/**
Au cours d'une énumération descendante, renvoie le prédécesseur.
*/
	form prev() { ind -- ; return (form)V.get(ind + 1) ; }
	
/**
Initialise une énumération ascendante et renvoie le premier élément.
*/
	form first() { ind = 0 ; return next() ; }
	
/**
Initialise une énumération descendante et renvoie le dernier élément.
*/
	form last() { ind = deg() ; return prev() ; }

// 4. INSERTION & SUPPRESSION _______________________________________________________________

/**
Insère une formule à un indice donné.
@param f une formule
@param i un indice
*/
	void ins(form f , int i) { V.add(i , f) ; }
	
/**
Insère une liste à un indice donné.
@param F une liste
@param i un indice
*/
	void ins(liste F , int i) { V.addAll(i , F.V) ; }
	
/**
Insère <i>n</i> copies d'une formule à un indice donné.
@param f une formule
@param n le nombre d'insertions
@param i un indice
*/
	void ins(form f , int n , int i) { for (int j = 0 ; j < n ; j++) V.add(i , f.copie()) ; }
	
/**
Ajoute une formule à la fin de cette liste.
@param f une formule
*/
	void add(form f) { V.addElement(f) ; }
	
/**
Ajoute les éléments d'une liste à la fin de cette liste.
@param F une liste
*/
	void add(liste F) { V.addAll(F.V) ; }
	
/**
Ajoute <i>n</i> copies d'une formule à la fin de cette liste.
@param f une formule
@param n le nombre de copies
*/
	void add(form f , int n) { for (int j = 0 ; j < n ; j++) V.addElement(f.copie()) ; }
	
/**
Supprime un objet.
@param i l'indice de l'objet supprimé
*/
	void rem(int i) { if (( i < 0) || (i > deg())) return ; V.removeElementAt(i) ; }
	
/**
Supprime tous les objets d'indice compris entre deux entiers.
@param i le premier indice
@param j le dernier indice plus une unité
*/
	void rem(int i , int j) { 
		int d = i ; if (i < 0) d = 0 ;
		int f = j ; if (f > length()) f = length() ; 
		for (int k = d ; k < f ; k++) V.removeElementAt(d) ; 
	}
	
/**
Au cours d'une énumération ascendante, supprime le dernier objet renvoyé.
*/
	void remA() { rem(ind - 1) ; ind -- ; }
	
/**
Au cours d'une énumération descendante, supprime le dernier objet renvoyé.
*/
	void remD() { rem(ind + 1) ; }
	
/**
Réinitialise cette liste.
*/
	void clear() { V.clear() ; ind = 0 ; }
	
/**
Redéfinit la taille de cette liste.
@param n un entier définissant la taille
*/
	void resize(int n) { if (n < 0) V.clear() ; else { V.setSize(n) ; V.trimToSize() ; } }
	
// 4. CALCULS _______________________________________________________________________________

/**
Renvoie le produit d'un signe par tous les nombres de cette liste.
@param s un entier définissant un signe
*/
	nbre Nmult(int s) {
		nbre r = new nbre(s) ;
		bot() ; while (hasNext()) r.Nmult(next().getNbre()) ; 
		return r ;
	}
	
/**
Renvoie le produit d'un nombre par tous les coefficients des monômes de cette liste.<br>
Le coefficient de chaque monôme est remis à 1.
@param c un nombre qui est multiplié par les coefficients des monômes
*/
	nbre Mmult(nbre c) {
		nbre r = new nbre(c) ; mono m ;
		bot() ; while (hasNext()) { 
			m = (mono)next() ; r.Nmult(m.coeff) ; m.maj(new nbre(1) , m.deg) ;
		}
		return r ;
	}
	
/**
Renvoie la liste des produits des monômes de cette liste.<br>
*/
	liste monosProd() {
		liste R = new liste() ; mono M , m ;
		while(length() > 0) {
			M = new mono((mono)last()) ; rem(deg()) ;
			bot() ; while(hasNext()) {
				m = (mono) next() ;
				if (m.base.equals(M.base)) { M.Mmult(m) ; remA() ; }
			}
			if (M.deg != 0) R.add(M) ;
		}
		return R ;	
	}
	

// 5. EXTRACTION ____________________________________________________________________________

/**
Renvoie la liste des nombres de cette liste après les avoir supprimés de celle-ci.
*/
	liste extractNbres() { 
		Vector v = new Vector() ; form f ;
		bot() ; while (hasNext()) { 
			f = next() ; if (f instanceof nbre) { v.addElement(f) ; remA() ; }
		}
		return new liste(v) ;
	}

/**
Renvoie la liste des monômes de cette liste après les avoir supprimés de celle-ci.
*/
	liste extractMonos() { 
		Vector v = new Vector() ; form f ;
		bot() ; while (hasNext()) { 
			f = next() ; if (f instanceof mono) { v.addElement(f) ; remA() ; }
		}
		return new liste(v) ;
	}

}
