//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.geom.Point2D ;
import java.awt.geom.Line2D ;
import java.util.Vector ;

/**
* OBJETS 1D : objets dont le dessin est assimilé à un ou plusieurs traits.
* Les méthodes statiques de cette classe permettent de créer ou de reconstruire les objets qui en héritent .
*/

public class line extends objetG {


/*_______________________________________ VARIABLES ________________________________________*/

/**
* Objet <i>form</i> utilisé dans les calculs.
*/
	form e = new form() ;
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________

// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getAcceptTTT(int c , int n) {
		String s = "" ;
		switch (c) {
			case CREATE_POINT_ON_CURVE : s = strpointon[4] + getDefaultTTT() ; break ;
			case CREATE_REC_SEQUENCE : if (this instanceof courbe) s = strrec[3] + getDefaultTTT() ; break ;
			case CREATE_DOMAIN : if (this instanceof courbe) s = strdom[4] + getDefaultTTT() ; break ;
			case CREATE_TANGENT : if (this instanceof courbe) s = strslope[3] + getDefaultTTT() ; break ;
			case CREATE_POINT_INTER : 
				s = ((n == 0) ? strpointinter[1] : strpointinter[4]) + getDefaultTTT() ; 
				break ;
			case CREATE_EQUATION : if (this instanceof courbe) s = strequ[1] + getDefaultTTT() ; break ;
		}
		return s ;
	}
	
//  4. DÉPLACEMENTS ________________________________________________________________________

//  5. LOCALISATION ________________________________________________________________________

//  6. ENREGISTREMENT ______________________________________________________________________

// courbe

/**
* Construction d'une courbe à partir de données enregistrées.
*/
	static void buildCurve(String[] A) {
		courbe c = new courbe(
			calcul.toForm(A[0]) ,
			A[1] ,
			dblv(A[2]) ,
			dblv(A[3])
		) ;
		affectNameColor(c , 4 , A) ;
		Z.GR.add(c) ;
	}

/**
* Construction d'une courbe solution d'une équation différentielle à partir de données enregistrées.
*/
	static void buildEuler(String[] A) {
		euler c = new euler(
			calcul.toForm(A[0]) ,
			"x" ,
			dblv(A[1]) ,
			dblv(A[2]) ,
			dblv(A[3]) ,
			dblv(A[4]) ,
			intv(A[7])
		) ; 
		affectNameColor(c , 5 , A) ;
		Z.GR.add(c) ;
	}

/**
* Construction d'une droite à partir de données enregistrées.
*/
	static void buildLine(String[] A) {
		int type = intv(A[0]) ; droite d ;
		if (type == 0) {
			d = new droite(calcul.toForm(A[1])) ;
			affectNameColor(d , 2 , A) ;
		}
		else if (type == 1) {
			d = new droite(
				(point) Z.GR.elementAt(intv(A[1])) , 
				new Point2D.Float(fltv(A[2]) , fltv(A[3]))
			) ;
			affectNameColor(d , 4 , A) ;
		}
		else {
			d = new droite(
				(point) Z.GR.elementAt(intv(A[1])) , 
				(point) Z.GR.elementAt(intv(A[2]))
			) ;
			affectNameColor(d , 3 , A) ;
		}
		Z.GR.add(d) ;
	}

/**
* Construction d'une tangente à partir de données enregistrées.
*/
	static void buildSlope(String[] A) {
		tangente d  ;
		int type = intv(A[0]) ;
		if (type == 0) {
			d = new tangente(
				(line)Z.GR.elementAt(intv(A[1])) , 
				new Point2D.Float(fltv(A[2]) , fltv(A[3]))
			) ;
			affectNameColor(d , 4 , A) ;
		}
		else {
			d = new tangente((pointsurcourbe)Z.GR.elementAt(intv(A[1]))) ;
			affectNameColor(d , 2 , A) ;
		}
		Z.GR.add(d) ;
	}

/**
* Construction d'une équation à partir de données enregistrées.
*/
	static void buildEquation(String[] A) {
		equation e = new equation(
			(courbe) Z.GR.elementAt(intv(A[0])) , fltv(A[1]) ,
			dblv(A[2]) ,
			dblv(A[3]) ,
			intv(A[4])
		) ;
		affectNameColor(e , 5 , A) ;
		Z.GR.add(e) ;
	}

//  7. DIALOGUES ____________________________________________________________________________

//  8. CRÉATION ____________________________________________________________________________

/**
* Création d'une courbe à partir des données de la barre de dialogue.
*/
	static courbe createCurve(String[] info) {
		form e = calcul.toForm(info[0]) ; if (e == null) return null ;
		String s = info[1].trim() ; if (s.length() == 0) return null ;
		double  x1 = getValue(info[2]) ,
				x2 = getValue(info[3]) ;
		if (def(x1) && def(x2) && (x1 > x2)) { x1 = Double.NaN ; x2 = Double.NaN ; }
		return new courbe(e , s , x1 , x2) ;
	}

/**
* Création d'une courbe solution d'une équation différentielle à partir des données de la barre de dialogue.
*/
	static euler createEuler(String[] info) {
		form e = calcul.toForm(info[0]) ; if (e == null) return null ;
		double  x0 = getValue(info[1]) ,
				y0 = getValue(info[2]) ,
				x1 = getValue(info[3]) ,
				x2 = getValue(info[4]) ,
				np = getValue(info[5]) ;
		if (def(x1) && def(x2) && (x1 > x2)) { x1 = Double.NaN ; x2 = Double.NaN ; }
		if (!def(np) || (np < 0) || (Math.floor(np) != np)) np = 50 ;
		return new euler(e , "x" , x0 , y0 , x1 , x2 , (int)np) ; 
	}

/**
* Création d'une droite à partir des données de la barre de dialogue.
*/
	static droite createLine(String[] info) {
		form f = calcul.toForm(info[0]) ;
		if (f != null) return new droite(f) ;
		else return null ;
	}
	
/**
* Création d'une droite à partir de points.
*/
	static droite createLine(Vector V) {
		if (V.size() != 2) return null ; 
		Object O1 = V.elementAt(0) , O2 = V.elementAt(1) ;
		point A , B ; 
		Point2D.Float a , b ;
		A = (O1 instanceof point) ? (point)O1 : null ;
		if (A == null) return null ; a = A.p ;
		B = (O2 instanceof point) ? (point) O2 : null ;
		b = (O2 instanceof Point2D.Float) ? (Point2D.Float)O2 : null ;
		if ((B == null) && (b == null)) return null ;
		if (b == null) b = B.p ;
		if ((a.x == b.x) && (a.y == b.y)) return null ;
		return (B == null) ? new droite(A , b) : new droite(A , B) ;
	}
	
/**
* Création d'une tangente à partir d'un point.
*/
	static tangente createSlope(objetG og) {
		if (og instanceof line) return new tangente((line)og , mousePoint()) ;
		else if (og instanceof pointsurcourbe) return new tangente((pointsurcourbe)og) ;
		else return null ;
	}

/**
* Création d'une équation à partir d'une courbe.
*/
	static equation createEquation(objetG og) {
		if (og instanceof courbe) return new equation(
			(courbe)og , 
			mousePoint().y ,
			((courbe)og).a ,
			((courbe)og).b ,
			1
		) ;
		else return null ;
	}

//  9. CALCULS _____________________________________________________________________________

	double computeValue(double xd) { return Double.NaN ; }

	double computeDerivative(double xd) { return Double.NaN ; }
	
	double computeLeftDerivative(double xd) { return computeDerivative(xd) ; }

	double computeRightDerivative(double xd) { return computeDerivative(xd) ; }

//  10. INTERSECTION _______________________________________________________________________

	Vector getInter(line L) {
		if (this instanceof droite) return ((droite)this).getInterWith(L) ;
		else if (this instanceof tangente) {
			if (L instanceof droite) return ((droite)L).getInterWith(this) ;
			else return ((tangente)this).getInterWith(L) ;
		}
		else if (this instanceof courbe) {
			if (L instanceof droite) return ((droite)L).getInterWith(this) ;
			else if (L instanceof tangente) return ((tangente)L).getInterWith(this) ;
			else return ((courbe)this).getInterWith(L) ;
		}
		else return new Vector() ; 
	}
	
	Vector getDiffWith(line C , float u , float v) {
		float pas = (float) Math.min(abs(2) - abs(0) , (v - u) / 10f) ;
		
		Vector V = new Vector() ;		
		float xp = u , dp = (float)(computeValue(xp) - C.computeValue(xp)) , x , d , r , y , z ;
		if (dp == 0) V.add(new Point2D.Float(xp , (float)computeValue(xp))) ;
		while (xp < v) {
			x = xp ; d = dp ;
			xp += pas ; if (xp > v) xp = v ; dp = (float)(computeValue(xp) - C.computeValue(xp)) ;
			if (!def(d) || !def(dp)) continue ;
			if (dp == 0) {
				V.add(new Point2D.Float(xp , (float)computeValue(xp))) ;
			}
			else if (d * dp < 0) {
				r = solveD(this , C , x , xp) ;
				if (def(r)) {
					y = (float)computeValue(r) ; z = (float)C.computeValue(r) ;
					if (Math.abs(y - z) < UNIT / UY) V.add(new Point2D.Float(r , (y + z)/2f)) ;
				}
			}
			else if ((d * dp > 0) && (Math.abs(d) < UNIT / UY) && (Math.abs(dp) < UNIT / UY)) {
				r = solveT(this , C , x , xp) ;
				if (def(r)) {
					y = (float)computeValue(r) ; z = (float)C.computeValue(r) ;
					if (Math.abs(y - z) < UNIT / UY) V.add(new Point2D.Float(r , (y + z)/2f)) ;
				}
			}
		}		
		return V ;
	}
	
}
