//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.geom.Line2D ;
import java.awt.geom.Point2D ;

public class euler extends courbe {

/*_______________________________________ VARIABLES ________________________________________*/

	double  x0 = Double.NaN , 
			y0 = Double.NaN ;
	String sf = "y" ; 
	boolean hasFirstPoint ;

/*______________________________________ CONSTRUCTION ______________________________________*/

	public euler(form en , String v , double x , double y , double x1 , double x2 , int n) { 
		super() ; 
		x0 = x ;
		y0 = y ;
		a = x1 ;
		b = x2 ;
		np = n ;
		col = EULER_COLOR ; 
		maj(en , v) ;
	}

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void calcShape() {
		P.reset() ; if (!isDef) return ;
		hasFirstPoint = (def(x0) && def(y0)) ;
		float   x1 = (float)Math.min(XG , XD) , 
				x2 = (float)Math.max(XG , XD) ;
		if (def(a)) x1 = (float)Math.max(x1 , a) ;
		if (def(b)) x2 = (float)Math.min(x2 , b) ;
		float h = (float)(x2 - x1) / np ;
		Point2D.Float   m = new Point2D.Float((float)x0 , (float)y0) , 
						n = new Point2D.Float() ;
		boolean hasFirst = false , hasLast = false ;
		if (x2 > x0) {
			while (m.x < x2) {
				n.x = m.x + h ; if (n.x > x2) n.x = x2 ;
				n.y = m.y + (n.x - m.x) * (float)e.toDouble(sv , m.x , sf , m.y) ;
				if (n.x < x1) { m.setLocation(n) ; continue ; }
				if (def(m) && def(n)) {
					if (!hasFirst) P.moveTo(m.x , m.y) ; P.lineTo(n.x , n.y) ; hasLast = true ;
					
				}
				else break ;
				m.setLocation(n) ; 
				hasFirst = hasLast ; hasLast = false ;
			}
		}
		if (x0 > x1) {
			m.setLocation(x0 , y0) ;
			hasFirst = hasLast = false ;
			while (m.x > x1) {
				n.x = m.x - h ; if (n.x < x1) n.x = x1 ;
				n.y = m.y + (n.x - m.x) * (float)e.toDouble(sv , m.x , sf , m.y) ;
				if (n.x > x2) { m.setLocation(n) ; continue ; }
				if (def(m) && def(n)) {
					if (!hasFirst) P.moveTo(m.x , m.y) ; P.lineTo(n.x , n.y) ; hasLast = true ;
				}
				else break ;
				m.setLocation(n) ;
				hasFirst = hasLast ; hasLast = false ;
			}
		}
	}

	void changeNbPoints(int n) {
		np = n ; calcShape() ; refresh() ;
	}

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________
	
	boolean proche() { 
		if (!isDef) return false ;
		if (hasFirstPoint) {
			float xf = (float) abs(MOUSE.x) , yf = (float)computeValue(xf) ; 
			if (!def(xf) || !def(yf)) return false ;
			return (Math.abs(ordE(yf) - MOUSE.y) < TOLERANCE) ;
		}
		else {
			for (double x = QX * Math.floor(XG / QX) ; x <= XD ; x += QX) {
				for (double y = QY * Math.floor(YB / QY) ; y <= YH ; y += QY) {
					if (mouseIsNear((float)x , (float)y)) return true ;
				}
			}
			return false ;
		}
	}
	
	void trace() {
		if (!isDef) return ;
		GRAPHICS.setColor(col) ;
		if (hasFirstPoint) {
			GRAPHICS.draw(TO_SCREEN.createTransformedShape(S)) ;
		}
		else {
			double u , qd = distE(absE(0) , ordE(0) , absE(QX) , ordE(QY)) / 4 , ud , xp , yp ;
			Line2D.Float L = new Line2D.Float() ;
			boolean drawvect = (qd > 15) ;
			for (double x = QX * Math.floor(XG / QX) ; x <= XD ; x += QX) {
				for (double y = QY * Math.floor(YB / QY) ; y <= YH ; y += QY) {
					u = (double)(float)e.toDouble(sv , (float)x , sf , (float)y) ;
					if (Double.isInfinite(u)) { xp = x ; yp = y + 1 ; }
					else if (def(u)) { xp = x + 1 ; yp = y + u ; }
					else continue ;
					ud = distE(absE(x) , ordE(y) , absE(xp) , ordE(yp)) / qd ;
					xp = x + (xp - x) / ud ; yp = y + (yp - y) / ud ;
					if (drawvect) {
						GRAPHICS.draw(screenVect(screenPoint(x , y) , screenPoint(xp , yp) , 1f , 6f , 20f)) ;
						GRAPHICS.draw(screenVect(screenPoint(x , y) , screenPoint(2*x - xp , 2*y - yp) , 1f , 6f , 20f)) ;
					}
					else {
						L.setLine(xp , yp , 2*x - xp , 2*y - yp) ;
						GRAPHICS.draw(TO_SCREEN.createTransformedShape(L)) ;
					}
				}
			}
		}
	}
	
// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { if (hasFirstPoint) return streuler[0] ;  else return streuler[1] ; }

//  5. LOCALISATION ________________________________________________________________________

	void locate(Point2D.Float pf) { 
		if (hasFirstPoint) {
			if (def(a) && (pf.x < a)) pf.x = (float)a ;
			if (def(b) && (pf.x > b)) pf.x = (float)b ;
			pf.y = (float)computeValue(pf.x) ; 
		}
	}

//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() { 
		StringBuffer sb = new StringBuffer("euler(") ; sb.append(cid) ;
		sb.append(',') ; sb.append(x0) ;
		sb.append(',') ; sb.append(y0) ;
		sb.append(',') ; sb.append(a) ;
		sb.append(',') ; sb.append(b) ;
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}

//  7. DIALOGUES ____________________________________________________________________________
	
	int getStatus() { return CREATE_EULER ; }

	void writeDatas() { 
		D.TF[0].setText(cid) ; 
		D.TF[1].setText((hasFirstPoint) ? form(x0) : "") ; 
		D.TF[2].setText((hasFirstPoint) ? form(y0) : "") ; 
		D.TF[3].setText(def(a) ? form(a) : "") ;
		D.TF[4].setText(def(b) ? form(b) : "") ;
		D.NF[0].setText("" + np) ;
	}
	
	void readDatas() {
		String s ; boolean accepte = true ; form[] f = new form[5] ;
		for(int i = 0 ; i < 5 ; i++) {
			s = D.TF[i].getText() ;
			if (((i == 0) && s.equals(cid)) || (s.length() == 0)) continue ;
			f[i] = calcul.toForm(s) ;
		}
		if (f[0] != null) { e = f[0] ; maj(e , sv) ; }
		double[] nval = new double[4] ; nbre n = null ;
		for(int i = 0 ; i < 4 ; i++) {
			n = (f[i + 1] != null) ? f[i + 1].eval(calcul.EVAL_POLYS).getNbre() : null ;
			nval[i] = (n == null) ? Double.NaN : n.val ;
		}
		x0 = nval[0] ; y0 = nval[1] ; a = nval[2] ; b = nval[3] ; 
		hasFirstPoint = (def(x0) && def(y0)) ;
		recalc() ;
		try{ 
			int nn = Integer.parseInt(D.NF[0].getText()) ;
			if (nn != np) changeNbPoints(nn) ;
		}
		catch(NumberFormatException nfe) {} ;
	}

//  9. CALCULS _____________________________________________________________________________

//	double computeValue(double xd) { return (double) computeValue((float) xd) ; }
	
	double computeValue(double xd) {
		if (!def(xd)) return Double.NaN ;
		float   x1 = (float)Math.min(XG , XD) , 
				x2 = (float)Math.max(XG , XD) ,
				h ;
		if (def(a)) x1 = (float)Math.max(x1 , a) ;
		if (def(b)) x2 = (float)Math.min(x2 , b) ;
		if ((xd < x1) || (xd > x2)) return Double.NaN ;
		Point2D.Float   m = new Point2D.Float((float)x0 , (float)y0) , 
						n = new Point2D.Float() ;
		if (!def(m)) return Float.NaN ;
		h = (float)(x2 - x1) / np ;
		if (xd > x0) {
			while (m.x < xd) {
				n.x = m.x + h ; if (n.x > xd) n.x = (float)xd ;
				n.y = m.y + (n.x - m.x) * (float)e.toDouble(sv , m.x , sf , m.y) ;
				if (!def(n)) return Double.NaN ;
				m.setLocation(n) ;
			}
			return (double)m.y ;
		}
		else if (x0 > xd) {
			while (m.x > xd) {
				n.x = m.x - h ; if (n.x < xd) n.x = (float)xd ;
				n.y = m.y + (n.x - m.x) * (float)e.toDouble(sv , m.x , sf , m.y) ;
				if (!def(n)) return Double.NaN ;
				m.setLocation(n) ;
			}
			return (double)m.y ;
		}
		else return y0 ;
	}
	
	double computeDerivative(double xd) {
		double yd = computeValue(xd) ;
		return e.toDouble(sv , xd , sf , xd) ;
	}

} 
