//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.geom.Ellipse2D ;
import java.awt.geom.GeneralPath ;
import java.awt.geom.Line2D ;
import java.awt.geom.Point2D ;
import java.util.Vector ;

public class equation extends line {

/*_______________________________________ VARIABLES ________________________________________*/

	courbe c ;
	double a = Double.NaN , b = Double.NaN ;
	float vx = Float.NaN , vy = 0f , eps = (float)1E-4 ;
	int pp = 4 , compute = 1 ;
	boolean hasResult = false ;
	Vector V = new Vector() , PT = new Vector() ;
	box mapsto ;
	boolean found ;
	
	GeneralPath P = new GeneralPath() ;
	Ellipse2D.Float E = new Ellipse2D.Float() ;
	Line2D.Float L = new Line2D.Float() ;
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public equation(courbe co , float y , double va , double vb , int cc) {
		S = P ;
		mapsto = box.mapsTo(20f) ; mapsto.translate(5f , 0f) ; mapsto.w += 10f ;
		col = EQUATION_COLOR ;
		affiche = true ;
		c = co ; c.F.add(this) ;
		vy = y ; 
		a = va ; b = vb ;
		compute = cc ;
		recalc() ;
	}

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void recalc() { 
		B = new box() ; V.clear() ; PT.clear() ; vx = Float.NaN ; found = false ;
		eps = (float)Math.pow(10 , -pp) ;
		isDef = c.isDef ;
		hasResult = (isDef && def(a) && def(b) && def(vy)) ;
		if (hasResult) {
			calcPoints() ; 
			if (found) B.suspend(new box(c.sv + " = " + form(vx , pp) , false)) ;
		}
		calcShape() ;
	}
	
	void calcPoints() {
		if (compute == 0) calcPointsB(2) ;
		else if (compute == 1) calcPointsB(10) ;
		else if (compute == 2) calcPointsN() ;
	}
	
	void calcPointsB(int p) {
		double  x1 = a , x2 = b , dx = (b - a) / p , xd = a , xf = b ,
				y1 = c.computeValue(a) , y2 = c.computeValue(b) , 
				v1 = y1 - vy , v2 = y2 - vy ;
		if (v1 == 0) { found = true ; vx = (float)x1 ; return ; }
		if (v2 == 0) { found = true ; vx = (float)x2 ; return ; }
		if (v1 * v2 > 0) return ;
		int i = 0 ;
		while(true) {
			xd = x1 ; xf = x2 ;
			y1 = c.computeValue(x1) ; v1 = y1 - vy ; 
			if (v1 == 0) { found = true ; vx = (float)x1 ; return ; }
			x2 = x1 ;
			for(i = 0 ; i < p ; i++) {
				x2 = (i < p - 1) ? xd + (i + 1) * dx : xf ;
				y2 = c.computeValue(x2) ; v2 = y2 - vy ; 
				if (v2 == 0) { found = true ; vx = (float)x2 ; return ; }
				if (v1 * v2 < 0) break ;
				x1 = x2 ; y1 = y2 ; v1 = v2 ;
			}
			if (i == p) { 
				V.clear() ; return ; 
			}
			V.add(new Object[]{
				form(x1 , pp) , mapsto , form(y1 , pp) , 
				"     " , 
				form(x2 , pp) , mapsto , form(y2 , pp)
			}) ;
			dx /= p ; if (dx < eps) break ;
		}
		vx = (float)(x1 + x2) / 2 ;
		if (V.size() > 0) {
			O = new Object[V.size()][7] ; V.toArray(O) ;
			B = box.boxTab(O , V.size() , 7) ;
		}
	}
	
	void calcPointsN() {
		double  x1 = a , y1 = c.computeValue(a) , d1 = c.computeDerivative((float)a) , x2 , y2 ;
		if (y1 == vy) { found = true ; vx = (float)x1 ; return ; }
		PT.add(new Point2D.Float((float)x1 , (float)y1)) ;
		V.add(new Object[]{form(x1 , pp) , mapsto , form(y1 , pp)}) ;
		int n = 0 ;
		while(true) {
			d1 = c.computeDerivative((float)x1) ; if (!def(d1) || (d1 == 0)) { V.clear() ; PT.clear() ; return ; }
			x2 = x1 + (vy - y1) / d1 ; y2 = c.computeValue(x2) ;
			if (y2 == vy) { found = true ; vx = (float)x2 ; return ; }
			if ((x2 < a) || (x2 > b) || !def(y2)) { 
				V.clear() ; PT.clear() ; return ; 
			}
			PT.add(new Point2D.Float((float)x2 , (float)y2)) ;
			V.add(new Object[]{form(x2 , pp) , mapsto , form(y2 , pp)}) ;
			if (Math.abs(x2 - x1) < eps) break ;
			n ++ ; if (n == 10) { V.clear() ; PT.clear() ; return ; }
			x1 = x2 ; y1 = y2 ; 
		}
		vx = (float)x2 ;
		if (V.size() > 0) {
			O = new Object[V.size()][3] ; V.toArray(O) ;
			B = box.boxTab(O , V.size() , 3) ;
		}
	}
	
	void calcShape() {
		P.reset() ; if (!isDef) return ;
		float y = (float) vy ; if (!def(y)) y = 0 ;
		L.setLine(def(a) ? (float)a : (float)XG , y , def(b) ? (float)b : (float)XD , y) ;
		if (def(vx) && def(vy)) 
			E.setFrame(vx - 2 * UNIT / UX , vy - 2 * UNIT / UY , 4 * UNIT / UX , 4 * UNIT / UY) ;
		if ((compute != 2) || !def(vy) || (PT.size() == 0)) return ;
		Point2D.Float[] pt = new Point2D.Float[PT.size()] ; PT.toArray(pt) ;
		for(int i = 0 ; i < pt.length - 1 ; i ++) {
			P.append(
				userVect(pt[i] , new Point2D.Float(pt[i + 1].x , vy) , 20f , .5f , 8f , 20f) , 
				false
			) ;
			P.lineTo(pt[i + 1].x , pt[i + 1].y) ;
		}
	}
	
	void changeFont() {
		if (hasicon) BI.maj() ;
		if (V.size() > 0) {
			mapsto = box.mapsTo(20f) ; mapsto.translate(5f , 0f) ; mapsto.w += 10f ;
			recalc() ;
		}
	}

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________

	boolean proche() {
		if (!isDef) return false ;
		double x = abs(MOUSE.x) ;
		if (def(a) && (x < a)) return false ;
		if (def(b) && (x > b)) return false ;
		return (Math.abs(ordE(vy) - MOUSE.y) < TOLERANCE) ;
	}

	void trace() {
		if (!isDef) return ;
		if (!def(vy)) {
			GRAPHICS.setColor(Color.white) ; GRAPHICS.draw(TO_SCREEN.createTransformedShape(L)) ;
			GRAPHICS.setStroke(BDASHED) ; GRAPHICS.setColor(AXIS_COLOR) ;
			GRAPHICS.draw(TO_SCREEN.createTransformedShape(L)) ; 
			GRAPHICS.setColor(col) ; 
			GRAPHICS.setStroke(STROKE) ;
			return ; 
		}
		GRAPHICS.setStroke(DASHED) ; GRAPHICS.setColor(col) ;	
		GRAPHICS.draw(TO_SCREEN.createTransformedShape(L)) ;
		GRAPHICS.setStroke(STROKE) ;
		GRAPHICS.draw(P.createTransformedShape(TO_SCREEN)) ;
		if (def(vx)) GRAPHICS.fill(TO_SCREEN.createTransformedShape(E)) ;
		traceinfo() ;
	}
	
// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { return strequ[0] ; }

//  4. DÉPLACEMENTS ________________________________________________________________________

	void deplace() { 
		vy = (float)ordG(MOUSE.y) ;
		recalc() ;
	}
	
//  5. LOCALISATION ________________________________________________________________________

	Point2D.Float defaultLocation() {
		Point2D.Float p = startPoint() ; 
		locate(p) ;
		return  p ; 
	}

	void locate(Point2D.Float pf) {
		if (def(a) && (pf.x < a)) pf.x = (float)a ;
		if (def(b) && (pf.x > b)) pf.x = (float)b ;
		pf.y = vy ; 
	}

//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() {
		StringBuffer sb = new StringBuffer("equation(") ; sb.append(c.no) ;
		sb.append(',') ; sb.append(vy) ;
		sb.append(',') ; sb.append(a) ;
		sb.append(',') ; sb.append(b) ;
		sb.append(',') ; sb.append(compute) ;
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}
	
//  7. DIALOGUES ____________________________________________________________________________

	int getStatus() { return CREATE_EQUATION ; }

	String getId() {
		if (hasName()) return name ;
		else return strequ[5] + c.id + " = " + form(vy) ;
	}

	void writeDatas() {
		if (c.hasName()) D.setIcon(0 , new Object[]{c.getName() , strsymb[1] , strequ[2]}) ;
		else D.setIcon(0 , strequ[2]) ;
		D.TF[0].setText(def(vy) ? form(vy) : "") ; 
		D.setIcon(1 , strequ[3]) ;
		D.TF[1].setText(def(a) ? form(a) : "") ; 
		D.setIcon(2 , new Object[]{strsymb[2] , c.sv , strsymb[2]}) ;
		D.TF[2].setText(def(b) ? form(b) : "") ;
		if (compute != D.solveList.getSelectedIndex()) D.solveList.setSelectedIndex(compute) ;
		D.NF[0].setText("" + pp) ;
		D.setIcon(3 , strequ[4]) ;
		if (affiche != D.ckBox.isSelected()) D.ckBox.setSelected(affiche) ;
	}

	void readDatas() {
		vy = (float)getValue(D.TF[0].getText()) ;
		a = getValue(D.TF[1].getText()) ;
		b = getValue(D.TF[2].getText()) ;
		double vp = getValue(D.NF[0].getText()) ;
		if (def(c.a) && (!def(a) || (a < c.a))) a = c.a ;
		if (def(c.b) && (!def(b) || (b > c.b))) b = c.b ;
		if (def(vp) && (vp >= 0) && (Math.floor(vp) == vp)) pp = (int)vp ;
		recalc() ;
	}
	
}

