//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.geom.Point2D ;
import java.awt.geom.Line2D ;
import java.util.Vector ;

public class droite extends line {

/*_______________________________________ VARIABLES ________________________________________*/

	Line2D.Float L = new Line2D.Float() ;
	
	float   a , 
			b , 
			c ;
			
	point   PA , 
			PB ;

	Point2D.Float   pa = new Point2D.Float() , 
					pb = new Point2D.Float() ;


/*______________________________________ CONSTRUCTION ______________________________________*/

	public droite() { super() ; col = LINE_COLOR ; S = L ; }

	public droite(Point2D.Float p1 , Point2D.Float p2 , int ty) { 
		this() ; 
		pa = p1 ; 
		pb = p2 ; 
		a = pa.y - pb.y ; 
		b = pb.x - pa.x ; 
		type = ty ; 
		recalc() ; 
	}

	public droite(Point2D.Float p1 , Point2D.Float p2) { this(p1 , p2 , 3) ; }

	public droite(point A , point B) {
		this(A.p , B.p , 2) ; 
		PA = A ; PA.F.add(this) ; 
		PB = B ; PB.F.add(this) ;
	}

	public droite(point A , Point2D.Float pf) {
		this(A.p , pf , 1) ; 
		PA = A ; PA.F.add(this) ; 
	}

	public droite(form en) { 
		this() ; type = 0 ; maj(en) ;
	}
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void maj(form en) {
		cid = en.toString() ;
		form f ;
		if ((en.op != null) && (en.op.nom.equals("="))) e = calcul.nsom(en.F.first() , en.F.next().Gopp()) ;
		else e = en ;
		id = e.toString() ;
		c = (float)e.toDouble("x" , 0f , "y" , 0f) ;
		a = (float)e.toDouble("x" , 1f , "y" , 0f) - c ;
		b = (float)e.toDouble("x" , 0f , "y" , 1f) - c ;
		pa = defaultLocation() ; pb.setLocation(pa.x + b , pa.y - a) ;
		recalc() ;
	}
	
	void recalc() {
		if (type == 1) { pb.setLocation(pa.x + b , pa.y - a) ; }
		else if (type > 0) { a = pa.y - pb.y ; b = pb.x - pa.x ; }
		isDef = ((a != 0) || (b != 0)) ;
		if (type > 0) { c = - (a * pa.x + b * pa.y) ; isDef = (isDef && def(pa) && def(pb)) ; }
		calcShape() ;
		refresh() ;
	}

	void calcShape() {
		if (!isDef) { L.setLine(Float.NaN , Float.NaN , Float.NaN , Float.NaN) ; return ; }
		Point2D.Float   pc = new Point2D.Float((float)XG , (float)YH) ,
						pd = new Point2D.Float((float)XG , (float)YB) ,
						pi= pointInter(pa , pb , pc , pd) ;
		int n = 0 ;
		if (isVisible(pi)) { L.setLine(pi.x , pi.y , (float)L.getX2() , (float)L.getY2()) ; n++ ; }
		pc.setLocation(pd) ; pd.setLocation((float)XD , (float)YB) ;
		setPointInter(pi , pa , pb , pc , pd) ;
		if (isVisible(pi)) { 
			if (n == 0) L.setLine(pi.x , pi.y , (float)L.getX2() , (float)L.getY2()) ;
			else L.setLine((float)L.getX1() , (float)L.getY1() , pi.x , pi.y) ;
			n++ ; if (n == 2) return ; 
		}
		pc.setLocation(pd) ; pd.setLocation((float)XD , (float)YH) ;
		setPointInter(pi , pa , pb , pc , pd) ;
		if (isVisible(pi)) { 
			if (n == 0) L.setLine(pi.x , pi.y , (float)L.getX2() , (float)L.getY2()) ;
			else L.setLine((float)L.getX1() , (float)L.getY1() , pi.x , pi.y) ;
			n++ ; if (n == 2) return ; 
		}
		pc.setLocation(pd) ; pd.setLocation((float)XG , (float)YH) ;
		setPointInter(pi , pa , pb , pc , pd) ;
		if (isVisible(pi)) { 
			if (n == 0) L.setLine(pi.x , pi.y , (float)L.getX2() , (float)L.getY2()) ;
			else L.setLine((float)L.getX1() , (float)L.getY1() , pi.x , pi.y) ;
			n++ ;
		}		
		if (n < 2) L.setLine(Float.NaN , Float.NaN , Float.NaN , Float.NaN) ;		
	}

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________

	void projPoint(Point2D.Float p) {
		float l = - (a*p.x + b*p.y + c) / (a*a + b*b) ;
		p.setLocation(p.x + a*l , p.y + b*l) ;
	}

	Point2D.Float pointProj(Point2D.Float p) {
		float l = - (a*p.x + b*p.y + c) / (a*a + b*b) ;
		return new Point2D.Float(p.x + a*l , p.y + b*l) ;
	}

	boolean proche(Point2D.Float p) {
		Point2D.Float q = pointProj(p) ;
		if ((this instanceof demidroite) && (dotProduct(pa , q , pb) < 0)) return false ;
		else return isNear(p , q) ;
	}
	
	boolean proche() { 
		if (!isDef) return false ;
		else return mouseIsNear(pointProj(mousePoint())) ; 
	}
	
	
// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { return strline[0] ; }

//  7. DIALOGUES ____________________________________________________________________________

	String getIdentifier() {
		if (!isDef) cid = "" ;
		else if (type == 0) return cid ;
		else if (b != 0) {
			String s1 = form(Math.abs(-a/b)) , s2 = form(Math.abs(-c/b)) ;
			cid  = "y = " ;
			if (s1.equals("0")) cid += form(-c/b) ;
			else {
				if (-a/b < 0) cid += "-" ;
				if (!s1.equals("1")) cid += s1 + "*" ;
				cid += "x" ;
				if (!s2.equals("0")) {
					if (-c/b < 0) cid += " - " ; else cid += " + " ; cid += s2 ;
				}
			}
		}
		else cid = "x = " + form(-c/a) ;
		return cid ;
	}
	
	String getIdent() {
		form f = calcul.toForm(getIdentifier()) ;
		if (f == null) return strline[5] ; else return form(f.toString()) ;
	}
	
//  10. INTERSECTION _______________________________________________________________________

	Point2D.Float interDroite(droite D) {
		if (!isDef || !D.isDef) return null ; 
		Point2D.Float r = pointInter(pa , pb , D.pa , D.pb) ;
		if (contains(r) && D.contains(r)) return r ;
		else return null ; 
	}
	
	Vector getInterWith(line l) {
		Vector V = new Vector() ; if (!isDef) return V ;
		Point2D.Float r ; float u , v ;
		if (l instanceof droite) {
			droite D = (droite)l ;
			if (D.isDef) {
				r = interDroite(D) ; if (r != null) V.add(r) ;
			}
		}
		else if (l instanceof tangente) {
			tangente T = (tangente)l ;
			if (T.isDef) {
				if (T.ta) return getInterWith(T.tgd) ;
				else if (T.tg && !T.td) V.addAll(getInterWith(T.tag)) ;
				else if (!T.tg && T.td) V.addAll(getInterWith(T.tad)) ;
				else {
					r = interDroite(T.tag) ; if (r != null) V.add(r) ;
					r = interDroite(T.tad) ; if (r != null) V.add(r) ;
				}
			}
		}
		else if (l instanceof courbe) {
			courbe C = (courbe)l ;
			if (b == 0) {
				u = -c/a ;
				if ((!def(C.a) || (u >= C.a)) && (!def(C.b) || (u <= C.b))) {
					r = new Point2D.Float(u , (float)C.computeValue(u)) ; if (contains(r)) V.add(r) ;
				}
			}
			else {
				u = (float) Math.min(L.x1 , L.x2) ; if (def(C.a) && (u < C.a)) u = (float)C.a ;
				v = (float) Math.max(L.x1 , L.x2) ; if (def(C.b) && (v > C.b)) v = (float)C.b ;
				V.addAll(getDiffWith(C , u , v)) ;
			}
		}
		return V ; 
	}
	

//  4. DÉPLACEMENTS ________________________________________________________________________

	void deplace() {
		if (type == 0) return ;
		if (type == 1) {
			Point2D.Float mp = gridPoint() ;
			if (dotProduct(pa , mp , pb) >= 0) pb.setLocation(mp) ;
			else pb.setLocation(2*pa.x - mp.x , 2*pa.y - mp.y) ; 
			a = PA.p.y - pb.y ; b = pb.x - PA.p.x ; 
			recalc() ;
		}
		else if (type == 2) {
			if (! (PA instanceof pointlibre) || ! (PB instanceof pointlibre)) return ;
			double u = (MOUSE.x - MOUSE_START.x) * UNIT / UX , v = (MOUSE_START.y - MOUSE.y) * UNIT / UY ;
			((pointlibre)PA).translate(u , v) ; ((pointlibre)PB).translate(u , v) ; 
		}
	}
	
//  5. LOCALISATION ________________________________________________________________________

	boolean contains(Point2D.Float p) { return (isDef && def(p) && proche(p)) ; }
	
	Point2D.Float defaultLocation() { return  pointProj(startPoint()) ; }

	void locate(Point2D.Float p) { projPoint(p) ; }
	
	void setParamFor(pointsurcourbe ps) {
		projPoint(ps.p) ;
		ps.radius = pa.distance(ps.p) ;
		ps.param = (type == 1) ? getDegrees(pa , ps.p) - getDegrees(pa , pb) :
								 dotProduct(pa , ps.p , pb) / pa.distanceSq(pb) ;
		if(!def(ps.param)) ps.param = 0 ;
	}
			
	void locate(pointsurcourbe ps) {
		if (type == 0) locate(ps.p) ;
		else if (type == 1) ps.p.setLocation(pointMove(pa , ps.radius , getDegrees(pa , pb) + ps.param)) ;
		else ps.p.setLocation(pa.x + ps.param*(pb.x - pa.x) , pa.y + ps.param*(pb.y - pa.y)) ;
	}
	
//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() {
		StringBuffer sb = new StringBuffer("droite(") ;
		sb.append(type) ; sb.append(',') ;
		if (type == 0) sb.append(cid) ;
		else if (type == 1) {
			sb.append(PA.no) ; sb.append(',') ; sb.append(pb.x) ; sb.append(',') ; sb.append(pb.y) ;
		}
		else if (type == 2) {
			sb.append(PA.no) ; sb.append(',') ; sb.append(PB.no) ;
		}
		else {
			sb.append(pa.x) ; sb.append(',') ; sb.append(pa.y) ;
			sb.append(',') ; sb.append(pb.x) ; sb.append(',') ; sb.append(pb.y) ;
		}
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}


	
//  7. DIALOGUES ____________________________________________________________________________
	
	int getStatus() { return CREATE_LINE ; }

	String getId() {
		if (hasName()) return name ;
		else return strline[6] + getIdentifier() ;
	}

	void writeDatas() {
		D.setIcon(0);
		if (hasName()) D.setIcon(0 , new Object[] {getName() , strsymb[1]}) ;
		else D.setIcon(0 , new Object[] {strline[3] , strline[4]}) ;
		if (type > 0) {
			if (isDef) D.addIcon(0 , getIdent()) ; 
			else D.addIcon(0 , strline[5]) ;
		}
		else D.TF[0].setText(getIdent()) ;
	}

	void readDatas() {
		if (type > 0) return ;
		String s = D.TF[0].getText() ; if(s.equals(cid)) return ;
		form f = calcul.toForm(s) ;
		if (f != null) maj(e = f) ;
	}

//  9. CALCULS _____________________________________________________________________________

	double computeValue(double xd) { return -(c + a*xd) / b ; }

	double computeDerivative(double xd) { return - a / b ; }
	
}

