//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.geom.GeneralPath ;
import java.awt.geom.Point2D ;

public class domaine extends area {

/*_______________________________________ VARIABLES ________________________________________*/

	courbe c ;
	double a = Double.NaN , b = Double.NaN , va = a , vb = b ;
	boolean hasResult = false ;
	int compute = 0 ; 
	float[] aire = new float[5] ; 
	Point2D.Float[] pt , pti ;
	GeneralPath RE = new GeneralPath() , 
				TR = new GeneralPath() , 
				MI = new GeneralPath() , 
				SI = new GeneralPath() ;
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public domaine() { 
		np = 4 ; col = DOMAIN_COLOR ; colf = DOMAIN_BACK_COLOR ; affiche = true ;
		pt = new Point2D.Float[np + 1] ; pti = new Point2D.Float[np] ;
	}
	
	public domaine(courbe co) {
		this() ; c = co ; c.F.add(this) ;
		a = c.a ; b = c.b ; recalc() ;
	}
	
	public domaine(courbe co , double va , double vb) {
		this() ; c = co ; c.F.add(this) ;
		a = va ; b = vb ; recalc() ;
	}
	
	public domaine(courbe co , double va , double vb , int comp , int n) {
		col = DOMAIN_COLOR ; 
		colf = DOMAIN_BACK_COLOR ; 
		affiche = true ;
		c = co ; 
		c.F.add(this) ;
		a = va ; 
		b = vb ; 
		compute = comp ; 
		np = n ; 
		pt = new Point2D.Float[np + 1] ; 
		pti = new Point2D.Float[np] ;
		recalc() ;
	}
	
/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void recalc() {
		isDef = c.isDef ;
		calcShape() ;
		if (hasResult) calcArea() ;
	}
	
	void calcShape() {
		if (def(c.a) && (!def(a) || (a < c.a))) a = c.a ;
		if (def(c.b) && (!def(b) || (b > c.b))) b = c.b ;
		hasResult = (isDef && def(a) && def(b) && (np > 0)) ;
		va = (def(a)) ? a : XG ; 
		vb = (def(b)) ? b : XD ;
		if (va < XG) va = XG ; 
		if (vb > XD) vb = XD ;
		c.putPath(this , (float)va , (float)vb) ;		
	}
	
	void calcArea() {
		if (pti.length != np) {
			pt = new Point2D.Float[np + 1] ; pti = new Point2D.Float[np] ;
		}
		float h = (float)(b - a) / np , xf = (float)a - h , yf ;
		for(int j = 0 ; j < 5 ; j++) aire[j] = 0f ;
		for(int i = 0 ; i < np + 1 ; i++) {
			xf += h ; yf = (float)c.computeValue(xf) ;
			pt[i] = new Point2D.Float(xf , yf) ;
			if (i < np) aire[0] += yf ; if (i > 0) aire[1] += yf ;
			if (i == np) continue ;
			yf = (float)c.computeValue(xf + h/2) ; pti[i] = new Point2D.Float(xf + h/2 , yf) ;
			aire[3] += yf ;
		}
		aire[2] = (aire[0] + aire[1]) / 2 ; aire[4] = (2*aire[3] + aire[2]) / 3 ;
		for(int j = 0 ; j < 5 ; j++) aire[j] *= h ;
		O = new Object[][]{
			new Object[]{ calcul.toForm(strdom[5]) , strsymb[3] , form(aire[0] , 5) } ,
			new Object[]{ calcul.toForm(strdom[6]) , strsymb[3] , form(aire[1] , 5) } ,
			new Object[]{ calcul.toForm(strdom[7]) , strsymb[3] , form(aire[2] , 5) } ,
			new Object[]{ calcul.toForm(strdom[8]) , strsymb[3] , form(aire[3] , 5) } ,
			new Object[]{ calcul.toForm(strdom[9]) , strsymb[3] , form(aire[4] , 5) }
		} ;
		B = box.boxTab(O , 5 , 3) ;

		RE.reset() ; TR.reset() ; MI.reset() ; SI.reset() ; 
		for(int i = 0 ; i < np ; i++) {
			RE.moveTo(pt[i].x , pt[i].y) ; RE.lineTo(pt[i].x , 0f) ; RE.lineTo(pt[i + 1].x , 0f) ; RE.lineTo(pt[i + 1].x , pt[i].y) ; RE.lineTo(pt[i].x , pt[i].y) ;
			RE.lineTo(pt[i].x , pt[i + 1].y) ; RE.lineTo(pt[i + 1].x , pt[i + 1].y) ; RE.lineTo(pt[i + 1].x , pt[i].y) ; RE.lineTo(pt[i].x , pt[i].y) ;

			TR.moveTo(pt[i].x , pt[i].y) ; TR.lineTo(pt[i].x , 0f) ; TR.lineTo(pt[i + 1].x , 0f) ; TR.lineTo(pt[i + 1].x , pt[i + 1].y) ; TR.lineTo(pt[i].x , pt[i].y) ;
			
			MI.moveTo(pti[i].x , pti[i].y) ; MI.lineTo(pt[i].x , pti[i].y) ; MI.lineTo(pt[i].x , 0f) ; MI.lineTo(pt[i + 1].x , 0f) ;
			MI.lineTo(pt[i + 1].x , pti[i].y) ; MI.lineTo(pti[i].x , pti[i].y) ; 
			
			SI.moveTo(pt[i].x , pt[i].y) ; SI.lineTo(pt[i].x , 0f) ; SI.lineTo(pt[i + 1].x , 0f) ; SI.lineTo(pt[i + 1].x , pt[i + 1].y) ; 
			SI.quadTo(pti[i].x , 2*pti[i].y - (pt[i].y + pt[i + 1].y) / 2 , pt[i].x , pt[i].y) ;
		}
	}
	
	void changeNbPoints(int n) {
		np = n ; 
		if (hasResult) calcArea() ;
	}
	
	void changeFont() { 
		if (hasicon) BI.maj() ;
		if (hasResult) B = box.boxTab(O , 5 , 3) ; 	
	}

// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________
	
	boolean proche() {
		if (!isDef) return false ;
		Point2D.Float m = mousePoint() ;
		if (hasResult) return P.contains(m) ;
		else return ((m.x >= va) && (m.x <= vb) && (Math.abs(MOUSE.y - ORIGIN.y) < TOLERANCE) ) ;
	}
	
	void trace() {
		if (!isDef) return ;
		if (!hasResult) {
			GRAPHICS.setColor(Color.white) ; GRAPHICS.draw(P.createTransformedShape(TO_SCREEN)) ;
			GRAPHICS.setStroke(BDASHED) ; GRAPHICS.setColor(AXIS_COLOR) ;
			GRAPHICS.draw(P.createTransformedShape(TO_SCREEN)) ; 
			GRAPHICS.setColor(col) ; 
			GRAPHICS.setStroke(STROKE) ;
			return ; 
		}
		GRAPHICS.setColor(colf) ;
		GRAPHICS.fill(P.createTransformedShape(TO_SCREEN)) ;
		GRAPHICS.setColor(col) ;
		if (!hasResult) return ;
		if (compute > 0)
			GRAPHICS.draw(	(compute == 1) ? RE.createTransformedShape(TO_SCREEN) :
							(compute == 2) ? TR.createTransformedShape(TO_SCREEN) :
							(compute == 3) ? MI.createTransformedShape(TO_SCREEN) :
							SI.createTransformedShape(TO_SCREEN)
			) ;
		traceinfo() ;
	}	

// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { return strdom[0] ; }
	
//  5. LOCALISATION ________________________________________________________________________

	Point2D.Float defaultLocation() {
		double xl = (def(a) && def(b)) ? (a+b)/2 : (def(a)) ? (a+XD)/2 : (def(b)) ? (XG + b)/2 : 0 ;
		return new Point2D.Float((float)xl , (float)c.computeValue(xl) / 2) ;
	}

//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() { 
		StringBuffer sb = new StringBuffer("domaine(") ; sb.append(c.no) ;
		sb.append(',') ; sb.append(a) ;
		sb.append(',') ; sb.append(b) ;
		sb.append(',') ; sb.append(compute) ;
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}
	
// 7. DIALOGUES ____________________________________________________________________________

	int getStatus() { return CREATE_DOMAIN ; }

	void writeDatas() {
		D.setIcon(0 , strdom[1]) ;
		if (hasName()) D.addIcon(0 , new Object[]{strsymb[0] , getName()}) ;
		if (c.hasName()) D.addIcon(0 , new Object[]{strdom[2] , c.getName()}) ;
		D.addIcon(0 , strdom[3]) ;
		D.TF[0].setText(def(a) ? form(a) : "") ; 
		D.setIcon(1 , new Object[]{strsymb[2] , c.sv , strsymb[2]}) ;
		D.TF[1].setText(def(b) ? form(b) : "") ;
		D.NF[0].setText("" + np) ;
		if (compute != D.methodList.getSelectedIndex()) D.methodList.setSelectedIndex(compute) ;
		if (affiche != D.ckBox.isSelected()) D.ckBox.setSelected(affiche) ;
	}

	void readDatas() {
		double  x1 = getValue(D.TF[0].getText()) ,
				x2 = getValue(D.TF[1].getText()) ,
				vn = getValue(D.NF[0].getText()) ;
		if (def(x1) && def(x2) && (x1 > x2)) { x1 = a ; x2 = b ; }
		if (def(c.a) && (!def(x1) || (x1 < c.a))) x1 = c.a ;
		if (def(c.b) && (!def(x2) || (x2 > c.b))) x2 = c.b ;
		int nn = (!def(vn) || (vn < 0) || (Math.floor(vn) != vn)) ? np : (int) vn ;
		if ((x1 != a) || (x2 != b)) { 
			np = nn ; 
			if (pti.length != np) {
				pt = new Point2D.Float[np + 1] ; 
				pti = new Point2D.Float[np] ;
			}
			a = x1 ; 
			b = x2 ; 
			recalc() ; 
		}
		else if (nn != np) changeNbPoints(nn) ;
	}
	
	
}