//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//  Created by Joël AMBLARD on Mon Oct 11 2004.
//  Copyright (c) 2004 __TSMaths__. All rights reserved.
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.* ;
import javax.swing.* ;
import java.awt.event.ActionListener ;
import java.awt.event.ActionEvent ;
import java.awt.event.ItemListener ;
import java.awt.event.ItemEvent ;
import java.util.Vector ;
import java.awt.geom.AffineTransform ;

public class dial extends JToolBar {

/** 
* Nombre indiquant que la création d'une courbe est demandée.
*/
	static int CREATE_CURVE = dessin.CREATE_CURVE ;

/** 
* Nombre indiquant que la création d'un point sur une courbe est demandée.
*/
	static int CREATE_POINT_ON_CURVE = dessin.CREATE_POINT_ON_CURVE ;

/** 
* Nombre indiquant que la création d'une suite définie par récurrence est demandée.
*/
	static int CREATE_REC_SEQUENCE = dessin.CREATE_REC_SEQUENCE ;

/** 
* Nombre indiquant que la création d'une suite définie par une fonction est demandée.
*/
	static int CREATE_GEN_SEQUENCE = dessin.CREATE_GEN_SEQUENCE ;

/** 
* Nombre indiquant que la création d'une courbe solution d'une équation différentielle est demandée.
*/
	static int CREATE_EULER = dessin.CREATE_EULER ;

/** 
* Nombre indiquant que la création d'un domaine est demandée.
*/
	static int CREATE_DOMAIN = dessin.CREATE_DOMAIN ;

/** 
* Nombre indiquant que la création d'un point libre est demandée.
*/
	static int CREATE_POINT = dessin.CREATE_POINT ;

/** 
* Nombre indiquant que la création d'une droite est demandée.
*/
	static int CREATE_LINE = dessin.CREATE_LINE ;

/** 
* Nombre indiquant que la création d'une tangente est demandée.
*/
	static int CREATE_TANGENT = dessin.CREATE_TANGENT ;

/** 
* Nombre indiquant que la création d'un point d'intersection est demandée.
*/
	static int CREATE_POINT_INTER = dessin.CREATE_POINT_INTER ;

/** 
* Nombre indiquant que la création d'une équation est demandée.
*/
	static int CREATE_EQUATION = dessin.CREATE_EQUATION ;

/** 
* Nombre indiquant que la création d'une marque est demandée.
*/
	static int CREATE_MARK = dessin.CREATE_MARK ;
	
/** 
* Nombre indiquant que la création d'un texte est demandée.
*/
	static int CREATE_TEXT = dessin.CREATE_TEXT ;

	public zone Z ;											
	objetG o , od ;											
	int status = -1 , type = -1 ;							
	public Vector PARAMS = new Vector() ;
	boolean create = false ,
			usepane = false ,
			vis = false ;

	static AffineTransform T = new AffineTransform() ;
	
// écouteurs  ______________________________________________________________________________
	ActionListener fieldListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			if (ae.getSource() instanceof JTextField) {
				String[] sf = gatherDatas() ;
				if (create) {
					if (status == CREATE_CURVE) send(line.createCurve(sf)) ;
					else if (status == CREATE_GEN_SEQUENCE) send(point.createGenSequence(sf)) ;
					else if (status == CREATE_EULER) send(line.createEuler(sf)) ;
					else if (status == CREATE_POINT) send(point.createPoint(sf)) ;
					else if (status == CREATE_LINE) send(line.createLine(sf)) ;
					else if (status == CREATE_TEXT) send(area.createText(sf , decorList.getSelectedIndex())) ;
				}
				else { o.readDatas() ; Z.repaint() ; }
				refresh() ;
			}
		}
	} ;
	
	ActionListener buttonListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			if (ae.getSource() instanceof JButton) {
				activate() ;
				setVisible(false) ;
				status = type = 0 ;
			}
		}
	} ;
	
	ActionListener formListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			int pp ;
			if ((ae.getSource() instanceof JTextField) && (o != null)) {
				try {
					pp = Integer.parseInt(((JTextField)ae.getSource()).getText()) ;
				}
				catch(NumberFormatException nfe) { return ; }
				if (o instanceof equation) {
					if ((pp >= 0) && (pp <= 10)) { ((equation)o).pp = pp ; o.recalc() ; }
				}
				else if (o instanceof domaine) {
					if ((pp >= 0) && (pp <= 10)) { o.changeNbPoints(pp) ; ((domaine)o).calcShape() ; }
				}
				else if (o instanceof euler) {
					if ((pp > 0) && (pp <= 100)) o.changeNbPoints(pp) ;
				}
				else if (o instanceof suiterec) {
					if ((pp >= 0) && (pp <= 15)) { ((suiterec)o).np = pp ; o.recalc() ; }
				}
				else if (o instanceof suitegen) {
					if ((ae.getSource() == NF[0]) && (pp >= 0)) {
						((suitegen)o).n0 = pp ; o.recalc() ; 
					}
					if ((ae.getSource() == NF[1]) && (pp >= 0) && (pp <= 15)) { 
						((suitegen)o).np = pp ; o.recalc() ; 
					}
				}
				refresh() ; Z.repaint() ;
			}
		}
	} ;
	
	void activate() { fieldListener.actionPerformed(new ActionEvent(TF[0] , 0 , "")) ; }
	
	ItemListener checkListener = new ItemListener() {
		public void itemStateChanged(ItemEvent ie) {
			if (o != null) o.affiche = (ie.getStateChange() == ItemEvent.SELECTED) ;
			Z.repaint() ;
		}
	} ;
	
	ActionListener comboListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) {
			int pp ;
			if ((ae.getSource() instanceof JComboBox) && (o != null)) {
				pp = ((JComboBox)ae.getSource()).getSelectedIndex() ;
				if (o instanceof equation) ((equation)o).compute = pp ;
				else if (o instanceof domaine) ((domaine)o).compute = pp ;
				else if (o instanceof text) ((text)o).type = pp ;
				o.recalc() ; 
				Z.repaint() ;
			}
		}
	} ;
	
// lecture de données  _________________________________________________________________

	String[] gatherDatas() {
		int n = panelCommand.getComponentCount() ; 
		Component c ; Vector V = new Vector() ;
		for (int i = 0 ; i < n ; i++) {
			c = panelCommand.getComponent(i) ;
			if (c instanceof JTextField) V.add(((JTextField)c).getText()) ;
		}
		String[] sf = new String[V.size()] ; V.toArray(sf) ;
		return sf ;
	}

	
	
// écriture de données  ________________________________________________________________

	void setObject(objetG og) {
		o = og ; Z.A.setObject(o) ; 
		create = false ; PARAMS.clear() ; setVisible(vis) ;
		usepane = (usepane && (status == og.getStatus()) && (type == og.type) ) ;
		if (!usepane) {
			usepane = true ; status = o.getStatus() ; type = o.type ;
			setPanel(status , type) ;
		}
		o.writeDatas() ;
	}
	
	void setCreate(int s) {
		o = null ; 
		create = true ; PARAMS.clear() ; setVisible(s > -1) ;
		status = s ; type = 0 ;
		if (   (s == CREATE_POINT_ON_CURVE) || (s == CREATE_REC_SEQUENCE) || (s == CREATE_DOMAIN)
			|| (s == CREATE_POINT) || (s == CREATE_TANGENT) || (s == CREATE_POINT_INTER)
			|| (s == CREATE_EQUATION) || (s == CREATE_MARK)
		) {
			s = 0 ; defIcon.maj(dialcreate[status]) ;
		}
		setPanel(s , type) ; 
		if ((status == CREATE_LINE)  || (s == CREATE_TEXT)) { I[0].maj(dialcreate[status]) ; type = 0 ; }
		Z.repaint() ;
	}
	
	void advanceStatus() {
		if (status == CREATE_LINE) {
			setPanel(CREATE_LINE , type = 1) ;
			I[0].maj(dialadvance[0] + ((objetG)PARAMS.elementAt(0)).getId()) ;
		}
		else if (status == CREATE_POINT_INTER) {
			objetG og = (objetG)PARAMS.elementAt(0) ;
			if (og.hasName()) defIcon.maj(new Object[]{dialadvance[1] , og.getName() , dialadvance[2]}) ;
		}
	}
	
// création d'un objet  _________________________________________________________________

	void ask(objetG og) {
		if (!create || (og == null)) return ;
		if ((status == 2) && (og instanceof line)) send(point.createPointOnCurve(og)) ;
		else if ((status == 3) && (og instanceof courbe)) send(new suiterec((courbe)og , dessin.mousePoint() , 5)) ;
		else if ((status == 6) && (og instanceof courbe)) 
			send(new domaine(
				(og.getStatus() == 1) ? (courbe)og : (euler)og 
			)) ;
		else if ((status == 8) && (og instanceof point)) {
			PARAMS.add(og) ; 
			if (PARAMS.size() == 1) advanceStatus() ;
			if (PARAMS.size() == 2) { send(line.createLine(PARAMS)) ; PARAMS.clear() ; }
		}
		else if (status == 9) {
			if ((og instanceof line) || (og instanceof pointsurcourbe)) send(line.createSlope(og)) ;
		}
		else if (status == 10) {
			if (og instanceof line) {
				PARAMS.add(og) ; 
				if (PARAMS.size() == 1) advanceStatus() ;
				if (PARAMS.size() == 2) { send(point.createPointInter(PARAMS)) ; PARAMS.clear() ; }
			}
		}
		else if ((status == 11) && (og instanceof courbe)) send(line.createEquation(og)) ;
	}
	
	void ask(int X , int Y) {
		if (status == 7) send(point.createPoint()) ; 
		if (!create) return ; objetG oc ;
		if (status == 8) {
			if (PARAMS.size() == 0) {
				oc = point.createPoint() ; if (oc == null) return ;
				Z.GR.add(oc) ; Z.repaint() ;
				PARAMS.add(oc) ; advanceStatus() ;
			}
			else PARAMS.add(dessin.mousePoint()) ;
			if (PARAMS.size() == 2) {
				send(line.createLine(PARAMS)) ; PARAMS.clear() ; 
			}
		}
		else if (status  == 12) {
			if (Math.abs(dessin.MOUSE.y - dessin.ORIGIN.y) < dessin.TOLERANCE) send(new marque(false , (dessin.gridPoint()).x)) ;
			else if (Math.abs(dessin.MOUSE.x - dessin.ORIGIN.x) < dessin.TOLERANCE) send(new marque(true , (dessin.gridPoint()).y)) ; 
		}
	}

	void send(objetG og) {
		if (og == null) { Z.select() ; return ; }
		create = Z.create = false ; Z.modify = true ; 
		
		o = Z.od = og ;
		Z.GR.add(og) ;
		if (og.hasicon) Z.GR.add(og.BI) ;
		Z.repaint() ;
		setObject(o) ;
	}
	
	void refresh() { 
		if (o != null) o.writeDatas() ; 
	}
	
// composants  _____________________________________________________________________________

	JPanel panelCommand = new JPanel() , panelButton = new JPanel() ;
	
	JButton validButton ;
	
	void addOK() { add(Box.createHorizontalGlue()) ; add(validButton) ; add(Box.createHorizontalStrut(12)) ; }
	
	JLabel defLabel = new JLabel() ;
	
	JLabel[] LB = new JLabel[] {
		new JLabel() , new JLabel() , new JLabel() , new JLabel() , new JLabel() , new JLabel()
	} ;
	
	icon defIcon = new icon() ;
	
	icon[] I = new icon[] {
		new icon() , new icon() , new icon() , new icon() , new icon() , new icon()
	} ;
	
	void setIcon(String t) { defIcon.maj(t) ; defLabel.revalidate() ; }
	
	void setIcon(form f) { defIcon.maj(f) ; defLabel.revalidate() ; }
	
	void setIcon(Object[] O) { defIcon.maj(O) ; defLabel.revalidate() ; }
	
	void setIcon(int i) { I[i].reset() ; LB[i].revalidate() ; }	
	
	void setIcon(int i , String t) { I[i].maj(t) ; LB[i].revalidate() ; }
	
	void setIcon(int i , form f) { I[i].maj(f) ; LB[i].revalidate() ; }
	
	void setIcon(int i , Object[] O ) { I[i].maj(O) ; LB[i].revalidate() ; }
	
	void addIcon(int i , String t) { I[i].add(t) ; LB[i].revalidate() ; }
	
	void addIcon(int i , form f) { I[i].add(f) ; LB[i].revalidate() ; }
	
	void addIcon(int i , Object[] O ) { I[i].add(O) ; LB[i].revalidate() ;  }
	
	void addLabel(int i) { panelCommand.add(LB[i]) ; setIcon(i) ; }
	
	void addLabel(int i , String t) { panelCommand.add(LB[i]) ; setIcon(i , t) ; }
	
	void addLabel(int i , form f) { panelCommand.add(LB[i]) ; setIcon(i , f) ; }
	
	void addLabel(int i , Object[] O) { panelCommand.add(LB[i]) ; setIcon(i , O) ; }
	
	JTextField[] TF = new JTextField[] {
		new JTextField() , new JTextField() , new JTextField() , new JTextField() , new JTextField()
	} ;
	
	void addTextField(int i , int c) {
		panelCommand.add(TF[i]) ; TF[i].setColumns(c) ; TF[i].setText("") ;
	}
	
	void addTextField(int i , int c , String t) {
		panelCommand.add(TF[i]) ; TF[i].setColumns(c) ; TF[i].setText(t) ;
	}
	
	JTextField[] NF = new JTextField[] {new JTextField(2) , new JTextField(2) , new JTextField(2) } ;
	
	void addNbField(int i , int n , int c) {
		panelCommand.add(NF[i]) ; NF[i].setText("" + n) ; NF[i].setColumns(c) ;
	}
	
	JCheckBox ckBox ;
	
	void addCB() { panelCommand.add(ckBox) ; }

	JComboBox   methodList , solveList , decorList ;
	
	JComboBox[] CB ;
	
	void addList(int i) { panelCommand.add(CB[i]) ; }
	
	void setDefault(String s) { defIcon.maj(s) ; add(defLabel) ; }
	
	void setPanelCurve() {
		addLabel(0 , dials[0]) ; addTextField(0 , 20) ;
		addLabel(1 , dials[1]) ; addTextField(1 , 1 , dials[2]) ;
		addLabel(2 , dials[3]) ; addTextField(2 , 4) ;
		addLabel(3 , dials[4]) ; addTextField(3 , 4) ;
		addOK() ;
	}

	void setPanelPointOnCurve() {
		addLabel(0) ; 
		addTextField(0 , 8) ;
		addLabel(1) ; 	
		addOK() ;
	}

	void setPanelRecSequence() {
		addLabel(0) ; 
		addTextField(0 , 4) ;
		addLabel(1 , dials[5]) ;
		addNbField(0 , 5 , 2) ;
		addCB() ;
		addOK() ;
	}

	void setPanelGenSequence() {
		addLabel(0 , dials[6]) ; addTextField(0 , 10) ;
		addLabel(1 , new Object[]{calcul.toForm(dessin.strgen[3]) , dessin.strsymb[3]}) ; 
		addNbField(0 , 0 , 2) ;
		addLabel(2 , new Object[]{calcul.toForm(dessin.strgen[4]) , dessin.strsymb[3]}) ; 
		addTextField(1 , 2) ;
		addLabel(3 , dessin.strdom[10]) ; 
		addNbField(1 , 4 , 2) ;
		addCB() ;
		addOK() ;
	}

	void setPanelEuler() {
		addLabel(0 , dials[7]) ; addTextField(0 , 12) ;
		addLabel(1 , new Object[]{calcul.toForm(dessin.streuler[2]) , dessin.strsymb[3]}) ; 
		addTextField(1 , 2) ;
		addLabel(2 , new Object[]{calcul.toForm(dessin.streuler[3]) , dessin.strsymb[3]}) ; 
		addTextField(2 , 2) ;
		addLabel(3 , dessin.strdom[3]) ; addTextField(3 , 2) ;
		addLabel(4 , dials[8]) ; addTextField(4 , 2) ;
		addLabel(5 , dessin.strdom[10]) ; addNbField(0 , 50 , 2) ;
		addOK() ;
	}

	void setPanelDomain() {
		addLabel(0) ; 
		addTextField(0 , 4) ;
		addLabel(1 , dials[8]) ; 
		addTextField(1 , 4) ;
		addLabel(2 , dessin.strdom[10]) ; 
		addNbField(0 , 5 , 2) ;
		addCB() ;
		addList(0) ;  
		addOK() ;
	}

	void setPanelPoint() {
		addLabel(0) ; addTextField(0 , 8) ;
		addOK() ;
	}

	void setPanelLine(int t) {
		if (t == 0) {
			addLabel(0) ; 
			addTextField(0 , 10) ;
		}
		else addLabel(0) ;
		addOK() ;
		type = t ; 
	}

	void setPanelTangent(int t) {
		addLabel(0) ;
		if (t == 0) {
			addTextField(0 , 4) ;
			addLabel(1) ; 
		}
		addOK() ;
		type = t ; 
	}

	void setPanelSection() {
		int i = 0 ;
		addLabel(0) ; 
		addOK() ;
	}

	void setPanelEquation() {
		int i = 0 ;
		addLabel(0) ; addTextField(0 , 4) ;
		addLabel(1 , dials[9]) ; addTextField(1 , 2) ;
		addLabel(2 , dials[8]) ; addTextField(2 , 2) ;
		panelCommand.add(solveList) ;
		addCB() ;
		addNbField(0 , 4 , 1) ;
		addLabel(3 , dessin.strequ[4]) ; 
		addOK() ;
	}
	
	void setPanelMark() {
		addLabel(0) ; addTextField(0 , 8) ;
		addOK() ;
	}

	void setPanelText() {
		addLabel(0) ; addTextField(0 , 25) ;
		panelCommand.add(decorList) ;
		addOK() ;
	}

	void setPanel(int i , int t) {
		removeAll() ; usepane = (i > 0) ;
		if (usepane) {
			panelCommand.removeAll() ; add(panelCommand) ;
			if (status == CREATE_CURVE)  setPanelCurve() ;
			else if (i == CREATE_POINT_ON_CURVE) setPanelPointOnCurve() ;
			else if (i == CREATE_REC_SEQUENCE) setPanelRecSequence() ;
			else if (i == CREATE_GEN_SEQUENCE) setPanelGenSequence() ;
			else if (i == CREATE_EULER) setPanelEuler() ;
			else if (i == CREATE_DOMAIN) setPanelDomain() ;
			else if (i == CREATE_POINT) setPanelPoint() ;
			else if (i == CREATE_LINE) setPanelLine(t) ;
			else if (i == CREATE_TANGENT) setPanelTangent(t) ;
			else if (i == CREATE_POINT_INTER) setPanelSection() ;
			else if (i == CREATE_EQUATION) setPanelEquation() ;
			else if (i == CREATE_MARK) setPanelMark() ;
			else if (i == CREATE_TEXT) setPanelText() ;
		}
		else add(defLabel) ;
		panelCommand.revalidate() ; revalidate() ;
	}


	void changeFont(Font f) {
		defIcon.maj() ;
		for(int i = 0 ; i < I.length ; i++) I[i].maj() ;
		for(int i = 0 ; i < LB.length ; i++) LB[i].setFont(f) ;
		for(int i = 0 ; i < TF.length ; i++) TF[i].setFont(f) ;
		for(int i = 0 ; i < NF.length ; i++) NF[i].setFont(f) ;
		for(int i = 0 ; i < CB.length ; i++) { CB[i].setFont(f) ; CB[i].updateUI() ; }
		ckBox.setFont(f) ;
		validButton.setFont(f) ;
	}
	
	String[] 
		dialcreate , dialadvance , dialmethod , dialsolve , dialbutton , dials , dialdecor
	;
	
// constructeur  _____________________________________________________________________

	public dial(zone z) {
		Z = z ; 
		dialcreate = dessin.extract("dialcreate") ;
		dialadvance = dessin.extract("dialadvance") ;
		dialmethod = dessin.extract("dialmethod") ;
		dialsolve = dessin.extract("dialsolve") ;
		dialdecor = dessin.extract("dialdecor") ;
		CB = new JComboBox[] { 
			methodList = new JComboBox(dialmethod) , 
			solveList = new JComboBox(dialsolve) , 
			decorList = new JComboBox(dialdecor)
		} ;
		methodList.setPrototypeDisplayValue(dialmethod[3]) ;
		solveList.setPrototypeDisplayValue(dialsolve[0]) ;
		methodList.addActionListener(comboListener) ;
		solveList.addActionListener(comboListener) ;
		decorList.addActionListener(comboListener) ;
		
		dialbutton = dessin.extract("dialbutton") ;
		ckBox = new JCheckBox(dialbutton[0]) ; 
		ckBox.addItemListener(checkListener) ;
		validButton = new JButton(dialbutton[1]) ; 
		validButton.addActionListener(buttonListener) ;

		dials = dessin.extract("dials") ;
		
		setFloatable(false) ;
		panelCommand.setLayout(new FlowLayout(FlowLayout.LEFT)) ;
		int d = validButton.getPreferredSize().height ;
		validButton.setSize(new Dimension (5*d/4 , d)) ;
		
		defLabel.setIcon(defIcon) ;
		for(int i = 0 ; i < LB.length ; i++) LB[i].setIcon(I[i]) ;
		for(int i = 0 ; i < TF.length ; i++) {
			TF[i].addActionListener(fieldListener) ;
			TF[i].setHorizontalAlignment(JTextField.LEFT) ;
		}
		for(int i = 0 ; i < NF.length ; i++) NF[i].addActionListener(formListener) ;
		
		changeFont(dessin.FONT_PLAIN) ;
		
	}
	
// classe interne
	class icon implements Icon {
	
		Vector V = new Vector() ;
		box B = new box() ;
		Color col = Color.black ;
	
		public icon() { }
	
		public int getIconHeight() { return (int)Math.rint(B.d + B.a) ; }

		public int getIconWidth() { return (int)Math.rint(B.w) ; }
	
		public void paintIcon(Component c, Graphics gg, int x, int y) {
			Graphics2D g = (Graphics2D)gg ;
			T.setToTranslation(x , y) ;
			g.setColor(c.getBackground()) ; g.fill(new Rectangle(x , y , getIconWidth() , getIconHeight())) ;
			T.setToTranslation(x , B.a + y) ;
			g.setColor(col) ; g.fill(B.G.createTransformedShape(T));
		}
		
		void reset() { V.clear() ; B.a = B.d = B.w = 0f ; B.G.reset() ; }
	
		void maj() { 
			B.a = B.d = B.w = 0f ; B.G.reset() ; Object o ;
			for (int i = 0 ; i < V.size() ; i++) {
				o = V.elementAt(i) ;
				if (o == null) continue ;
				else if (o instanceof String) B.append(new box((String)o , false)) ;
				else if (o instanceof form) B.append(((form)o).toBox()) ;
			}
		}

		void add(String s) { V.add(s) ; B.append(new box(s , false)) ; }
		
		void add(form f) { V.add(f) ; B.append(f.toBox()) ; }
	
		void add(Object[] O) {
			Object o ;
			for (int i = 0 ; i < O.length ; i++) {
				o = O[i] ;
				if (o == null) continue ;
				else if (o instanceof String) add((String)o) ;
				else if (o instanceof form) add((form)o) ;
				else if (o instanceof Object[]) add((Object[])o) ;
			}
		}
	
		void maj(String s) { reset() ; add(s) ; }
		
		void maj(form f) { reset() ; add(f) ; }
	
		void maj(Object[] O) { reset() ; add(O) ; }
		
	}

}

