//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.* ;
import java.awt.geom.* ;
import java.util.* ;

public class courbe extends line {

/*_______________________________________ VARIABLES ________________________________________*/

	form d ;
	String sv = "" ; 
	double  a = Double.NaN , 
			b = Double.NaN ;
	boolean hasint , skip ;
	GeneralPath P = new GeneralPath() ;
	
/*______________________________________ CONSTRUCTION ______________________________________*/

	public courbe() { super() ; S = P ; }
	
	public courbe(form en , String v , double x1 , double x2) { 
		this() ;
		a = x1 ;
		b = x2 ; 
		col = CURVE_COLOR ; 
		maj(en , v) ; 
	}

/*________________________________________ MÉTHODES ________________________________________*/

// 1. MISE À JOUR __________________________________________________________________________

	void maj(form en , String v) {
		cid = en.toString() ; form f ;
		if ((en.op != null) && (en.op.nom.equals("="))) {
			f = en.F.first() ; en = en.F.next() ;
		}
		else f = en ;
		id = f.toString() ; 
		e = en.eval() ;
		sv = v.trim() ; 
		isDef = ((e != null) && (sv.length() > 0)) ;
		if (!isDef) return ;
		d = e.toDer(sv).eval() ;
		hasint = e.hasInt() ;
		
		recalc() ;
	}
	
	void recalc() { 
		calcShape() ; 
		refresh() ; 
	}

	void calcShape() { 
		P.reset() ; if (!isDef) return ;
		float x1 = (float)Math.min(XG , XD) , x2 = (float)Math.max(XG , XD) ;
		if (def(a)) x1 = (float)Math.max(x1 , a) ;
		if (def(b)) x2 = (float)Math.min(x2 , b) ;
		Point2D.Float n = e.toPoint(sv , x1) , m = new Point2D.Float(n.x , n.y) , i = new Point2D.Float() ;
		float pas = (float) (abs(2) - abs(0)) ;
		skip = true ; addPoint(n.x , n.y) ;
		while (m.x < x2) {
			m.setLocation(n) ;
			n.x = m.x + pas ; if (n.x > x2) n.x = x2 ; 
			n.y = (float)e.toDouble(sv , n.x) ;
			if (def(m.y) && def(n.y)) {
				if (!refuse(m , n)) addPoint(n.x , n.y) ;
				else {
					i = e.toPoint(sv , (m.x + n.x)/2) ;
					if (def(m.y) && !refuse(m , i)) {
						addPoint(i.x , i.y) ; skip = true ; 
					}
					else if (def(n.y) && !refuse(n , i)) {
						skip = true ; addPoint(i.x , i.y) ; addPoint(n.x , n.y) ;
					}
					else skip = true ;
				}
			}
			else skip = true ;
		}
	}
	
	boolean refuse(Point2D.Float m , Point2D.Float n) {
		double de = (m.x < n.x) ? computeRightDerivative(m.x) : computeLeftDerivative(m.x) ; 
		boolean b ;
		if (hasint) b = (Double.isNaN(de)) ? true : (Math.abs(ordE(m.y + de * (n.x - m.x)) - ordE(n.y)) > 2) ;
		else b =  (Double.isNaN(de)) ? true :
			((m.x < n.x) && (((de >= 0) && (m.y > n.y)) || ((de <= 0) && (m.y < n.y)))) ? (Math.abs(ordE(m.y) - ordE(n.y)) > 2) :
			((m.x > n.x) && (((de >= 0) && (m.y < n.y)) || ((de <= 0) && (m.y > n.y)))) ? (Math.abs(ordE(m.y) - ordE(n.y)) > 2) :
			false ;
		return b ;
	}
	
	void addPoint(float x , float y) {
		if (skip) P.moveTo(x , y) ; else P.lineTo(x , y) ;
		skip = false ;
	}
	
// calcul d'un chemin

	void addPoint(float x , float y , GeneralPath R) {
		if (skip) R.moveTo(x , y) ; else R.lineTo(x , y) ;
		skip = false ;
	}
	
	void putPath(domaine D , float x1 , float x2) {
		GeneralPath R = D.P ; putInterval(R , x1 , x2) ; if (!D.isDef) return ;
		float pas = (float) (abs(1) - abs(0)) ;
		Point2D.Float n = new Point2D.Float(x1 , (float)computeValue(x1)) ;
		while (n.x <= x2) {
			if (!def(n.y)) {
				D.isDef = false ; D.hasResult = false ; putInterval(R , x1 , x2) ; return ;
			}
			else {
				if ((n.y < YB) || (n.y > YH)) D.hasResult = false ;
				R.lineTo(n.x , n.y) ;
			}
			if (n.x == x2) break ;
			n.x += pas ; if (n.x > x2) n.x = x2 ; 
			n.y = (float)computeValue(n.x) ;
		}
		R.closePath() ;
	}

	void putInterval(GeneralPath R , float x1 , float x2) {
		R.reset() ; R.moveTo(x2 , 0f) ; R.lineTo(x1 , 0f) ;
	}

	
// 2. PROXIMITÉ ET TRACÉ ___________________________________________________________________
	
	boolean proche() { 
		if (!isDef) return false ;
		double nx = abs(MOUSE.x) ;
		if ((def(a) && (nx < a)) || (def(b) && (nx > b))) return false ;
		return (Math.abs(ordE(e.toDouble(sv , nx)) - MOUSE.y) < TOLERANCE) ; 
	
	}
	
	boolean proche(Point2D.Float p) {
		Point2D.Float q = e.toPoint(sv , p.x) ;
		return isNear(p , q) ;
	}
		
// 3. AIDE CONTEXTUELLE ____________________________________________________________________

	String getDefaultTTT() { return strcurve[0] ; }

//  5. LOCALISATION ________________________________________________________________________

	Point2D.Float defaultLocation() {
		float xl = (float)abs(MOUSE_START.x) , yl = (float)e.toDouble(sv , xl) ;
		if (ZONE_PATH.contains(xl , yl)) return  new Point2D.Float(xl , yl) ;
		else return  new Point2D.Float(xl , (float)ord(MOUSE_START.y)) ;
	}

	void locate(pointsurcourbe ps) {
		locate(ps.p) ;
	}
	
	void locate(Point2D.Float pf) {
		if (def(a) && (pf.x < a)) pf.x = (float)a ;
		if (def(b) && (pf.x > b)) pf.x = (float)b ;
		pf.y = (float)computeValue(pf.x) ; 
	}

//  6. ENREGISTREMENT ______________________________________________________________________

	String getCommand() { 
		StringBuffer sb = new StringBuffer("courbe(") ; sb.append(cid) ;
		sb.append(',') ; sb.append(sv) ;
		sb.append(',') ; sb.append(a) ;
		sb.append(',') ; sb.append(b) ;
		sb.append(getNameColorCommand()) ;
		sb.append(')') ;
		return new String(sb) ;
	}

//  7. DIALOGUES ____________________________________________________________________________
	
	int getStatus() { return CREATE_CURVE ; }
	
	String getId() {
		if (hasName()) return name ;
		else return strcurve[1] + cid ;
	}

	void writeDatas() {
		D.TF[0].setText(cid) ; 
		D.TF[1].setText(sv) ;
		D.TF[2].setText(def(a) ? form(a) : "") ;
		D.TF[3].setText(def(b) ? form(b) : "") ;
	}
	
	void readDatas() {
		form f = null ;
		if (!cid.equals(D.TF[0].getText())) f = calcul.toForm(D.TF[0].getText()) ;
		boolean change = (f != null) , changeb = false ; if (change) e = f ;
		String s = D.TF[1].getText().trim() ;
		if (!sv.equals(s) && (s.length() > 0)) { sv = s ; change = true ; }
		double  x1 = getValue(D.TF[2].getText()) ,
				x2 = getValue(D.TF[3].getText()) ;
		if (def(x1) && def(x2) && (x1 > x2)) { a = b = Double.NaN ; changeb = true ; }
		else if ((x1 != a) || (x2 != b)) { a = x1 ; b = x2 ; changeb = true ; }
		if (change) maj(e , sv)  ; else if (changeb) recalc() ;
	}
	
//  9. CALCULS _____________________________________________________________________________

	double computeValue(double xd) { 
		double y =  e.toDouble(sv , xd) ; if (def(y)) return y ;
		if (xd == a) return e.computeLimit(sv , new vois(new nbre(xd) , posi.pSupS)).L.val ;
		else if (xd == b) return e.computeLimit(sv , new vois(new nbre(xd) , posi.pInfS)).L.val ;
		else return e.computeLimit(sv , new vois(new nbre(xd) , posi.pDiff)).L.val ;
	}
	
	double computeDerivative(double xd) { 
		double y =  d.toDouble(sv , xd) ; if (def(y)) return y ;
		if (xd == a) return d.computeLimit(sv , new vois(new nbre(xd) , posi.pSupS)).L.val ;	
		else if (xd == b) return d.computeLimit(sv , new vois(new nbre(xd) , posi.pInfS)).L.val ;	 
		else return d.computeLimit(sv , new vois(new nbre(xd) , posi.pDiff)).L.val ;
	}
	
	double computeLeftDerivative(double xd) {
		double de = d.toDouble(sv , xd) ; if (def(de)) return de ;
		return d.computeLimit(sv , new vois(new nbre(xd) , posi.pInfS)).L.val ;		
	}
	
	double computeRightDerivative(double xd) {
		double de = d.toDouble(sv , xd) ; if (def(de)) return de ;
		return d.computeLimit(sv , new vois(new nbre(xd) , posi.pSupS)).L.val ;		
	}

//  10. INTERSECTION _______________________________________________________________________
	
	Vector getInterWith(line l) {
		if (l instanceof droite) return ((droite)l).getInterWith(this) ;
		else if (l instanceof tangente) return ((tangente)l).getInterWith(this) ;
		else if (l instanceof courbe) {
			courbe C = (courbe)l ;
			if (sv.equals(C.sv)) {
				float u = (float) (def(C.a) ? C.a : XG) ; if (def(a) && (u < a)) u = (float) a ;
				float v = (float) (def(C.b) ? C.b : XD) ; if (def(b) && (v > b)) v = (float) b ;
				return getDiffWith(C , u , v) ;
			}
		}
		return new Vector() ;
	}

}

