//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.util.Stack ;
import java.util.StringTokenizer ;
import java.util.Vector ;

public class calcul {

/*__________________________________ VARIABLES STATIQUES ___________________________________*/

/**
Opérateurs : "();<=>+*-/^_" ou "(),<=>+*-/^_".<br>
Le séparateur est dessin.ISEP.
*/
	public static final String Oprs = "()" + dessin.ISEP + "<=>+*-/^_" ;
	
/**
Priorité des fonctions.
*/
	public static final int pri = Oprs.length() ;
	
/**
Priorité des opérateurs unaires.
*/
	public static final int pru = Oprs.lastIndexOf('-') ;
	
/**
Pile des opérandes.
*/
	public static final Stack Opn = new Stack() ;
	
/**
Pile des opéranteurs.
*/
	public static final Stack Opr = new Stack() ;
	
    static int nn , nr , poids ;
                        
/**
Tableau des noms des fonctions connues.
*/
    public static final String[] FONCTIONS_CONNUES = {
        "abs" , "rac" , "sin" , "cos" , "tan" , 
		"asin" , "acos" , "atan" , "ln" , "log" , 
		"exp" , "ent" , "dabs" , "dent" , "pth" , 
		"cro" , "bra" , "sqrt"
    } ;

/**
Un réel positif et proche de 0.
*/
	public static final double eps = 1E-15 ;

/**
Un réel non défini.
*/
    public static final double ndef = Double.NaN ;

/**
Un réel représentant +∞.
*/
    public static final double pinf = Double.POSITIVE_INFINITY ;

/**
Un réel représentant -∞.
*/
    public static final double minf = Double.NEGATIVE_INFINITY ;
	
/**
Entier indiquant qu'aucune évaluation n'est effectuée.
*/
	public static final int NO_EVAL = 0 ;

/**
Entier indiquant que seules les simplifications de signes sont effectuées.
*/
	public static final int EVAL_SIGNS = 1 ;
	
/**
Entier indiquant que les calculs sont effectués lorsque le résultat est un nombre.
*/
	public static final int EVAL_NBRES = 2 ;

/**
Entier indiquant que les calculs sont effectués lorsque le résultat est un monôme.
*/
	public static final int EVAL_MONOS = 3 ;

/**
Entier indiquant que les calculs sont effectués lorsque le résultat est un polynôme.
*/
	public static final int EVAL_POLYS = 4 ;
	
/**
Opérateur réalisant des sommes.
*/
	public static final op_somme SUM = new op_somme(0) ;
	
/**
Opérateur réalisant des produits.
*/
	public static final op_produit PROD = new op_produit(0) ;

/**
Opérateur réalisant des produits.
*/
	public static final op_quotient QUOT = new op_quotient() ;

/*__________________________________ MÉTHODES STATIQUES ____________________________________*/

// 1. CRÉATION DE LA STRUCTURE _____________________________________________________________

/**
Renvoie une formule à partir d'une chaîne de caractères.<br>
L'évaluation de la chaîne utilise les piles <i>Opn</i> et <i>Opr</i> de cette classe.
@param entree la chaîne qui doit être interprétée
*/
    public static form toForm (String entree) {
		try {
			StringTokenizer en = new StringTokenizer(entree.trim() , Oprs , true) ;
			if (en.countTokens() == 0) return null ;
			String tok , mot = "" ;
			char car ;
			int  pr ; 
			poids = 0 ; 
			Opn.clear() ; 
			Opr.clear() ;
			while(en.hasMoreTokens()) {
				tok = en.nextToken().trim() ; if (tok.length() == 0) continue ;
				pr = Oprs.indexOf(tok) ;
				if (pr < 0) mot = new String(tok) ;
				else {
					car = tok.charAt(0) ;
					if (mot.length() > 0) {
						if (car == '(') empO(mot , pri) ; else empR(mot) ;
						mot = "" ;
					} ;
					if (car == '(') empO("(" , pr) ;
					else if ((car == ')') || (car == dessin.ISEP)) {
						while (!testP(Oprs.indexOf('('))) depSom() ;
						((oper)Opr.peek()).poids += poids ; poids = 0 ;
						if (car == ')') {
							if (!Opr.isEmpty()) poids += ((oper)Opr.pop()).poids ;
							if ((!Opr.isEmpty()) && (((oper)Opr.peek()).prior == pri)) depSom() ;
						}
					}
					else if ((car == '+') || (car == '*')) empA("" + car) ;
					else if ((car == '-') || (car == '/')) {
						if (poids > 0) { if (car == '-') empA("+") ; else empA("*") ; }
						while (!testP(pru)) depSom() ; empO("" + car , pru) ;
					}
					else { while (!testP(pr - 1)) depSom() ; empO("" + car , pr) ; }
				}
			}
			if (mot.length() > 0) empR(mot) ;
			while (!Opr.isEmpty())  depSom() ;
			form f = (form)Opn.pop() ;
			if(Opn.size() == 0) return f ; else return null ;
		}
		catch (Exception ex) { System.err.println(ex) ; return null ; }
    }
    
/**
Empile un résultat dans la pile <i>Opn</i> des opérandes.<br>
Le résultat est un <i>nombre</i> ou un <i>monôme</i>.
@param s la chaîne qui décrit le résultat empilé
*/
	static void empR(String s) { 
		double d = valD(s) ;
		if (Double.isNaN(d)) {
			if (s.equals("ndef")) Opn.push(new nbre(d)) ;
			else Opn.push(new mono(s)) ;
		}
		else Opn.push(new nbre(d)) ;
		poids ++ ;
	}

/**
Empile un opérateur dans la pile <i>Opr</i>.<br>
@param c le nom de l'opérateur
@param p la priorité de l'opérateur
*/
	static void empO(String c , int p) {
		char s = c.charAt(0) ;
		if (s == '+') Opr.push(new op_somme(poids)) ;
		else if (s == '*') Opr.push(new op_produit(poids)) ;
		else if (s == '-') Opr.push(new op_oppose(poids)) ;
		else if (s == '/') Opr.push(new op_inverse(poids)) ;
		else if (s == '^') Opr.push(new op_puissance(poids)) ;
		else if (s == '_') Opr.push(new op_indice(poids)) ;
		else if (p < pri) Opr.push(new oper(c , p , poids)) ;
		else Opr.push(new op_fonction(c , poids)) ;
		poids = 0 ;
	}

/**
Empile un opérateur associatif dans la pile <i>Opr</i>.<br>
Si l'opérateur qui est au sommet de la pile <i>Opr</i> a le même priorité que
celle de l'opérateur défini par la chaîne donnée en argument, son poids est augmenté du poids courant.
Dans le cas contraire, on applique les règles ordinaires.
@param s le nom de l'opérateur
*/
	static void empA(String s) {
		int p = Oprs.indexOf(s) ;
		while (!testP(p)) depSom() ;
		if ((!Opr.isEmpty()) && (((oper)Opr.peek()).prior == p)) { 
			((oper)Opr.peek()).poids += poids ; 
			poids = 0 ;
		}
		else empO(s , p) ;
    }
    
/**
Vérifie s'il est possible d'empiler dans la pile <i>Opr</i>.<br>
L'empilement est possible si et seulement si la priorité du sommet de la pile <i>Opr</i> 
est strictement inférieure à celle qui est donnée en argument.
@param m la priorité testée
*/
    static boolean testP(int m) { 
		if (Opr.isEmpty()) return true ; 
		else return (((oper)Opr.peek()).prior <= m) ; 
	}

/**
Crée une formule.<br>
L'opérateur est le sommet dela pile <i>Opr</i>. Son poids détermine le nombre d'arguments
dépilés de la pile <i>Opn</i>. Le résultat est empilé dans la pile <i>Opn</i>. 
*/
    static void depSom() {
		oper op = (oper)Opr.pop() ; 
		op.poids += poids ;
        Opn.push(new form(op)) ; 
		poids = 1 ;
    }

// 2. CRÉATION DE FORMULES _________________________________________________________________

/**
Renvoie une formule à partir d'un nom et d'une liste d'arguments.
@param s le nom de l'opérateur
@param A la liste des fils
*/
	static form nform(String s , liste A) {
		if (s.equals("+")) return nsom(A) ;
		else if (s.equals("*")) return npro(A) ;
		else if (s.equals("-")) return nopp(A.first()) ;
		else if (s.equals("/")) return ninv(A.first()) ;
		else if (s.equals("^")) return npow(A.first() , A.next()) ;
		else if (s.equals("_")) return nind(A.first() , A.next()) ;
		else return nftn(s , A) ; 
	}
	
/**
Renvoie une formule à partir d'un nom et de deux arguments.
@param s le nom de l'opérateur
@param a la première formule argument
@param b la deuxième formule argument
*/
	static form nform(String s , form a , form b) {return new form(new oper(s , 2) , new liste(a , b)) ; }
	
/**
Renvoie une somme à partir d'une liste d'arguments.
@param A la liste des fils
*/
	static form nsom(liste A) { return new form(new op_somme(A.length()) , A) ; }
	
/**
Renvoie une somme à partir de deux arguments.
@param a la première formule
@param b la deuxième formule
*/
	static form nsom(form a , form b) { return new form(new op_somme(2) , new liste(a , b)) ; }
	
/**
Renvoie une différence à partir de deux arguments.
@param a la première formule
@param b la deuxième formule
*/
	static form ndif(form a , form b) { return new form(new op_somme(2) , new liste(a , nopp(b))) ; }
	
/**
Renvoie un produit à partir d'une liste d'arguments.
@param A la liste des fils
*/
	static form npro(liste A) { return new form(new op_produit(A.length()) , A) ; }
	
/**
Renvoie un produit à partir de deux arguments.
@param a la première formule
@param b la deuxième formule
*/
	static form npro(form a , form b) { return new form(new op_produit(2) , new liste(a , b)) ; }
	
/**
Renvoie un quotient à partir de deux arguments.
@param a le première formule
@param b la deuxième formule
*/
	static form nquo(form a , form b) { return new form(new op_quotient() , new liste(a , b)) ; }
	
/**
Renvoie l'opposé d'une formule.
@param a une formule
*/
	static form nopp(form a) { return new form(new op_oppose(1) , new liste(a)) ; }
	
/**
Renvoie l'inverse d'une formule.
@param a une formule
*/
	static form ninv(form a) { return new form(new op_inverse(1) , new liste(a)) ; }
	
/**
Renvoie une puissance à partir de deux arguments.
@param a la première formule
@param b la deuxième formule
*/
	static form npow(form a , form b) { return new form(new op_puissance(2) , new liste(a , b)) ; }
	
/**
Renvoie une puissance à partir de deux arguments et d'un booléen indiquant si le résultat doit être développé.
@param a la première formule
@param b la deuxième formule
@param e le booléen qui détermine l'expansion
*/
	static form npow(form a , form b , boolean e) { 
		op_puissance o = new op_puissance(2) ; o.expandable = e ;
		return new form(o , new liste(a , b)) ; 
	}
	
/**
Renvoie un indice à partir de deux arguments.
@param a la première formule
@param b la deuxième formule
*/
	static form nind(form a , form b) { return new form(new op_indice(2) , new liste(a , b)) ; }
	
/**
Renvoie une fonction à partir d'un nom et d'un argument.
@param s le nom de la fonction
@param a l'argument de la fonction
*/
	static form nftn(String s , form a) { return new form(new op_fonction(s , 1) , new liste(a)) ; }
	
/**
Renvoie une fonction à partir d'un nom et d'une liste d'arguments.
@param s le nom de la fonction
@param A la liste des arguments de la fonction
*/
	static form nftn(String s , liste A) { return new form(new op_fonction(s , A.length()) , A) ; }
	
/**
Renvoie une fonction à partir d'un nom , d'un argument et d'un booléen.
@param s le nom de la fonction
@param a l'argument de la fonction
@param b indique si l'évaluation doit être numérique 
*/
	static form nftn(String s , form a , boolean b) {
		op_fonction o = new op_fonction(s , 1) ; o.evalNbre = b ;
		return new form(o , new liste(a)) ; 
	}
	
// 3. INTERPRÉTATION DE DONNÉES ____________________________________________________________

/**
Renvoie l'indice d'une chaîne dans un tableau.
@param s la chaîne qui est recherchée
@param S le tableau dans lequel la recherche est faite
*/
    public static int indice(String s , String[] S) {
        for(int i = 0 ; i < S.length ; i++) { if (s.equals(S[i])) return i ; }
        return -1 ;
    }
	
/**
Interprète une chaîne de caratère comme un <i>double</i>.
@param r la chaîne qui est interprétée
*/
    public static double valD(String r) {
        if (r.equals("Pi") || r.equals("PI") || r.equals("pi") || r.equals("\u03C0")) return Math.PI ;
        else if (r.equals("E") || r.equals("e")) return Math.E ;
        else if (r.equals("∞") || r.equals("+∞") || r.equals("Infinity") || r.equals("infinity") || r.equals("Inf") || r.equals("inf")) return Double.POSITIVE_INFINITY ;
        else if (r.equals("-∞") || r.equals("-Infinity") || r.equals("-infinity") || r.equals("-Inf") || r.equals("-inf")) return Double.POSITIVE_INFINITY ;
        else return dessin.dblv(r) ;
    }

/**
Interprète une chaîne de caratère comme un <i>float</i>.
@param r la chaîne qui est interprétée
*/
    public static float valF(String r) {
        if (r.equals("Pi") || r.equals("PI") || r.equals("pi") || r.equals("\u03C0")) return (float)Math.PI ;
        else if (r.equals("E") || r.equals("e")) return (float)Math.E ;
        else if (r.equals("∞") || r.equals("+∞") || r.equals("Infinity") || r.equals("infinity") || r.equals("Inf") || r.equals("inf")) return Float.POSITIVE_INFINITY ;
        else if (r.equals("-∞") || r.equals("-Infinity") || r.equals("-infinity") || r.equals("-Inf") || r.equals("-inf")) return Float.NEGATIVE_INFINITY ;
        else return dessin.fltv(r) ;
    }

// 4. CALCULS NUMÉRIQUES ___________________________________________________________________

/**
Arrondit une valeur numérique à la précision <i>eps</i>.
@param x la valeur arrondie
*/
	public static double arr(double x) { return eps * Math.rint(x/eps) ; }
	
/**
Arrondit une valeur numérique à une précision donnée.
@param x la valeur arrondie
@param y la précision
*/
	public static boolean env(double x , double y) { return (Math.abs(x - y) < eps) ; }

/**
Détermine un PGCD par l'algorithme d'Euclide.
@param aa le premier argument
@param bb le second argument
*/
    public static double pgcd(double aa , double bb) {
        double a = Math.floor(Math.abs(aa))  , b = Math.floor(Math.abs(bb)) , c ; 
        if ((a == 1) || (b == 1)) return 1 ;
        while (b != 0) { c = a%b ; a = b ; b = c ; }
        return a ;
     }
	 
// 5. POLYNÔMES ___________________________________________________________________________

// méthodes utilisées par op_somme

/**
Renvoie la somme d'une liste de termes.
@param R une liste de termes
*/
	static form resultForSum(liste R) {
		int l = R.length() ; 
		if (l == 0) return new nbre(0) ; else if (l == 1) return R.first() ; else return nsom(R) ;
	}
	
/**
Renvoie la somme d'une liste de termes et d'un nombre.
@param R une liste de termes
@param n un nombre
*/
	static form resultForSum(liste R , nbre n) {
		if ((n == null) || (n.val == 0)) return resultForSum(R) ;
		if ((R.length() == 0) || Double.isNaN(n.val)) return n ; 
		form r ; R.top() ; while(R.hasPrev()) {
			r = R.prev() ;
			if (r instanceof poly) { ((poly)r).Padd(n) ; n.maj(0) ; break ; }
		}
		if (n.val != 0) R.add(n) ;
		return resultForSum(R) ;
	}
	
/**
Renvoie la somme d'une liste de formules et d'un nombre calcul des sommes de nombres , de monômes et de polynômes.
@param E une liste de termes
@param c un nombre
*/
	static form resultForSumPolys(liste E , nbre c) {
		liste L = new liste() , R = new liste() ; form a ; poly P , p ; nbre n = c ;
		E.bot() ; while(E.hasNext()) {
			a = E.next() ; 
			if (a instanceof mono) { L.add(new poly((mono)a)) ; E.remA() ; }
			else if (a instanceof poly) { 
				p = (poly) a ;
				if (p.hasCoeff(0)) { 
					if (n != null) n.Nadd(p.getCoeff(0)) ; else n = new nbre(p.getCoeff(0)) ;
					p.setCoeff(new nbre(0) , 0) ; 
				}
				L.add(p) ; E.remA() ;
			}
		}
		while(L.length() > 0) {
			P = new poly((poly)L.last()) ; L.rem(L.deg()) ;
			L.bot() ; while(L.hasNext()) {
				p = (poly) L.next() ;
				if (p.base.equals(P.base)) { P.Padd(p) ; L.remA() ; }
			}
			if (P.estNbre()) { 
				if (n != null) n.Nadd(P.getNbre()) ; else n = new nbre(P.getNbre()) ;
			}
			else R.ins(P , 0) ;
		}
		R.V.addAll(E.V) ;
		return resultForSum(R , n) ;
	}


// méthodes utilisées par op_produit et op_quotient

/**
Insère un nombre au début d'une liste de facteurs d'un produit.
@param n un nombre
@param E une liste de facteurs
*/
	static void insere(nbre n , liste E) {
		if (n != null) {
			if (n.val != 1) { 
				form r ; E.bot() ; while(E.hasNext()) {
					r = E.next() ;
					if (r instanceof mono) { 
						mono m = (mono)r ; m.Mmult(n) ; E.setA(m) ; n.maj(1) ; break ; 
					}
				}
			}
			if (n.val != 1) E.ins(n , 0) ;
		}
	}
	
/**
Détermine l'indice d'une somme dans une liste de facteurs d'un produit.
@param R une liste de facteurs
*/
	static int sumExists(liste R) {
		for (int i = 0 ; i < R.length() ; i ++) { if (R.get(i).operIsSum()) return i ; }
		return -1 ;
	}
	
/**
Distribue les produits sur les sommes dans une liste de facteurs d'un produit.
@param R une liste de facteurs
*/
	static liste expandAllProducts(liste R) {
		int i = sumExists(R) ; if (i < 0) return new liste(npro(R)) ;
		form a , r ;
		liste P , S = new liste() ; 
		a = R.get(i) ;
		for (int j = 0 ; j < a.F.length() ; j ++) {
			P = R.copie() ; P.set(a.F.get(j) , i) ; S.add(expandAllProducts(P)) ;
		}
		return S ;
	}

/**
Distribue les produits sur les sommes dans une liste signée de facteurs d'un produit et simplifie les sommes.
@param sgn un entier représentant un signe 
@param R une liste de facteurs
*/
	static form expandProducts(int sgn , liste R) {
		form a , r ;
		R.bot() ; while(R.hasNext()) {
			a = R.next() ; if (a instanceof poly) R.setA(((poly) a).getForm()) ;
		}
		liste S = expandAllProducts(R) ;
		S.bot() ; while(S.hasNext()) { 
			a = S.next() ;
			if (a.operIsProd()) a = PROD.eval(a.F) ;
			if (sgn < 0) a = a.Gopp() ;
			S.setA(a) ; 
		}
		return SUM.eval(S) ;
	}
	
/**
Renvoie le produit d'une liste de facteurs.
@param R une liste de facteurs
*/
	static form resultForProduct(liste R) {
		int l = R.length() ; 
		if (l == 0) return new nbre(1) ; else if (l == 1) return R.first() ; else return npro(R) ;
	}
	
/**
Renvoie le produit d'un signe et d'une liste de facteurs.
@param sgn un entier représentant un signe
@param R une liste de facteurs
*/
	static form resultForProduct(int sgn , liste R) {
		form r = resultForProduct(R) ; if (sgn < 0) r = r.Gopp() ; return r ; 
	}
	
/**
Renvoie le produit d'un signe , d'un nombre et d'une liste de facteurs.
@param sgn un entier représentant un signe
@param n un nombre
@param R une liste de facteurs
*/
	static form resultForProduct(int sgn , nbre n , liste R) {
		insere(n , R) ; return resultForProduct(sgn , R) ;
	}
	
/**
Renvoie le produit d'un nombre et d'une liste de facteurs.
@param n un nombre
@param R une liste de facteurs
*/
	static form resultForProduct(nbre n , liste R) {
		if ((n == null) || (n.val == 1)) return resultForProduct(R) ;
		else if (n.val == -1) return resultForProduct(-1 , R) ;
		else { insere(n , R) ; return resultForProduct(R) ; }
	}
	

/**
Renvoie le quotient de deux formules.
@param s un booléen qui détermine si le résultat peut être mis sous forme d'un produit
@param a le numérateur
@param b le dénominateur
*/
	static form resultForQuotient(boolean s , form a , form b) {
		if ( s && (a instanceof nbre || a instanceof mono || b instanceof nbre || b instanceof mono)) return npro(a , b.Ginv()) ;
		return nquo(a , b) ;
	}
	
/**
Renvoie le quotient de deux listes de facteurs.
@param s un booléen qui détermine si le résultat peut être mis sous forme d'un produit
@param N la liste des facteurs du numérateur
@param D la liste des facteurs du dénominateur
*/
	static form resultForQuotient(boolean s , liste N , liste D) {
		form a , b ; 
		switch(N.length()) {
			case 0 : a = new nbre(1) ; break ;
			case 1 : a = N.first() ; break ;
			default : a = npro(N) ;
		}
		if (D.length() == 0) return a ;
		switch(D.length()) {
			case 0 : b = a ; break ;
			case 1 : b = D.first() ; break ;
			default : b = npro(D) ;
		}
		if (N.length() == 0) return b.Ginv() ;
		return resultForQuotient(s , a , b) ;
	}

/**
Renvoie le quotient d'un signe de deux listes de facteurs.
@param s un booléen qui détermine si le résultat peut être mis sous forme d'un produit
@param sgn un entier représentant un signe
@param N la liste des facteurs du numérateur
@param D la liste des facteurs du dénominateur
*/
	static form resultForQuotient(boolean s , int sgn , liste N , liste D) {
		form r = resultForQuotient(s , N , D) ; if (sgn > 0) return r ; else return r.Gopp() ;
	}
	
}
