//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.Color ;
import java.awt.Font ;
import java.awt.font.GlyphVector ;
import java.awt.font.LineMetrics ;
import java.util.Stack ;
import java.util.EmptyStackException ;
import java.util.Vector ;
import java.util.StringTokenizer ;
import java.awt.geom.Point2D ;
import java.awt.geom.Rectangle2D ;
import java.awt.geom.GeneralPath ;
import java.awt.geom.AffineTransform ;

/**
EXPRESSIONS MATHÉMATIQUES. Cette classe permet de créer et de dessiner des formules mathématiques.<br>
Une formule occupe un rectangle traversé par une ligne de base. Les paramètres principaux sont
<ul>
   <li> la distance entre la ligne de base et le haut du rectangle : <i>a</i> (ascent)
   <li> la distance entre la ligne de base et le bas du rectangle : <i>d</i> (descent)
   <li> la largeur du rectangle : <i>w</i> (width)
   <li> l'abscisse du point du rectangle situé en haut et à gauche : <i>x</i>
   <li> l'ordonnée du point du rectangle situé en haut et à gauche : <i>x</i>
</ul>
La fonte utilisée est celle de la classe <i>dessin</i>.
*/

public class box extends dessin {

/*__________________________________ VARIABLES STATIQUES ___________________________________*/

/**
* Transformation utilisée pour modifier le dessin d'une formule.
*/
    static AffineTransform at = new AffineTransform() ;

/**
* Pile contenant les fontes utilisées.
*/
	static Stack stackFont = new Stack() ;

/**
* Pile contenant la taille des fontes utilisées.
*/
	static Stack stackSize = new Stack() ;
	
/**
* Largeur du trait dans la fonte courante.
*/
	static float lt ;


/*_______________________________________ VARIABLES ________________________________________*/

/**
* Chemin utilisé pour dessiner la formule.
*/
    GeneralPath G = new GeneralPath() ;
	
/**
* Ascent.
*/
	float a = 0f ;
/**
* Descent.
*/
	float d = 0f ;

/**
* Width.
*/
	float w = 0f ;

/**
* Abscisse du point du rectangle situé en haut et à gauche.
*/
	float x = 0f ;

/**
* Ordonnée du point du rectangle situé en haut et à gauche.
*/
	float y = 0f ;
/**
* Couleur par défaut.
*/
    Color col = Color.black ;

/*______________________________________ CONSTRUCTION ______________________________________*/

    public box() { }
	
    public box(String s , Font cf) { 
		create(s , cf) ; 
	}
	
    public box(String s) { 
		if (Double.isNaN(dblv(s))) create(s , FONT_ITALIC) ; else create(s , FONT_PLAIN) ; 
	}
	
	public box(String s , boolean b) { 
	if (b && Double.isNaN(dblv(s))) create(s , FONT_ITALIC) ; else create(s , FONT_PLAIN) ;
	}	

/*________________________________________ MÉTHODES ________________________________________*/

// 1. CRÉATION , COPIE & DIMENSIONS ________________________________________________________

	void create (String s , Font cf) {
        GlyphVector GV = cf.createGlyphVector(FRC , s) ; 
		LineMetrics L = cf.getLineMetrics(s , FRC) ; 
        G = (GeneralPath)GV.getOutline() ; 
		a = L.getAscent() ; d = L.getDescent() ;
		Rectangle2D.Float R = (Rectangle2D.Float)GV.getLogicalBounds().createUnion(G.getBounds2D()) ;
		w = R.width ;
		translate(0f , -L.getStrikethroughOffset()) ;
    }

	box copie() {
		box r = new box() ; r.G = (GeneralPath)G.clone() ; r.w = w ; r.a = a ; r.d = d ; return r ;
	}
	
	Rectangle2D.Float rectL() { return new Rectangle2D.Float(0f , -a , w , a + d) ; }
    
	Rectangle2D.Float rectV() { return (Rectangle2D.Float)G.getBounds2D() ; }

// 2. TRANSFORMATIONS ______________________________________________________________________

    void translate(float tx , float ty) { 
		at.setToTranslation(tx , ty) ; G.transform(at) ; a -= ty ; d += ty ;
    }
    
    void dilate(float dx , float dy) { 
		at.setToScale(dx , dy) ; G.transform(at) ; w *= dx ; a *= dy ; d *= dy ;
    }
	
	void centre() {
		Rectangle2D.Float R = rectV() ; translate(-R.x , -R.y - R.height / 2) ; 
		w = R.width ; a = d = R.height / 2 ;
	}
    
	void centre(float f) { if (f > w) { float t = (f - w) / 2 ; translate(t , 0f) ; w = f ; } }
	
	void centre(String s) { centre(w + GRAPHICS.getFontMetrics().stringWidth(s)) ; }
	
	void reduitH(float f) { a = f - rectV().y ; }
		
	void reduitB(float f) { Rectangle2D.Float R = rectV() ; d = f + R.height + R.y ; }
    
// 3. CONCATÉNATIONS _______________________________________________________________________

    void append(box F) {
		F.translate(w , 0f) ; G.append(F.G , false) ;
		w += F.w ; if (F.a > a) a = F.a ; if (F.d > d) d = F.d ;
    }
    
    void suspend(box F) {
		F.translate(0f , a + d) ; G.append(F.G , false) ;
		a += F.a ; d += F.d ; if (F.w > w) w = F.w ;
    }
    
    void append(String s) { append(new box(s , false)) ; }
    
    void append(Object[] O) {
		Object o ;
		for(int i = 0 ; i < O.length ; i++) {
			o = O[i] ; if (o != null) {
				if (o instanceof String) append(new box((String)o , false)) ;
				else if (o instanceof box) append((box)o) ;
			}
		}
    }
    
// 4. PARENTHÈSES __________________________________________________________________________

	void parenth(box po , box pf) {
		po.reduitH(0f) ; pf.reduitH(0f) ;
		po.translate(0f , po.a) ; pf.translate(0f , pf.a) ; 
		Rectangle2D.Float R = rectL() ; 
		if (R.height > GRAPHICS.getFontMetrics().getHeight()) { po.centre("\u0020") ; pf.centre("\u0020") ; }
		float t = R.height / po.d ;
		po.dilate(1f , t) ; po.translate(0f , R.y) ; 
		translate(po.w , 0f) ; w += po.w ; G.append(po.G , false) ;
		pf.dilate(1f , t) ; pf.translate(w , R.y) ; w += pf.w ; G.append(pf.G , false) ;
	}
    
	void parentho(box po) {
		po.reduitH(0f) ; po.translate(0f , po.a) ;
		Rectangle2D.Float R = rectL() ; if (R.height > GRAPHICS.getFontMetrics().getHeight()) po.centre("\u0020") ;
		float t = R.height / po.d ; po.dilate(1f , t) ; po.translate(0f , R.y) ; 
		translate(po.w , 0f) ; w += po.w ; G.append(po.G , false) ;
	}
    
	void parenthf(box pf) {
		pf.reduitH(0f) ; pf.translate(0f , pf.a) ; 
		Rectangle2D.Float R = rectL() ; if (R.height > GRAPHICS.getFontMetrics().getHeight()) pf.centre("\u0020") ;
		float t = R.height / pf.d ;
		pf.dilate(1f , t) ; pf.translate(w , R.y) ; w += pf.w ; G.append(pf.G , false) ;
	}
    
	void parenth(String o , String f) { parenth(new box(o , false) , new box(f , false)) ; }
	void parentho(String o) { parentho(new box(o , false)) ; }
	void parenthf(String f) { parenthf(new box(f , false)) ; }

    void parenth() { parenth("\u0028" , "\u0029") ; }
	
// 5. TRACÉ _______________________________________________________________________________

    void trace(float x , float y) { 
        at.setToTranslation(x , y) ; 
		GRAPHICS.fill(G.createTransformedShape(at)) ;
    }
	
/*___________________________________ MÉTHODES STATIQUES ___________________________________*/

// 1. TRAIT ________________________________________________________________________________

    public static void setLine() {
		if (FRC == null) return ;
		box t = trait() ; lt = t.a + t.d ;
    }


// 2. FONTE ________________________________________________________________________________

	static void newSize(float ns) { 
		stackSize.push(new Float(FONT_PLAIN.getSize2D())) ; 
		if (ns > 8f) changeSize(ns) ; 
	}
	
	static void redSize(float f) { newSize(f * FONT_PLAIN.getSize2D()) ; }
	
	static void prevFont() {
		if (stackFont.isEmpty()) return ;
		FONT_PLAIN = (Font)stackFont.pop() ; 
		FONT_ITALIC = FONT_PLAIN.deriveFont(Font.ITALIC) ; 
		setLine() ;
	}	

	static void prevSize() {
		if (stackSize.isEmpty()) return ; 
		float ps = ((Float)stackSize.pop()).floatValue() ; 
		if (ps > 8f) changeSize(ps) ; 
	}	

	static void changeFont(Font f) {
		stackFont.push(FONT_PLAIN) ;
		FONT_PLAIN = f ; 
		FONT_ITALIC = FONT_PLAIN.deriveFont(Font.ITALIC) ; 
		setLine() ;
	}

	static void changeSize(float ns) { 
		FONT_PLAIN = FONT_PLAIN.deriveFont(ns) ; 
		FONT_ITALIC = FONT_PLAIN.deriveFont(Font.ITALIC) ; 
		setLine() ;
	}
	
	
// 3. CRÉATION DE SYMBOLES _________________________________________________________________

	static box trait() { box r = new box("\u002D") ; r.centre() ; return r ; }

	static box trait(float l) { box r = trait() ; r.dilate(l / r.w , 1f) ; return r ; }

	static box traitV() { box r = new box("\u007C" , false) ; r.centre() ; return r ; }    
    
	static box traitV(float l) { box r = traitV() ; r.dilate(1f , l / (r.a + r.d)) ; return r ; }
    
	static box fleche(float l) { 
		box r = trait(l) ; at.setToRotation(5*Math.PI/6) ; r.G.transform(at) ;
		box s = trait(l) ; at.setToRotation(-5*Math.PI/6) ; s.G.transform(at) ;
		r.G.moveTo(0f , 0f) ; r.G.append(s.G , false) ;
		r.w = 0f ; r.a = r.d = s.rectV().height ;
		return r ; 
	}
    
	static box rightArrow(float l) { 
		float m = FONT_PLAIN.getSize2D() / 12f ;
		box r = trait(l * m) ;
		r.append(fleche(6f * m)) ; 
		r.centre("\u0020\u0020") ; 
		return r ; 
	}

	static box mapsTo(float l) {
		float m = FONT_PLAIN.getSize2D() / 12f ;
		box r = traitV(4f * m) ; 
		r.w = 0f ; r.a = r.d = 2f * m ;
		r.append(trait(l * m)) ;
		r.append(fleche(5f * m)) ; 
		r.centre("\u0020\u0020") ; 
		return r ; 
	}

// 4. OPÉRATIONS ___________________________________________________________________________

/**
* Quotient de deux expressions.
*/
	static box boxQuot(box num , box den) {
        float sp = 3 * lt , t , w = num.w ; if (den.w > w) w = den.w ; box r = trait(w) ; 
		num.centre(w) ; num.reduitB(sp) ; r.a = num.a + num.d ; 
		num.translate(0f , -num.d) ; r.G.append(num.G , false) ;
		den.centre(w) ; den.reduitH(sp) ; r.d = den.a + den.d ; 
		den.translate(0f , den.a) ; r.G.append(den.G , false) ;
        return r ;
    }
	
/**
* Opposé d'une expression.
*/
	static box boxOpp(box b) {
		box r = new box("\u002D" , false) ; r.centre("\u0020") ; r.append(b) ; return r ;
	}
    
/**
* Inverse d'une expression.
*/
	static box boxInv(box b) { return boxQuot(new box("\u0031") , b) ; }
    
/**
* Limite d'une expression.
*/
	static box boxLim(box expr , box mode) {
        float sp = 3 * lt , t , w = expr.w ; if (mode.w > w) w = mode.w ;
		expr.centre(w) ; expr.reduitB(0f) ;
		mode.centre(w) ; mode.reduitH(sp) ;
		expr.w = w ;
		mode.translate(0f , expr.d + mode.a) ; 
		expr.d += mode.a + mode.d ; expr.G.append(mode.G , false) ;		
		return expr ;
    }
    
/**
* Puissance.
*/
	public static box boxPow(box A , box B) { 
		B.reduitH(0f) ; B.reduitB(0f) ; float s = -A.rectV().y , t = B.a - s  ;
		if (t + B.d < 0) B.translate(0f , t) ;
		else {
			B.translate(0f , -s) ;
			if (B.d > 0) B.translate(0f , -B.d) ;
		}
		A.append(B) ; return A ; 
	}
    
/**
* Indice.
*/
	public static box boxInd(box A , box B) { 
		B.reduitH(0f) ; B.reduitB(0f) ; float s = A.rectV().height + A.rectV().y , t = s - B.d ;
		if (B.a + B.d < s) B.translate(0f , t) ;
		else {
			B.translate(0f , s) ;
			if (B.d < 0) B.translate(0f , -B.d) ;
		}
		A.append(B) ; return A ; 
	}
    
/**
* Racine carée d'une expression.
*/
	static box boxRac(box f) {
		box r = new box("\u221A" , false) , t = trait(f.w) ; r.reduitB(0f) ; r.reduitH(0f) ; 
		f.a += 3*lt ; Rectangle2D.Float R = f.rectV() ; float fr = f.a + R.height + R.y ;
		r.translate(0f , r.a) ; r.dilate(1f , fr/r.d) ;
		t.translate(r.w , t.a) ; r.G.append(t.G , false) ;
		r.translate(0f , -f.a) ; f.translate(r.w , 0f) ; f.G.append(r.G , false) ; f.w += r.w ;
		return f ;
    }

/**
* Vecteur colonne.
*/
	static box boxColumn(Vector tab) {
		box b = new box() ; box[] B = new box[tab.size()] ;
		String s ; int p ; double[] offset = new double[tab.size()] ; double max = 0 ; GlyphVector GV ;
		for(int i = 0 ; i < tab.size() ; i++) {
			s = (String)tab.elementAt(i) ;
			p = s.indexOf(DSEP) ; if (p < 0) p = s.length() ;
			GV = FONT_PLAIN.createGlyphVector(FRC , s) ;
			offset[i] = GV.getGlyphPosition(p).getX() ;
			if (offset[i] > max) max = offset[i] ;
			B[i] = new box(s , FONT_PLAIN) ;
		}
		float h = 0f ;
		for(int i = 0 ; i < tab.size() ; i++) {
			B[i].translate((float)(max - offset[i]) , h) ;
			b.G.append(B[i].G , false) ;
			h += B[i].a + B[i].d ;
			if (B[i].w > b.w) b.w = B[i].w ;
		}
		b.a = h ;
		return b ;
	}

/**
* Tableau.
*/
	static box boxTab(Object[][] tab , int l , int c) {
		box b = new box() ; 
		box[][] B = new box[l][c] ;
		double[][] offset = new double[l][c] ; 
		double max[] = new double[c] ; 
		double width[] = new double[c] ; 
		Object o ; String s ; int p ; GlyphVector GV ;
		for(int j = 0 ; j < c ; j++) {
			max[j] = 0 ; width[j] = 0 ;
			for(int i = 0 ; i < l ; i++) {
				o = tab[i][j] ;
				if (o instanceof String) {
					s = (String)o ; p = s.indexOf(DSEP) ; if (p < 0) p = s.length() ;
					GV = FONT_PLAIN.createGlyphVector(FRC , s) ;
					offset[i][j] = GV.getGlyphPosition(p).getX() ;
					if (offset[i][j] > max[j]) max[j] = offset[i][j] ;
					B[i][j] = new box(s , FONT_PLAIN) ;
				}
				else if (o instanceof form) {
					offset[i][j] = 0 ; B[i][j] = ((form)o).toBox() ;
				}
				else if (o instanceof box) {
					offset[i][j] = 0 ; B[i][j] = ((box)o).copie() ;
				}
				if (B[i][j].w > width[j]) width[j] = B[i][j].w ;
			}
		}
		box BL ; double wi ;
		for(int i = 0 ; i < l ; i++) {
			BL = new box() ; wi = 0 ;
			for(int j = 0 ; j < c ; j++) {
				B[i][j].translate((float)(wi + max[j] - offset[i][j]) , 0f) ;
				BL.append(B[i][j]) ;
				wi += width[j] - B[i][j].w ;
			}
			b.suspend(BL) ;
		}
		return b ;
	}

}

