//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.* ;
import java.awt.event.* ;
import javax.swing.* ;


public class PrefsPane extends JFrame {

	zone Z ;
	protected TableColor  table = new TableColor((short)12 , (short)5 , (short)10 , (short)10) ; 
	protected String fontName ;
	protected int fontSize = 12 ;
	protected Font titleFont, bodyFont;


//  étiquettes ___________________________________________________________________________
	JLabel  lbg ,									// labels
			lbd ,
			lbb ,
			lbh ,
			lbx ,
			lby ,
			lbu ,
			lbv ,
			lbz ,
			lbt ;
	String[] lab = dessin.extract("prefslab") ;		
	JLabel[] LB = new JLabel[] {							
		lbg = new JLabel(lab[0]) , lbd = new JLabel(lab[1]) , lbb = new JLabel(lab[2]) , lbh = new JLabel(lab[3]) , 
		lbx = new JLabel(lab[4]) , lby = new JLabel(lab[5]) , lbu = new JLabel(lab[6]) , lbv = new JLabel(lab[7]) ,
		lbz = new JLabel(lab[8]) , lbt = new JLabel(lab[9])
	} ;
//  champs de saisie ______________________________________________________________________
	final JTextField  
				tfg ,										// champs associés aux labels
				tfd ,
				tfb ,
				tfh ,
				tfx ,
				tfy ,
				tfu ,
				tfv ,
				tfz ,
				tft ;
	JTextField[] TF = new JTextField[] {					
		tfg = new JTextField(4) ,  tfd = new JTextField(4) ,  tfb = new JTextField(4) , tfh = new JTextField(4) , 
		tfx = new JTextField(4) , tfy = new JTextField(4) , tfu = new JTextField(4) , tfv = new JTextField(4) , 
		tfz = new JTextField(4) , tft = new JTextField(4)
	} ;

//  cases à cocher _________________________________________________________________________
	JCheckBox   checkRep ,									// visibilité du repère
				checkQuad ;									// visibilité du quadrillage
	JCheckBox[] CK ;

//  boutons radio _________________________________________________________________________
	JRadioButton	brep , bqua , bcac ;
	JRadioButton[] RB ;
	ButtonGroup group = new ButtonGroup() ;

//  listes déroulantes _____________________________________________________________________
	String[]	fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(dessin.LOCALE) ,
				fontSizes = new String[] {"" , "8" , "9" , "10" , "11" , "12" , "14" , "16" , "18" , "24" , "32" , "48"} ,
				str = dessin.extract("prefspane");
	JComboBox   
		comboFont = new JComboBox(fontNames) ,
		comboSize = new JComboBox(fontSizes) ;
	JComboBox[] CB = new JComboBox[] {comboFont , comboSize} ;
	int getIndex(String s , String[] S) {
		for(int i = 0 ; i < S.length ; i++) {
			if (s.equals(S[i])) return i ;
		}
		return -1 ;
	}
	
// écouteurs  ______________________________________________________________________________

	MouseListener buttonListener = new MouseAdapter() {
		public void mouseClicked(MouseEvent me) { 
			boolean b  = (me.isShiftDown()) ? 
				dessin.parseUnits(new String[]{ TF[4].getText() , TF[5].getText() }) :
				dessin.parseCoords(new String[]{ TF[0].getText() , TF[1].getText() , TF[2].getText() , TF[3].getText() }) 
			;
			b = (b || dessin.parseGrid(new String[]{ TF[6].getText() , TF[7].getText() })) ;
			b = (b || dessin.parseRound(new String[]{ TF[8].getText() , TF[9].getText() })) ;
			if (b) { dessin.setOrigin() ; refresh() ; Z.D.refresh() ; }
		}
	} ;
	
	ActionListener coordListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) { 
			if (dessin.parseCoords(new String[]{ TF[0].getText() , TF[1].getText() , TF[2].getText() , TF[3].getText() })) 
				dessin.setOrigin() ; 
		}
	} ;
	
	ActionListener unitListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) { 
			if (dessin.parseUnits(new String[]{ TF[4].getText() , TF[5].getText() })) 
				dessin.setOrigin() ; 
		}
	} ;
	
	ActionListener gridListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) { 
			if (dessin.parseGrid(new String[]{ TF[6].getText() , TF[7].getText() })) 
				dessin.setOrigin() ; 
		}
	} ;
	
	ActionListener roundListener = new ActionListener() {
		public void actionPerformed(ActionEvent ae) { 
			if (dessin.parseRound(new String[]{ TF[8].getText() , TF[9].getText() })) {
				refresh() ; Z.D.refresh() ;
			}
		}
	} ;
	
	ItemListener radioListener = new ItemListener() {
		public void itemStateChanged(ItemEvent ie) {
			JRadioButton rb = (JRadioButton) ie.getSource() ; 
			boolean b = (ie.getStateChange() == ItemEvent.SELECTED) ;
			if ((brep.isSelected() || bqua.isSelected()) && !table.isVisible()) {
				table.setVisible(true) ; pack() ;
			}
			else if (bcac.isSelected() && table.isVisible()) {
				table.setVisible(false) ; pack() ; 
			}
		}
	} ;
	
	ItemListener comboListener = new ItemListener() {
		public void itemStateChanged(ItemEvent ie) { 
			JComboBox cb = (JComboBox) ie.getSource() ;
			if (cb == comboFont) fontName = (String)cb.getSelectedItem() ;
			else if (cb == comboSize) {
				try { fontSize = Integer.parseInt((String)cb.getSelectedItem()) ; }
				catch (NumberFormatException nfe) {}
			}
			dessin.setFont(new Font(fontName, Font.PLAIN, fontSize)) ;
			if (Z == null) return ;
			Z.A.changeFont(dessin.FONT_PLAIN) ;
			Z.D.changeFont(dessin.FONT_PLAIN) ;
			for (int i = 0 ; i < Z.GR.size() ; i++) {
				objetG o = (objetG)Z.GR.elementAt(i) ;
				o.changeFont() ;
			}
			Z.repaint() ;
		}
	} ;
	
	
	WindowAdapter windowListener = new WindowAdapter() {
		public void windowOpened(WindowEvent we) {
			Point loc = Z.getLocation() ;
			setLocation(loc.x + Z.getWidth() , 
						loc.y + ((Z.A.isVisible()) ? Z.A.getHeight() + getInsets().top : 0)
			) ;
		}
	} ;


	public PrefsPane(zone z) { 
		super() ; Z = z ; addWindowListener(windowListener) ;
		brep = new JRadioButton(str[0]) ;
		bqua = new JRadioButton(str[1]) ;
		bcac = new JRadioButton(str[2]) ;
		RB = new JRadioButton[] {brep , bqua , bcac} ;
		
		checkRep = new JCheckBox(Z.repAction) ; 
		checkQuad = new JCheckBox(Z.quadAction) ;
		CK = new JCheckBox[]{checkRep , checkQuad} ;
		
		titleFont = new Font("Lucida Sans", Font.BOLD, 14);
		bodyFont  = new Font("Lucida Sans", Font.PLAIN, 12);
		fontName = bodyFont.getName() ;
		for(int i = 0 ; i < LB.length ; i++) LB[i].setFont(bodyFont) ;
		for(int i = 0 ; i < TF.length ; i++) { 
			TF[i].setFont(bodyFont) ; 
			if (i < 4) TF[i].addActionListener(coordListener) ;
			else if (i < 6) TF[i].addActionListener(unitListener) ;
			else if (i < 8) TF[i].addActionListener(gridListener) ;
			else TF[i].addActionListener(roundListener) ;
			TF[i].setHorizontalAlignment(JTextField.LEFT) ;
		}
		for(int i = 0 ; i < CB.length ; i++) { 
			CB[i].setFont(bodyFont) ; CB[i].addItemListener(comboListener) ; 
		}
		for(int i = 0 ; i < CK.length ; i++) CK[i].setFont(bodyFont) ;
		for(int i = 0 ; i < RB.length ; i++) { 
			RB[i].setFont(bodyFont) ; RB[i].addItemListener(radioListener) ; group.add(RB[i]) ;
		}
		
		Container C = getContentPane() ;
		C.setLayout(new BoxLayout(C , BoxLayout.Y_AXIS)) ;
		FlowLayout flow = new FlowLayout(FlowLayout.LEFT) ;
		setTitle(str[3]) ;
		JLabel lb ; Panel pa ;
		C.add(pa = new Panel(flow)) ; pa.add (lb = new JLabel(str[4])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel()) ;
			pa.add(lbg) ; pa.add(tfg) ;
			pa.add(Box.createHorizontalStrut(15)) ;
			pa.add(lbd) ; pa.add(tfd) ;
		C.add(pa = new Panel()) ;
			pa.add(lbb) ; pa.add(tfb) ;
			pa.add(Box.createHorizontalStrut(15)) ;
			pa.add(lbh) ; pa.add(tfh) ;
		C.add(pa = new Panel(flow)) ; pa.add(lb = new JLabel(str[5])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel()) ;
			pa.add(Box.createHorizontalStrut(20)) ;
			pa.add(checkRep) ; checkRep.setSelected(Z.repereVisible) ;
			pa.add(Box.createHorizontalStrut(10)) ;
			pa.add(checkQuad) ; checkQuad.setSelected(Z.quadrillageVisible) ;
		C.add(pa = new Panel(flow)) ; pa.add(lb = new JLabel(str[6])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel()) ;
			pa.add(lbx) ; pa.add(tfx) ;
			pa.add(Box.createHorizontalStrut(15)) ;
			pa.add(lby) ; pa.add(tfy) ;
		C.add(pa = new Panel(flow)) ; pa.add(lb = new JLabel(str[7])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel()) ;
			pa.add(lbu) ; pa.add(tfu) ;
			pa.add(Box.createHorizontalStrut(15)) ;
			pa.add(lbv) ; pa.add(tfv) ;
		C.add(pa = new Panel(flow)) ; pa.add(lb = new JLabel(str[8])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel()) ;
			pa.add(lbz) ; pa.add(tfz) ;
			pa.add(Box.createHorizontalStrut(15)) ;
			pa.add(lbt) ; pa.add(tft) ;
		C.add(pa = new Panel(flow)) ; pa.add(lb = new JLabel(str[9])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel(new FlowLayout())) ; 
			pa.add(brep) ; pa.add(bqua) ; pa.add(bcac) ; 
			group.add(brep) ; group.add(bqua) ; group.add(bcac) ;
			bcac.setSelected(true) ;
			C.add(table) ; table.setVisible(false) ;
			brep.addItemListener(radioListener) ; bqua.addItemListener(radioListener) ; bcac.addItemListener(radioListener) ;
		C.add(pa = new Panel(flow)) ; pa.add(lb = new JLabel(str[10])) ; lb.setFont(bodyFont) ;
		C.add(pa = new Panel()) ;
			pa.add(comboFont) ; 
				comboFont.setSelectedIndex(getIndex(fontName , fontNames)) ;
			pa.add(comboSize) ;
				comboSize.setPrototypeDisplayValue("    ") ;
				comboSize.setPreferredSize(new Dimension(50 ,  22)) ;
				comboSize.setEditable(true) ; 
				comboSize.setSelectedIndex(getIndex("" + fontSize , fontSizes)) ;
		C.add(pa = new Panel()) ;
			pa.setLayout(new BoxLayout(pa , BoxLayout.X_AXIS)) ;
			JButton validButton = new JButton(str[11]) ; validButton.setFont(bodyFont) ;
			pa.add(validButton) ; validButton.addMouseListener(buttonListener) ;
			pa.add(Box.createHorizontalGlue()) ;
			JButton close = new JButton(str[12]) ; close.setFont(bodyFont) ;
			pa.add(close) ; 
			close.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					setVisible(false) ;			
				}
			}) ;
		pack() ; setResizable(false) ;
		dessin.P = this ;
		refresh() ;
	}
	
	String[] windowDatas() {
		return new String[] { 
			dessin.NF.format(dessin.XG) , dessin.NF.format(dessin.XD) , 
			dessin.NF.format(dessin.YB) , dessin.NF.format(dessin.YH) ,
			dessin.NF.format(dessin.UX) , dessin.NF.format(dessin.UY) ,
			dessin.NF.format(dessin.QX) , dessin.NF.format(dessin.QY) ,
			dessin.NF.format(dessin.USER_GRID) , dessin.NF.format(dessin.ROUND) 
		} ;
	}

	void affectDatas(String[] S) { for(int i = 0 ; i < TF.length ; i++) TF[i].setText(S[i]) ; }
	
	void refresh() { affectDatas(windowDatas()) ; }
	
	String[] gatherDatas() {
		String[] sf = new String[TF.length] ;
		for (int i = 0 ; i < TF.length ; i++) sf[i] = TF[i].getText() ;
		return sf ;
	}
	
	class TableColor extends JPanel {
		int l , c , w , h , i0 , j0 ; 
		boolean selected = false ;
		Color[][] tab ;

		public TableColor(short lp , short cp , short lh , short cw) {
			l = (int) lp + 1 + lp/2 ; c = (int) 6*cp + 1 ;  h = (int)lh ; w = (int)cw ; tab = new Color[l][c] ;
			setPreferredSize(new Dimension(c * w , l * h)) ; addMouseListener(colorListener) ;
			
			float f ; LineDescriptor desc = new LineDescriptor(cp) ; int j ;
			for(float i = 0 ; i < l ; i++) {
				f = 1f - i / (l - 1f) ; 
				tab[(int)i][0] = new Color(f , f , f) ;
			}
			j = 1 ; while(j < c) { tab[lp][j] = desc.nextColor() ; j ++ ; }
			for(float i = 0 ; i < lp ; i++) {
				f = 1f - (i + 1f) / (lp + 1f) ; desc.reset(f , 1f) ; j = 1 ;
				while(j < c) { Color col = tab[(int)i][j] = desc.nextColor() ; j++ ; }
			}
			for(float i = 0 ; i < lp/2 ; i++) {
				f = 1f - (i + 1f) / (lp + 1f) ; desc.reset(0f , f) ; j = 1 ;
				while(j < c) { tab[lp + 1 + (int)i][j] = desc.nextColor() ; j++ ; }
			}

		}
		
		public void paintComponent(Graphics g) {
			g.setColor(Color.lightGray) ; g.fillRect(0 , 0 , getWidth() , getHeight()) ;
			for(int i = 0 ; i < l ; i ++) {
				for(int j = 0 ; j < c ; j ++) {
					g.setColor(tab[i][j]) ;
					g.fillRect(j * w , i * h , w - 1 , h - 1) ;
				}
			}
			if (!selected) return ;
			Color c = tab[i0][j0] ;
			if (c.getRed() + c.getGreen() + c.getBlue() > 382) g.setColor(Color.black) ; 
			else g.setColor(Color.white) ;
			g.drawOval(j0 * w , i0 * h , w - 1 , h - 1) ;
		}
				
		MouseListener colorListener = new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				i0 = e.getY() / h ; j0 = e.getX() / w ; 
				selected = true ; 
				Color col = tab[i0][j0] ;
				if (brep.isSelected()) dessin.AXIS_COLOR = col ;
				if (bqua.isSelected()) dessin.GRID_COLOR = col ;
				repaint() ;
				Z.repaint() ;
			}
		} ;

	}

	class LineDescriptor {
	
		short p , r , g , b , w , c ; boolean dir  ;
		float u = 0f , v = 1f , f = (v - u) / (float)p ;
		
		LineDescriptor(short par) { p = par ; reset() ; }
		
		void reset(short par) { p = par ; reset() ; }
		
		void reset() { 
			u = 0f ; v = 1f ; f = (v - u) / (float)p ;
			r = 0 ; g = p ; b = c = 1 ; w = 2 ; dir = false ; 
		}
		
		void reset(float min , float max) { 
			u = min ; v = max ; f = (v - u) / (float)p ;
			r = 0 ; g = p ; b = c = 1 ; w = 2 ; dir = false ; 
		}
		
		float floatV(int n) { return u + f * (float)n ; }
		
		void next() {
			if (dir) c ++ ; else c-- ;
			if (w == 0) r = c ; else if (w == 1) g = c ; else b = c ;
			if (((dir) && (c == p)) || ((!dir) && (c == 0))) { w ++ ; if (w == 3) w = 0 ; dir = !dir ; } 
		}
		
		Color nextColor() { next() ; return new Color(floatV(r) , floatV(g) , floatV(b)) ; }
	}

}

