//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.io.IOException;

public class HelpPane extends JFrame implements HyperlinkListener {
	
	private JEditorPane htmlPane ;
	
	private zone Z ;
	
	private java.net.URL url;

	public HelpPane(zone z) {
		super() ;
		String[] str = dessin.extract("manuelbox") ;
		setTitle(str[0]) ;
		Z = z ;
		url = HelpPane.class.getResource(
			"manuel" 
			+ (dessin.LOCALE.getLanguage().equals("fr") ? "_fr" : "")
			+ ".html"
		) ;
		try {
			htmlPane = new JEditorPane(url) ;
			htmlPane.setFont(dessin.FONT_PLAIN) ;
			htmlPane.setEditable(false) ;
			htmlPane.addHyperlinkListener(this) ;
			htmlPane.setPreferredSize(new Dimension(650,500)) ;
			JScrollPane scrollPane = new JScrollPane(htmlPane) ;
			getContentPane().add(scrollPane, BorderLayout.CENTER) ;
			getContentPane().add(new JLabel("  "), BorderLayout.SOUTH) ;
		}
		catch(IOException ioe) { System.err.println("Erreur : " + ioe) ; }
		setBounds(dessin.W/8, dessin.H/8,700,500) ;
		setResizable(false) ;
	}
	
	public void hyperlinkUpdate(HyperlinkEvent event) {
		if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			try { htmlPane.setPage(event.getURL()) ; } 
			catch(IOException ioe) {
				System.err.println("Ne peut suivre le lien vers " 
					+ event.getURL().toExternalForm() + ": " + ioe);
			}
		}
	}
  
}
