//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//  Created by Joël AMBLARD on Wed Nov 03 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class AspectPane  extends JFrame {

	zone Z ;
	
	objetG o ;
	
	String[] str ;
	
	TableColor  table = new TableColor((short)12 , (short)5 , (short)10 , (short)10) ;
	
	JPanel  panelColor  = new JPanel() ,
			panelObjet  = new JPanel() ,
			panelIcon  = new JPanel() ,
			panelButton  = new JPanel() ,
			panelName  = new JPanel() ;
			
	JLabel  lo = new JLabel("couleur") , lco = new JLabel("   ") , ln = new JLabel() ;
	
	JButton bo = new JButton("  ") , obo = new JButton() , 
			valid = new JButton() , close  = new JButton() ;
			
	JTextField tfn = new JTextField(5) ;
	JRadioButton	tob = new JRadioButton() ,
					fob = new JRadioButton() ,
					textButton = new JRadioButton() ,
					formButton = new JRadioButton() ;
					
	JRadioButton[] rb = new JRadioButton[] {tob , fob , textButton , formButton} ;
	
	ButtonGroup ogroup = new ButtonGroup() , ngroup = new ButtonGroup() ;
	
	Component[] co = new Component[] {
		lo , ln ,
		tob , fob , textButton , formButton ,
		tfn , valid , close
	} ;
	
	ActionListener choiceColorListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			JButton b = (JButton) e.getSource() ;
			sendColor(b.getBackground()) ;
		}
	} ;

	ActionListener fieldListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			if (o == null) return ;
			if (o instanceof marque) ((marque)o).setName(tfn.getText() , false) ;
			else o.name = tfn.getText() ;
			o.prettyprint = formButton.isSelected() ;
			if (o.hasicon) o.BI.maj() ; else o.setIcon() ;
			if ((o instanceof suiterec) || (o instanceof suitegen)) o.recalc() ;
			Z.D.refresh() ; Z.repaint() ;
		}
	} ;

	ItemListener radioListener = new ItemListener() {
		public void itemStateChanged(ItemEvent ie) {
			if (o == null) return ;
			JRadioButton rb = (JRadioButton) ie.getSource() ; 
			boolean b = (ie.getStateChange() == ItemEvent.SELECTED) ;
			if (rb == tob) { lco.setBackground(o.col) ; obo.setBackground(o.col) ; }
			else if (rb == fob) { lco.setBackground(o.colf) ; obo.setBackground(o.colf) ; }
			else fieldListener.actionPerformed(new ActionEvent(this , 0 , "")) ;
		}
	} ;
	
	WindowAdapter windowListener = new WindowAdapter() {
		public void windowOpened(WindowEvent we) {
			Point loc = Z.getLocation() ;
			setLocation(loc.x + Z.getWidth() , loc.y) ;
		}
	} ;

	void sendColor(Color col) {
		if (o == null) return ;
		lco.setBackground(col) ;
		if (tob.isSelected()) o.col = col ;
		if (fob.isSelected()) o.colf = new Color(
			col.getRed() , col.getGreen() , col.getBlue() , (o instanceof domaine) ? 128 : 255
		) ;
		Z.repaint() ;
	}
	
	void setObject(objetG og) {
		o  = og ; 
		lco.setBackground(o.col) ; obo.setBackground(o.col) ; tob.setSelected(true) ;
		tob.setVisible(o.colf != null) ; fob.setVisible(o.colf != null) ;
		boolean enable = (!(o instanceof boxicon)  && !(o instanceof text)) ;
		panelName.setVisible(enable) ; if (!enable) return ;
		tfn.setText(o.name) ; 
		formButton.setSelected(o.prettyprint) ;
		//tfn.setEditable(!(o instanceof boxicon)) ;
		//formButton.setEnabled(false) ; 		
		//formButton.setEnabled(enable) ; textButton.setEnabled(enable) ;
		//panelName.setVisible(enable) ;
		//obo.requestFocusInWindow() ;
	}

	void changeFont(Font f) {
		for(int i = 0 ; i < co.length ; i++) co[i].setFont(f) ;
	}
	
	public AspectPane(zone z) { 
		super() ;
		str = dessin.extract("aspectpanel") ;
		setTitle(str[8]) ;
		lo.setText(str[0]);
		ln.setText(str[1]);
		valid.setText(str[2]);
		close.setText(str[3]);
		tob.setText(str[4]);
		fob.setText(str[5]);
		textButton.setText(str[6]);
		formButton.setText(str[7]);
		Z = z ;
		Container C = getContentPane() ;
		C.setLayout(new BoxLayout(C , BoxLayout.Y_AXIS)) ;
		C.add(panelColor) ;
			panelColor.setBorder(BorderFactory.createRaisedBevelBorder()) ;
			panelColor.add(table) ;
		C.add(panelObjet) ;
			panelObjet.add(lco) ; lco.setOpaque(true) ;
			panelObjet.add(lo) ;
			panelObjet.add(obo) ;
			obo.setBorder(BorderFactory.createRaisedBevelBorder()) ;
			obo.setPreferredSize(new Dimension(10 ,10)) ;
			obo.addActionListener(choiceColorListener) ;
			panelObjet.add(Box.createHorizontalStrut(20)) ;
			ogroup.add(tob) ; ogroup.add(fob) ; 
			panelObjet.add(tob) ; panelObjet.add(fob) ;
			tob.setVisible(false) ; fob.setVisible(false) ; 
		C.add(panelName) ;
			panelName.add(ln) ;
			panelName.add(tfn) ; tfn.addActionListener(fieldListener) ;
			panelName.add(formButton) ; ngroup.add(formButton) ; formButton.setSelected(true) ;
			panelName.add(textButton) ; ngroup.add(textButton) ;
		C.add(panelButton) ;
			panelButton.setLayout(new BoxLayout(panelButton , BoxLayout.X_AXIS)) ;
			panelButton.add(valid) ; valid.addActionListener(fieldListener) ;
			panelButton.add(Box.createHorizontalGlue()) ;
			panelButton.add(close) ; 
			close.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					tfn.setText((o == null) ? "" : o.name) ;
					setVisible(false) ;			
				}
			}) ;
		for(int i = 0 ; i < rb.length ; i++) rb[i].addItemListener(radioListener) ;
		addWindowListener(windowListener) ;
		setResizable(false) ;
		pack() ;
	}
	
	class TableColor extends JPanel {
		int l , c , w , h , i0 , j0 ; 
		boolean selected = false ;
		Color[][] tab ;

		public TableColor(short lp , short cp , short lh , short cw) {
			l = (int) lp + 1 + lp/2 ; c = (int) 6*cp + 1 ;  h = (int)lh ; w = (int)cw ; tab = new Color[l][c] ;
			setPreferredSize(new Dimension(c * w , l * h)) ; addMouseListener(colorListener) ;
			
			float f ; LineDescriptor desc = new LineDescriptor(cp) ; int j ;
			for(float i = 0 ; i < l ; i++) {
				f = 1f - i / (l - 1f) ; 
				tab[(int)i][0] = new Color(f , f , f) ;
			}
			j = 1 ; while(j < c) { tab[lp][j] = desc.nextColor() ; j ++ ; }
			for(float i = 0 ; i < lp ; i++) {
				f = 1f - (i + 1f) / (lp + 1f) ; desc.reset(f , 1f) ; j = 1 ;
				while(j < c) { Color col = tab[(int)i][j] = desc.nextColor() ; j++ ; }
			}
			for(float i = 0 ; i < lp/2 ; i++) {
				f = 1f - (i + 1f) / (lp + 1f) ; desc.reset(0f , f) ; j = 1 ;
				while(j < c) { tab[lp + 1 + (int)i][j] = desc.nextColor() ; j++ ; }
			}

		}
		
		public void paintComponent(Graphics g) {
			g.setColor(Color.lightGray) ; g.fillRect(0 , 0 , getWidth() , getHeight()) ;
			for(int i = 0 ; i < l ; i ++) {
				for(int j = 0 ; j < c ; j ++) {
					g.setColor(tab[i][j]) ;
					g.fillRect(j * w , i * h , w - 1 , h - 1) ;
				}
			}
			if (!selected) return ;
			Color c = tab[i0][j0] ; //g.setColor(c) ;
			if (c.getRed() + c.getGreen() + c.getBlue() > 382) g.setColor(Color.black) ; 
			else g.setColor(Color.white) ;
			g.drawOval(j0 * w , i0 * h , w - 1 , h - 1) ;
		}
				
		MouseListener colorListener = new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				i0 = e.getY() / h ; j0 = e.getX() / w ; 
				selected = true ; 
				Color col = tab[i0][j0] ;
				sendColor(col) ;
				repaint() ;
			}
		} ;

	}

	class LineDescriptor {
	
		short p , r , g , b , w , c ; boolean dir  ;
		float u = 0f , v = 1f , f = (v - u) / (float)p ;
		
		LineDescriptor(short par) { p = par ; reset() ; }
		
		void reset(short par) { p = par ; reset() ; }
		
		void reset() { 
			u = 0f ; v = 1f ; f = (v - u) / (float)p ;
			r = 0 ; g = p ; b = c = 1 ; w = 2 ; dir = false ; 
		}
		
		void reset(float min , float max) { 
			u = min ; v = max ; f = (v - u) / (float)p ;
			r = 0 ; g = p ; b = c = 1 ; w = 2 ; dir = false ; 
		}
		
		float floatV(int n) { return u + f * (float)n ; }
		
		void next() {
			if (dir) c ++ ; else c-- ;
			if (w == 0) r = c ; else if (w == 1) g = c ; else b = c ;
			if (((dir) && (c == p)) || ((!dir) && (c == 0))) { w ++ ; if (w == 3) w = 0 ; dir = !dir ; } 
		}
		
		Color nextColor() { next() ; return new Color(floatV(r) , floatV(g) , floatV(b)) ; }
	}
}

