//
//  Copyright (c) 2005 Joël Amblard - joel.amblard_NOSPAM_wanadoo.fr (replace _NOSPAM_ by @)
//
//   This program is free software; you can redistribute it and/or modify 
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version. 

import java.awt.*;
import java.awt.event.ActionEvent ;
import java.awt.event.ActionListener ;
import javax.swing.*;

public class AboutBox extends JFrame implements ActionListener {
	protected JLabel titleLabel, aboutLabel[];
	protected static int labelCount = 5 ;
	protected static int aboutWidth = 450;
	protected static int aboutHeight = 430;
	protected static int aboutTop = 200;
	protected static int aboutLeft = 350;
	protected Font titleFont, bodyFont , smallFont ;
	protected String[] str ;

    public AboutBox() {
		super() ;
		str = dessin.extract("aboutbox") ;
		setTitle(str[0]) ;
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);	
		
		// Initialize useful fonts
		titleFont = new Font("Lucida Sans", Font.BOLD, 14);
		if (titleFont == null) {
			titleFont = new Font("SansSerif", Font.BOLD, 14);
		}
		bodyFont  = new Font("Lucida Sans", Font.PLAIN, 12);
		if (bodyFont == null) {
			bodyFont = new Font("SansSerif", Font.PLAIN, 12);
		}
		
		smallFont  = new Font("Lucida Sans", Font.PLAIN, 10);
		if (bodyFont == null) {
			bodyFont = new Font("SansSerif", Font.PLAIN, 10);
		}
		
		this.getContentPane().setLayout(new BorderLayout(10, 10));
	
		aboutLabel = new JLabel[labelCount];
		aboutLabel[0] = new JLabel(str[1]) ; aboutLabel[0].setFont(titleFont) ;
		java.net.URL url = edugraphe.class.getResource("images/appicon.png") ;
		aboutLabel[1] = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(url))) ;
		aboutLabel[2] = new JLabel(str[2]) ; 
		aboutLabel[2].setFont(bodyFont);
		aboutLabel[3] = new JLabel(str[3]) ; 
		aboutLabel[3].setFont(smallFont);
		aboutLabel[4] = new JLabel(str[4]) ; 
		aboutLabel[4].setFont(smallFont);
		
		Panel textPanel2 = new Panel(); textPanel2.setLayout(new BoxLayout(textPanel2 , BoxLayout.Y_AXIS)) ;
		for (int i = 0; i<labelCount; i++) {
			aboutLabel[i].setAlignmentX(.5f);
			textPanel2.add(aboutLabel[i]);
		}
		
		Panel pa = new Panel(); 
			JButton close = new JButton(str[5]) ;
			pa.add(close) ; 
			close.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					setVisible(false) ;			
				}
			}) ;
		
		this.getContentPane().add(textPanel2 , BorderLayout.CENTER) ;
		this.getContentPane().add(pa , BorderLayout.SOUTH) ;
		this.pack();
		this.setLocation(aboutLeft, aboutTop);
		this.setSize(aboutWidth, aboutHeight);
		this.setResizable(false);
    }

    class SymWindow extends java.awt.event.WindowAdapter {
	    public void windowClosing(java.awt.event.WindowEvent event) {
		    setVisible(false);
	    }
    }
    
    public void actionPerformed(ActionEvent newEvent) {
        setVisible(false);
    }			
}