/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.geocentral.geometria.action.GScaleAction;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GValueInputPane;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GScaleDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GScaleAction action;
    private JTextField p1TextField;
    private JTextField p2TextField;
    private GValueInputPane factorInputPane;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GScaleDialog(Frame ownerFrame, GScaleAction action) {
        super(ownerFrame, true);
        this.action = action;
        logger.info((Object)"");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("ScaleFigure", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("ReferencePoints", new String[0]));
        topPane.setLayout(new BoxLayout(topPane, 0));
        this.p1TextField = GGraphicsFactory.getInstance().createLabelInput(null);
        JPanel leftInputPane = GGraphicsFactory.getInstance().createContainerAdjustBottom(this.p1TextField);
        topPane.add(leftInputPane);
        JPanel centerInputPane = GGraphicsFactory.getInstance().createImagePane("/images/Scale.png");
        topPane.add(centerInputPane);
        this.p2TextField = GGraphicsFactory.getInstance().createLabelInput(null);
        JPanel rightInputPane = GGraphicsFactory.getInstance().createContainerAdjustBottom(this.p2TextField);
        topPane.add(rightInputPane);
        this.getContentPane().add(topPane);
        this.factorInputPane = GGraphicsFactory.getInstance().createVariableInputPane(null, GDictionary.get("ScalingFactor", new String[0]));
        this.getContentPane().add(this.factorInputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    public void prefill(String pLabel1, String pLabel2) {
        logger.info((Object)(pLabel1 + ", " + pLabel2));
        this.p1TextField.setText(pLabel1);
        this.p2TextField.setText(pLabel2);
    }

    public void ok() {
        logger.info((Object)"");
        this.action.setInput(this.p1TextField.getText().trim(), this.p2TextField.getText().trim(), this.factorInputPane.getInput());
        try {
            this.action.validateApply();
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
    }

    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

