/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.geocentral.geometria.action.GRenameVariableAction;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GRenameVariableDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GRenameVariableAction action;
    private JComboBox oldNameInput;
    private JTextField newNameInput;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GRenameVariableDialog(Frame ownerFrame, GRenameVariableAction action, String[] variableNames) {
        super(ownerFrame, true);
        this.action = action;
        logger.info((Object)"");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents(variableNames);
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("RenameVariable", new String[0]));
    }

    private void layoutComponents(String[] variableNames) {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel inputPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Variables", new String[0]));
        inputPane.add(Box.createHorizontalGlue());
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        JPanel oldNamePane = new JPanel();
        oldNamePane.setLayout(new BoxLayout(oldNamePane, 0));
        JLabel label1 = new JLabel(GDictionary.get("OldVariable", new String[0]));
        oldNamePane.add(label1);
        oldNamePane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.oldNameInput = GGraphicsFactory.getInstance().createComboBox(variableNames);
        oldNamePane.add(this.oldNameInput);
        inputPane.add(oldNamePane);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel newNamePane = new JPanel();
        newNamePane.setLayout(new BoxLayout(newNamePane, 0));
        JLabel label2 = new JLabel(GDictionary.get("NewVariable", new String[0]));
        newNamePane.add(label2);
        newNamePane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.newNameInput = GGraphicsFactory.getInstance().createVariableInput(null);
        newNamePane.add(this.newNameInput);
        inputPane.add(newNamePane);
        inputPane.add(Box.createHorizontalGlue());
        this.getContentPane().add(inputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    public void prefill(String oldName) {
        logger.info((Object)oldName);
        if (oldName != null) {
            this.oldNameInput.setSelectedItem(oldName);
        }
    }

    public void ok() {
        logger.info((Object)"");
        this.action.setInput(this.oldNameInput.getSelectedItem().toString(), this.newNameInput.getText().trim());
        try {
            this.action.validateApply();
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
    }

    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

