/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import net.geocentral.geometria.action.GProblemAnswerAction;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionAnswer;
import net.geocentral.geometria.model.answer.GFixedPlaneAnswer;
import net.geocentral.geometria.model.answer.GNumberAnswer;
import net.geocentral.geometria.model.answer.GPointSetAnswer;
import net.geocentral.geometria.model.answer.condition.GCondition;
import net.geocentral.geometria.model.answer.condition.GEquilateralTriangleCondition;
import net.geocentral.geometria.model.answer.condition.GIsoscellesTriangleCondition;
import net.geocentral.geometria.model.answer.condition.GNotThroughLineCondition;
import net.geocentral.geometria.model.answer.condition.GNotThroughPointCondition;
import net.geocentral.geometria.model.answer.condition.GParallelToLineCondition;
import net.geocentral.geometria.model.answer.condition.GParallelToPlaneCondition;
import net.geocentral.geometria.model.answer.condition.GParallelogramCondition;
import net.geocentral.geometria.model.answer.condition.GPerpendicularToLineCondition;
import net.geocentral.geometria.model.answer.condition.GPerpendicularToPlaneCondition;
import net.geocentral.geometria.model.answer.condition.GRectangleCondition;
import net.geocentral.geometria.model.answer.condition.GRectangularTriangleCondition;
import net.geocentral.geometria.model.answer.condition.GRhombusCondition;
import net.geocentral.geometria.model.answer.condition.GSquareCondition;
import net.geocentral.geometria.model.answer.condition.GThroughLineCondition;
import net.geocentral.geometria.model.answer.condition.GThroughNoEdgeCondition;
import net.geocentral.geometria.model.answer.condition.GThroughNoVertexCondition;
import net.geocentral.geometria.model.answer.condition.GThroughPointCondition;
import net.geocentral.geometria.model.answer.condition.GVolumeCutInRatioCondition;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GPointSetFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GProblemAnswerDialog
extends JDialog
implements GHelpOkCancelDialog,
ActionListener {
    private int option = 1;
    private GProblem document;
    private JPanel valuePane;
    private JRadioButton numberButton;
    private JRadioButton pointSetButton;
    private JRadioButton fixedPlaneButton;
    private JRadioButton conditionButton;
    private JTextField numberTextField;
    private JTextField pointSetTextField;
    private JTextField[] conditionTextFields;
    private JComboBox[] conditionComboBoxes;
    private GCondition[][] conditionGroups = new GCondition[][]{{new GThroughPointCondition(), new GThroughLineCondition(), new GNotThroughPointCondition(), new GNotThroughLineCondition(), new GThroughNoVertexCondition(), new GThroughNoEdgeCondition(), new GParallelToLineCondition(), new GParallelToPlaneCondition(), new GPerpendicularToLineCondition(), new GPerpendicularToPlaneCondition()}, {new GVolumeCutInRatioCondition()}, {new GIsoscellesTriangleCondition(), new GRectangularTriangleCondition(), new GEquilateralTriangleCondition(), new GParallelogramCondition(), new GRhombusCondition(), new GRectangleCondition(), new GSquareCondition()}};
    private GAnswer answer;
    private GProblemAnswerAction action;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GProblemAnswerDialog(Frame ownerFrame, GProblemAnswerAction action, GProblem document) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.document = document;
        this.action = action;
        this.setDefaultCloseOperation(2);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("Answer", new String[0]));
        this.setResizable(true);
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(400, 320));
        this.getContentPane().add(tabbedPane);
        JPanel typePane = new JPanel();
        this.valuePane = new JPanel();
        tabbedPane.addTab(GDictionary.get("Type", new String[0]), typePane);
        tabbedPane.addTab(GDictionary.get("Value", new String[0]), this.valuePane);
        this.layoutTypePane(typePane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    private void layoutTypePane(JPanel typePane) {
        logger.info((Object)"");
        typePane.setLayout(new BoxLayout(typePane, 0));
        this.numberButton = new JRadioButton(GDictionary.get("Number", new String[0]));
        this.numberButton.addActionListener(this);
        this.pointSetButton = new JRadioButton(GDictionary.get("PointSet", new String[0]));
        this.pointSetButton.addActionListener(this);
        this.fixedPlaneButton = new JRadioButton(GDictionary.get("FixedPlane", new String[0]));
        this.fixedPlaneButton.addActionListener(this);
        this.conditionButton = new JRadioButton(GDictionary.get("ConditionPlane", new String[0]));
        this.conditionButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.numberButton);
        buttonGroup.add(this.pointSetButton);
        buttonGroup.add(this.fixedPlaneButton);
        buttonGroup.add(this.conditionButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.add(Box.createVerticalGlue());
        buttonPane.add(this.numberButton);
        buttonPane.add(this.pointSetButton);
        buttonPane.add(this.fixedPlaneButton);
        buttonPane.add(this.conditionButton);
        buttonPane.add(Box.createVerticalGlue());
        typePane.add(Box.createRigidArea(new Dimension(20, 20)));
        typePane.add(buttonPane);
        typePane.add(Box.createHorizontalGlue());
        GAnswer answer = this.document.getAnswer();
        if (answer instanceof GNumberAnswer) {
            this.numberButton.setSelected(true);
        } else if (answer instanceof GPointSetAnswer) {
            this.pointSetButton.setSelected(true);
        } else if (answer instanceof GFixedPlaneAnswer) {
            this.fixedPlaneButton.setSelected(true);
        } else if (answer instanceof GConditionAnswer) {
            this.conditionButton.setSelected(true);
        }
        this.layoutValuePane();
    }

    private void layoutValuePane() {
        logger.info((Object)"");
        this.valuePane.removeAll();
        if (this.numberButton.isSelected()) {
            this.layoutNumberValuePane();
        } else if (this.pointSetButton.isSelected()) {
            this.layoutPointSetValuePane();
        } else if (this.fixedPlaneButton.isSelected()) {
            this.layoutFixedPlaneValuePane();
        } else if (this.conditionButton.isSelected()) {
            this.layoutConditionValuePane();
        }
    }

    private void layoutNumberValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.numberTextField = GGraphicsFactory.getInstance().createAnswerInput(null);
        JPanel inputPane = this.layoutPane(GDictionary.get("Value", new String[0]), new JComponent[]{this.numberTextField});
        this.valuePane.add(inputPane);
        this.valuePane.add(Box.createVerticalGlue());
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GNumberAnswer && ((GNumberAnswer)ans).getValue() != null && ((GNumberAnswer)ans).getValue() != 0.0) {
            String stringValue = String.valueOf(((GNumberAnswer)ans).getValue());
            this.numberTextField.setText(stringValue);
        } else {
            GNotepadRecord record = this.document.getNotepad().getSelectedRecord();
            if (record != null) {
                String variableName = record.getVariable().getName();
                this.numberTextField.setText(variableName);
            }
        }
    }

    private void layoutPointSetValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.pointSetTextField = GGraphicsFactory.getInstance().createAnswerInput(null);
        JPanel inputPane = this.layoutPane(GDictionary.get("Points", new String[0]), new JComponent[]{this.pointSetTextField});
        this.valuePane.add(inputPane);
        this.valuePane.add(Box.createVerticalGlue());
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GPointSetAnswer) {
            Point3d[] coords = ((GPointSetAnswer)ans).getCoords();
            String valueString = coords == null ? "" : ans.toString();
            this.pointSetTextField.setText(valueString);
        } else {
            String[] selectedLabels = GPointSetFactory.getInstance().fromSelection(this.document);
            if (selectedLabels.length > 0) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < selectedLabels.length; ++i) {
                    buf.append(selectedLabels[i]);
                    if (i >= selectedLabels.length - 1) continue;
                    buf.append(",");
                }
                this.pointSetTextField.setText(String.valueOf(buf));
            }
        }
    }

    private void layoutFixedPlaneValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.pointSetTextField = GGraphicsFactory.getInstance().createAnswerInput(null);
        JPanel inputPane = this.layoutPane(GDictionary.get("ReferencePoints", new String[0]), new JComponent[]{this.pointSetTextField});
        this.valuePane.add(inputPane);
        this.valuePane.add(Box.createVerticalGlue());
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GFixedPlaneAnswer) {
            Point3d[] coords = ((GFixedPlaneAnswer)ans).getCoords();
            String valueString = coords == null ? "" : ans.toString();
            this.pointSetTextField.setText(valueString);
        } else {
            String[] selectedLabels = GPointSetFactory.getInstance().fromSelection(this.document);
            if (selectedLabels.length > 0) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < selectedLabels.length; ++i) {
                    buf.append(selectedLabels[i]);
                    if (i >= selectedLabels.length - 1) continue;
                    buf.append(",");
                }
                this.pointSetTextField.setText(String.valueOf(buf));
            }
        }
    }

    private void layoutConditionValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.conditionComboBoxes = new JComboBox[this.conditionGroups.length];
        this.conditionTextFields = new JTextField[this.conditionGroups.length];
        this.conditionTextFields[0] = GGraphicsFactory.getInstance().createAnswerInput(null);
        this.conditionTextFields[1] = GGraphicsFactory.getInstance().createAnswerInput(null);
        String[] captions = new String[]{GDictionary.get("Passes", new String[0]), GDictionary.get("Miscellaneous", new String[0]), GDictionary.get("SectionShapedLike", new String[0])};
        for (int i = 0; i < this.conditionGroups.length; ++i) {
            String[] labels = new String[this.conditionGroups[i].length + 1];
            labels[0] = "-- " + GDictionary.get("NotSelected", new String[0]) + " --";
            for (int j = 0; j < this.conditionGroups[i].length; ++j) {
                labels[j + 1] = this.conditionGroups[i][j].getDescription();
            }
            this.conditionComboBoxes[i] = GGraphicsFactory.getInstance().createComboBox(labels);
            JComponent[] components = this.conditionTextFields[i] == null ? new JComponent[]{this.conditionComboBoxes[i]} : new JComponent[]{this.conditionComboBoxes[i], this.conditionTextFields[i]};
            JPanel pane = this.layoutPane(captions[i], components);
            this.valuePane.add(pane);
            this.valuePane.add(Box.createVerticalGlue());
        }
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GConditionAnswer) {
            GCondition[] conditions = ((GConditionAnswer)ans).getConditions();
            for (int i = 0; i < conditions.length; ++i) {
                if (conditions[i] == null) continue;
                for (int j = 0; j < this.conditionGroups[i].length; ++j) {
                    if (!this.conditionGroups[i][j].getClass().equals(conditions[i].getClass())) continue;
                    this.conditionComboBoxes[i].setSelectedIndex(j + 1);
                    if (this.conditionTextFields[i] == null) continue;
                    String stringValue = conditions[i].getStringValue();
                    this.conditionTextFields[i].setText(stringValue);
                }
            }
        } else {
            String[] selectedLabels = GPointSetFactory.getInstance().fromSelection(this.document);
            if (selectedLabels.length > 0) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < selectedLabels.length; ++i) {
                    buf.append(selectedLabels[i]);
                    if (i >= selectedLabels.length - 1) continue;
                    buf.append(",");
                }
                this.conditionTextFields[0].setText(String.valueOf(buf));
            }
        }
    }

    private JPanel layoutPane(String caption, JComponent[] components) {
        Dimension padding = new Dimension(10, 10);
        JPanel pane = GGraphicsFactory.getInstance().createTitledBorderPane(caption);
        pane.setLayout(new BoxLayout(pane, 0));
        for (int i = 0; i < components.length; ++i) {
            pane.add(components[i]);
            if (i >= components.length - 1) continue;
            pane.add(Box.createRigidArea(padding));
        }
        return pane;
    }

    public void ok() {
        logger.info((Object)"");
        GAnswer ans = null;
        if (this.numberButton.isSelected()) {
            ans = new GNumberAnswer();
            try {
                ans.validateInput(this.numberTextField.getText().trim(), this.document);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                return;
            }
        }
        if (this.pointSetButton.isSelected()) {
            Point3d[] coords;
            try {
                GFigure figure = this.document.getSelectedFigure();
                coords = GPointSetFactory.getInstance().fromString(this.pointSetTextField.getText().trim(), figure);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                return;
            }
            if (coords.length < 1) {
                logger.info((Object)"No points");
                GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("EnterPoints", new String[0]));
                return;
            }
            ans = new GPointSetAnswer(coords);
        } else if (this.fixedPlaneButton.isSelected()) {
            Point3d[] coords;
            GFigure figure = this.document.getSelectedFigure();
            try {
                coords = GPointSetFactory.getInstance().fromString(this.pointSetTextField.getText().trim(), figure);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                return;
            }
            if (coords.length != 3) {
                GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("RefPlaneBy3Points", new String[0]));
                return;
            }
            if (GMath.areCollinear(coords, 1.0E-7)) {
                GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("RefPointsAreCollinear", new String[0]));
                return;
            }
            ans = new GFixedPlaneAnswer(coords);
        } else if (this.conditionButton.isSelected()) {
            GCondition[] conditions = new GCondition[this.conditionGroups.length];
            for (int i = 0; i < this.conditionGroups.length; ++i) {
                int j = this.conditionComboBoxes[i].getSelectedIndex();
                if (j <= 0) continue;
                conditions[i] = this.conditionGroups[i][j - 1];
                try {
                    String input = this.conditionTextFields[i] == null ? null : this.conditionTextFields[i].getText().trim();
                    conditions[i].validate(input, this.document);
                    continue;
                }
                catch (Exception exception) {
                    GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                    return;
                }
            }
            ans = new GConditionAnswer(conditions);
        }
        this.answer = ans;
        this.option = 0;
        this.dispose();
    }

    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    public int getOption() {
        return this.option;
    }

    public GAnswer getAnswer() {
        return this.answer;
    }

    public void actionPerformed(ActionEvent e) {
        this.layoutValuePane();
    }
}

