/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GExitAction;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.io.GFileWriter;
import net.geocentral.geometria.io.GLocalFileReader;
import net.geocentral.geometria.io.GLocalFileWriter;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GDragAndDropHandler;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GHelpManager;
import net.geocentral.geometria.util.GOptionsManager;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import net.geocentral.geometria.view.GContainer;
import net.geocentral.geometria.view.GMainPanel;
import net.geocentral.geometria.view.GMenuBar;
import org.apache.log4j.Logger;

public class GFrame
extends JFrame
implements GContainer {
    private GMainPanel mainPanel;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GFrame() {
        GVersionManager versionManager = GVersionManager.getInstance();
        logger.info((Object)String.format("Starting %s %s:%s", versionManager.getApplicationName(), versionManager.getApplicationVersion(), versionManager.getSvnRevision()));
        this.mainPanel = new GMainPanel();
        this.setDefaultCloseOperation(0);
    }

    public void load() throws Exception {
        GDictionary.init();
        GGraphicsFactory.getInstance().setFont();
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        documentHandler.setContainer(this);
        documentHandler.setMainPanel(this.mainPanel);
        documentHandler.init();
        GHelpManager.getInstance().init();
        GMenuBar menuBar = new GMenuBar();
        menuBar.loadMenus();
        this.setJMenuBar(menuBar);
        this.mainPanel.layoutComponents();
        this.layoutComponents();
        new GDragAndDropHandler().init((JComponent)this.getContentPane());
        documentHandler.documentChanged();
        this.repaint();
        this.validate();
        this.pack();
    }

    private void layoutComponents() throws Exception {
        logger.info((Object)"");
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        GGraphicsFactory.getInstance().layoutToolBars(this.getContentPane());
        this.getContentPane().add(this.mainPanel);
    }

    public GFileReader getFileReader(Frame ownerFrame, String filePath, FileFilter[] fileFilters, boolean acceptAllFilesFilter) {
        return new GLocalFileReader(ownerFrame, filePath, fileFilters, acceptAllFilesFilter);
    }

    public GFileWriter getFileWriter(Frame ownerFrame, String filePath, FileFilter[] fileFilters, boolean acceptAllFilesFilter) {
        return new GLocalFileWriter(ownerFrame, filePath, fileFilters, acceptAllFilesFilter);
    }

    public Frame getOwnerFrame() {
        return this;
    }

    public GMainPanel getMainPanel() {
        return this.mainPanel;
    }

    public void exit() {
        logger.info((Object)String.format("Exiting %s", GVersionManager.getInstance().getApplicationName()));
        GOptionsManager.getInstance().saveOptions();
        System.exit(0);
    }

    public static void main(String[] args) {
        logger.info((Object)"");
        GFrame frame = new GFrame();
        try {
            frame.load();
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            System.exit(0);
            return;
        }
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GExitAction action = new GExitAction();
                try {
                    action.execute();
                }
                catch (Exception exception) {
                    logger.error((Object)GStringUtils.stackTraceToString(exception));
                    System.exit(0);
                    return;
                }
            }
        });
        frame.setVisible(true);
    }
}

