/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.view.GMenuItem;

public class GFigurePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;

    public GFigurePopupMenu(GFigure figure) {
        this.init(figure);
    }

    private void init(GFigure figure) {
        GSelectable element2;
        GSelectable element1;
        Collection<GFace> faces;
        LinkedHashSet<String> viewGroup = new LinkedHashSet<String>();
        LinkedHashSet<String> measureGroup = new LinkedHashSet<String>();
        LinkedHashSet<String> drawGroup = new LinkedHashSet<String>();
        LinkedHashSet<String> transformGroup = new LinkedHashSet<String>();
        GSolid solid = figure.getSolid();
        Set<GSelectable> selection = solid.getSelection();
        viewGroup.add("view.toggleSelector");
        viewGroup.add("view.fitToView");
        viewGroup.add("view.initialAttitude");
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 1) {
            GSelectable element = it.next();
            if (element instanceof GPoint3d) {
                String pLabel = ((GPoint3d)element).getLabel();
                Collection<GFace> faces2 = solid.facesThroughPoint(pLabel);
                if (faces2.size() == 1) {
                    measureGroup.add("measure.area");
                }
            } else if (element instanceof GStick) {
                transformGroup.add("transform.scale");
                drawGroup.add("draw.drawMidpoint");
                drawGroup.add("draw.divideLine");
                measureGroup.add("measure.distance");
                String p1Label = ((GStick)element).label1;
                String p2Label = ((GStick)element).label2;
                faces = solid.facesThroughPoints(new String[]{p1Label, p2Label});
                if (faces.size() == 1) {
                    measureGroup.add("measure.area");
                }
            } else if (element instanceof GFace) {
                measureGroup.add("measure.area");
            }
        } else if (selection.size() == 2) {
            element1 = it.next();
            element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d) {
                transformGroup.add("transform.scale");
                String p1Label = ((GPoint3d)element1).getLabel();
                String p2Label = ((GPoint3d)element2).getLabel();
                Collection<GFace> faces3 = solid.facesThroughPoints(new String[]{p1Label, p2Label});
                if (!faces3.isEmpty()) {
                    drawGroup.add("draw.drawLine");
                    measureGroup.add("measure.distance");
                    if (faces3.size() == 1) {
                        measureGroup.add("measure.area");
                    }
                }
            } else if (element1 instanceof GStick && element2 instanceof GStick) {
                String[] labels = new String[]{((GStick)element1).label1, ((GStick)element1).label2, ((GStick)element2).label1, ((GStick)element2).label2};
                faces = solid.facesThroughPoints(labels);
                if (faces.isEmpty()) {
                    transformGroup.add("transform.cut");
                } else {
                    if (((GStick)element1).label1.equals(((GStick)element2).label1) || ((GStick)element1).label1.equals(((GStick)element2).label2) || ((GStick)element1).label2.equals(((GStick)element2).label1) || ((GStick)element1).label2.equals(((GStick)element2).label2)) {
                        measureGroup.add("measure.angle");
                        drawGroup.add("draw.drawBisector");
                        drawGroup.add("draw.divideAngle");
                    }
                    drawGroup.add("draw.intersectLines");
                    if (faces.size() == 1) {
                        measureGroup.add("measure.area");
                    }
                }
            } else if (element1 instanceof GPoint3d && element2 instanceof GStick || element2 instanceof GPoint3d && element1 instanceof GStick) {
                String[] labels;
                GStick s;
                String label;
                if (element1 instanceof GPoint3d && element2 instanceof GStick) {
                    label = ((GPoint3d)element1).getLabel();
                    s = (GStick)element2;
                    labels = new String[]{label, s.label1, s.label2};
                } else {
                    label = ((GPoint3d)element2).getLabel();
                    s = (GStick)element1;
                    labels = new String[]{label, s.label1, s.label2};
                }
                Collection<GFace> faces4 = solid.facesThroughPoints(labels);
                if (faces4.isEmpty()) {
                    transformGroup.add("transform.cut");
                } else {
                    drawGroup.add("draw.drawPerpendicular");
                    drawGroup.add("draw.layDistance");
                    if (label.equals(s.label1) || label.equals(s.label2)) {
                        drawGroup.add("draw.layAngle");
                    }
                    if (faces4.size() == 1) {
                        measureGroup.add("measure.area");
                    }
                }
            }
        } else if (selection.size() == 3) {
            element1 = it.next();
            element2 = it.next();
            GSelectable element3 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d && element3 instanceof GPoint3d) {
                String p3Label;
                String p2Label;
                String p1Label = ((GPoint3d)element1).getLabel();
                Collection<GFace> faces5 = solid.facesThroughPoints(new String[]{p1Label, p2Label = ((GPoint3d)element2).getLabel(), p3Label = ((GPoint3d)element3).getLabel()});
                if (faces5.size() == 1) {
                    measureGroup.add("measure.area");
                }
                if (faces5.isEmpty()) {
                    transformGroup.add("transform.cut");
                }
            }
        }
        for (String item : viewGroup) {
            this.addItem(item);
        }
        if (!drawGroup.isEmpty()) {
            this.addSeparator();
        }
        for (String item : drawGroup) {
            this.addItem(item);
        }
        if (!measureGroup.isEmpty()) {
            this.addSeparator();
        }
        for (String item : measureGroup) {
            this.addItem(item);
        }
        if (!transformGroup.isEmpty()) {
            this.addSeparator();
        }
        for (String item : transformGroup) {
            this.addItem(item);
        }
    }

    private void addItem(String actionHandlerName) {
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        AbstractAction actionHandler = documentHandler.getActionHandler(actionHandlerName);
        GMenuItem menuItem = new GMenuItem(actionHandler);
        menuItem.setText(String.valueOf(actionHandler.getValue("ShortDescription")));
        this.add(menuItem);
    }
}

