/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.geocentral.geometria.action.GEnvelopeAction;
import net.geocentral.geometria.model.GAuthor;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GEnvelopeDialog
extends JDialog
implements GHelpOkCancelDialog {
    private GDocument document;
    private GEnvelopeAction action;
    private JTextField authorNameTextField;
    private JTextField authorEmailTextField;
    private JTextField authorWebTextField;
    private JTextArea commentsTextArea;
    private int option = 1;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GEnvelopeDialog(Frame ownerFrame, GDocument document, GEnvelopeAction action) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.action = action;
        this.document = document;
        this.setDefaultCloseOperation(2);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("Envelope", new String[0]));
        this.setResizable(true);
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 1));
        inputPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel authorPane = this.layoutAuthorPane();
        inputPane.add(authorPane);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel commentsPane = this.layoutCommentsPane();
        inputPane.add(commentsPane);
        this.getContentPane().add(inputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    private JPanel layoutAuthorPane() {
        logger.info((Object)"");
        JPanel authorPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Author", new String[0]));
        authorPane.setLayout(new BoxLayout(authorPane, 0));
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 1));
        labelPane.add(new JLabel(GDictionary.get("Name", new String[0])));
        labelPane.add(Box.createVerticalGlue());
        labelPane.add(new JLabel(GDictionary.get("Email", new String[0])));
        labelPane.add(Box.createVerticalGlue());
        labelPane.add(new JLabel(GDictionary.get("Web", new String[0])));
        authorPane.add(labelPane);
        authorPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 1));
        this.authorNameTextField = GGraphicsFactory.getInstance().createAuthorInput(this.document.getEnvelope().getAuthor().getName());
        inputPane.add(this.authorNameTextField);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.authorEmailTextField = GGraphicsFactory.getInstance().createAuthorInput(this.document.getEnvelope().getAuthor().getEmail());
        inputPane.add(this.authorEmailTextField);
        inputPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.authorWebTextField = GGraphicsFactory.getInstance().createAuthorInput(this.document.getEnvelope().getAuthor().getWeb());
        inputPane.add(this.authorWebTextField);
        authorPane.add(inputPane);
        return authorPane;
    }

    private JPanel layoutCommentsPane() {
        logger.info((Object)"");
        JPanel commentsPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("Comments", new String[0]));
        commentsPane.setLayout(new BoxLayout(commentsPane, 0));
        this.commentsTextArea = GGraphicsFactory.getInstance().createCommentsArea(this.document.getEnvelope().getComments());
        this.commentsTextArea.setLineWrap(true);
        this.commentsTextArea.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(this.commentsTextArea);
        commentsPane.add(sp);
        return commentsPane;
    }

    public void ok() {
        logger.info((Object)"");
        String authorName = this.authorNameTextField.getText().trim();
        String authorEmail = this.authorEmailTextField.getText().trim();
        String authorWeb = this.authorWebTextField.getText().trim();
        GAuthor author = new GAuthor(authorName, authorEmail, authorWeb);
        String comments = this.commentsTextArea.getText().trim();
        GDocumentEnvelope envelope = new GDocumentEnvelope(author, comments);
        this.document.setEnvelope(envelope);
        this.dispose();
        this.option = 0;
    }

    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    public int getOption() {
        return this.option;
    }
}

