/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.geocentral.geometria.action.GAreaAction;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GValueInputPane;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GAreaDialog
extends JDialog
implements GHelpOkCancelDialog {
    private int option = 1;
    private GAreaAction action;
    private JList faceList;
    private GValueInputPane variableInputPane;
    private String[] fLabelStrings;
    private boolean result = false;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GAreaDialog(Frame ownerFrame, GAreaAction action, String[] faceLabelStrings) {
        super(ownerFrame, true);
        logger.info(Arrays.asList(faceLabelStrings));
        this.action = action;
        this.fLabelStrings = faceLabelStrings;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("MeasureArea", new String[0]));
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = GGraphicsFactory.getInstance().createTitledBorderPane(GDictionary.get("ChooseFace", new String[0]));
        this.faceList = new JList<String>(this.fLabelStrings);
        this.faceList.setSelectedIndex(0);
        JScrollPane sp = new JScrollPane(this.faceList);
        sp.setPreferredSize(new Dimension(80, 80));
        topPane.add(sp);
        this.getContentPane().add(topPane);
        this.variableInputPane = GGraphicsFactory.getInstance().createVariableInputPane(null, GDictionary.get("AssignVariable", new String[0]));
        this.getContentPane().add(this.variableInputPane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    public void prefill(String fLabelsString) {
        logger.info((Object)fLabelsString);
        this.faceList.setSelectedValue(fLabelsString, true);
    }

    public void ok() {
        logger.info((Object)"");
        String faceLabelsString = String.valueOf(this.faceList.getSelectedValue());
        this.action.setInput(faceLabelsString, this.variableInputPane.getInput());
        try {
            this.action.validateApply();
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
            return;
        }
        this.option = 0;
        this.result = true;
        this.dispose();
    }

    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    public int getOption() {
        return this.option;
    }

    public boolean getResult() {
        return this.result;
    }
}

