/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.geocentral.geometria.converter.GConverter;
import net.geocentral.geometria.model.GOptions;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import net.geocentral.geometria.util.NotAGeometriaFileException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GXmlUtils {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public static GSolid readSolid(InputSource source) throws Exception {
        return (GSolid)GXmlUtils.readXmlEntity(source, XmlEntityType.SOLID);
    }

    public static GProblem readProblem(InputSource source) throws Exception {
        return (GProblem)GXmlUtils.readXmlEntity(source, XmlEntityType.PROBLEM);
    }

    public static GSolution readSolution(InputSource source) throws Exception {
        return (GSolution)GXmlUtils.readXmlEntity(source, XmlEntityType.SOLUTION);
    }

    public static GOptions readOptions(InputSource source) throws Exception {
        return (GOptions)GXmlUtils.readXmlEntity(source, XmlEntityType.OPTIONS);
    }

    public static GXmlEntity readXmlEntity(InputSource source) throws Exception {
        return GXmlUtils.readXmlEntity(source, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GXmlEntity readXmlEntity(InputSource source, XmlEntityType targetType) throws Exception {
        GXmlEntity xmlEntity;
        GVersionManager versionManager;
        String version;
        String nodeName;
        Element docElement;
        block41: {
            block42: {
                block43: {
                    try {
                        docElement = GXmlUtils.read(source);
                    }
                    catch (SAXException exception) {
                        logger.error((Object)GStringUtils.stackTraceToString(exception));
                        throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
                    }
                    nodeName = docElement.getNodeName();
                    NodeList nodes = docElement.getElementsByTagName("version");
                    if (nodes.getLength() < 1) {
                        logger.error((Object)"No version");
                        throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
                    }
                    version = nodes.item(0).getTextContent();
                    versionManager = GVersionManager.getInstance();
                    if (!versionManager.versionExists(version)) {
                        logger.error((Object)String.format("Unknown version %s", version));
                        throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
                    }
                    xmlEntity = null;
                    if (targetType != null) break block42;
                    if (!"solid".equals(nodeName)) break block43;
                    xmlEntity = new GSolid();
                    break block41;
                }
                if ("problem".equals(nodeName)) {
                    xmlEntity = new GProblem();
                    break block41;
                } else if ("solution".equals(nodeName)) {
                    xmlEntity = new GSolution();
                    break block41;
                } else {
                    if (!"options".equals(nodeName)) {
                        logger.error((Object)String.format("Unrecognized root element: %s", nodeName));
                        throw new NotAGeometriaFileException();
                    }
                    xmlEntity = new GOptions();
                }
                break block41;
            }
            switch (targetType) {
                case SOLID: {
                    if ("solid".equals(nodeName)) {
                        xmlEntity = new GSolid();
                        break;
                    }
                    if ("problem".equals(nodeName)) {
                        logger.error((Object)"Problem file, open figure");
                        throw new Exception(GDictionary.get("FileContainsProblemFigure", new String[0]));
                    }
                    if ("solution".equals(nodeName)) {
                        logger.error((Object)"Solution file, open figure");
                        throw new Exception(GDictionary.get("FileContainsSolutionFigure", new String[0]));
                    }
                    if ("options".equals(nodeName)) {
                        logger.error((Object)"Options file, open figure");
                        throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
                    }
                    logger.error((Object)String.format("Unrecognized root element: %s", nodeName));
                    throw new NotAGeometriaFileException();
                }
                case PROBLEM: {
                    if ("problem".equals(nodeName)) {
                        xmlEntity = new GProblem();
                        break;
                    }
                    if ("solid".equals(nodeName)) {
                        logger.error((Object)"Figure file, open problem");
                        throw new Exception(GDictionary.get("FileContainsFigureProblem", new String[0]));
                    }
                    if ("solution".equals(nodeName)) {
                        logger.error((Object)"Solution file, open problem");
                        throw new Exception(GDictionary.get("FileContainsSolutionProblem", new String[0]));
                    }
                    if ("options".equals(nodeName)) {
                        logger.error((Object)"Options file, open problem");
                        throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
                    }
                    logger.error((Object)String.format("Unrecognized root element: %s", nodeName));
                    throw new NotAGeometriaFileException();
                }
                case SOLUTION: {
                    if ("solution".equals(nodeName)) {
                        xmlEntity = new GSolution();
                        break;
                    }
                    if ("solid".equals(nodeName)) {
                        logger.error((Object)"Figure file, open solution");
                        throw new Exception(GDictionary.get("FileContainsFigureSolution", new String[0]));
                    }
                    if ("problem".equals(nodeName)) {
                        logger.error((Object)"Problem file, open solution");
                        throw new Exception(GDictionary.get("FileContainsProblemSolution", new String[0]));
                    }
                    if ("options".equals(nodeName)) {
                        logger.error((Object)"Options file, open solution");
                        throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
                    }
                    logger.error((Object)String.format("Unrecognized root element: %s", nodeName));
                    throw new NotAGeometriaFileException();
                }
                case OPTIONS: {
                    if ("options".equals(nodeName)) {
                        xmlEntity = new GOptions();
                        break;
                    }
                    if ("solid".equals(nodeName)) {
                        logger.error((Object)"Figure file, open options");
                    }
                    if ("problem".equals(nodeName)) {
                        logger.error((Object)"Problem file, open options");
                    }
                    if ("solution".equals(nodeName)) {
                        logger.error((Object)"Solution file, open options");
                        throw new Exception();
                    }
                    logger.error((Object)String.format("Unrecognized root element: %s", nodeName));
                    throw new NotAGeometriaFileException();
                }
            }
        }
        String schemaFile = xmlEntity.getSchemaFile(version);
        logger.info((Object)String.format("Schema file %s", schemaFile));
        try {
            GXmlUtils.validate(docElement, schemaFile);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
        }
        String applicationVersion = versionManager.getApplicationVersion();
        if (version.compareTo(applicationVersion) > 0) {
            logger.error((Object)String.format("File version %s, application version %s", version, applicationVersion));
            throw new Exception(GDictionary.get("UnsupportedFileVersion", version));
        }
        if (version.compareTo(applicationVersion) < 0) {
            logger.warn((Object)String.format("Converting file from %s to %s", version, applicationVersion));
            try {
                GConverter converter = new GConverter();
                if ("problem".equals(nodeName)) {
                    docElement = converter.convertProblem(docElement);
                }
                if ("solution".equals(nodeName)) {
                    docElement = converter.convertSolution(docElement);
                }
            }
            catch (Exception exception) {
                logger.error((Object)GStringUtils.stackTraceToString(exception));
                throw new Exception(GDictionary.get("CannotConvertFile", version, applicationVersion));
            }
        }
        try {
            xmlEntity.make(docElement);
            return xmlEntity;
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
        }
    }

    public static Element read(InputStream in) throws Exception {
        logger.info((Object)"");
        InputSource source = new InputSource(in);
        return GXmlUtils.read(source);
    }

    private static Element read(InputSource source) throws Exception {
        logger.info((Object)"");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        try {
            return builder.parse(source).getDocumentElement();
        }
        catch (SAXException exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            throw new Exception(GDictionary.get("FileCorruptedSeeLog", new String[0]));
        }
    }

    private static void validate(Element docElement, String schemaFile) throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        LSResourceResolver resourceResolver = GXmlUtils.getLSResourceResolver();
        sf.setResourceResolver(resourceResolver);
        InputStream in = GXmlUtils.class.getResourceAsStream(schemaFile);
        StreamSource schemaSource = new StreamSource(in);
        Schema schema = sf.newSchema(schemaSource);
        in.close();
        DOMSource source = new DOMSource(docElement);
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    private static LSResourceResolver getLSResourceResolver() throws Exception {
        logger.info((Object)"");
        LSResourceResolver resourceResolver = new LSResourceResolver(){

            public LSInput resolveResource(String type, String namespaceUri, String publicId, String systemId, String baseUri) {
                try {
                    InputStream in = GXmlEntity.class.getResource("/" + systemId).openStream();
                    LSInputAdapter adapter = new LSInputAdapter(in);
                    return adapter;
                }
                catch (Exception exception) {
                    logger.error((Object)GStringUtils.stackTraceToString(exception));
                    return null;
                }
            }
        };
        return resourceResolver;
    }

    static class LSInputAdapter
    implements LSInput {
        private InputStream in;

        public LSInputAdapter(InputStream in) {
            this.in = in;
        }

        public InputStream getByteStream() {
            return this.in;
        }

        public String getBaseURI() {
            return null;
        }

        public boolean getCertifiedText() {
            return false;
        }

        public Reader getCharacterStream() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public String getPublicId() {
            return null;
        }

        public String getStringData() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public void setBaseURI(String baseURI) {
        }

        public void setByteStream(InputStream byteStream) {
        }

        public void setCertifiedText(boolean certifiedText) {
        }

        public void setCharacterStream(Reader characterStream) {
        }

        public void setEncoding(String encoding) {
        }

        public void setPublicId(String publicId) {
        }

        public void setStringData(String stringData) {
        }

        public void setSystemId(String systemId) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlEntityType {
        SOLID,
        PROBLEM,
        SOLUTION,
        OPTIONS;

    }
}

