/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.geocentral.geometria.util.GVersionHistoryItem;
import net.geocentral.geometria.util.GXmlUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GVersionManager {
    private static final String FILE = "/conf/versions.xml";
    private String vendor = "http://geocentral.net/geometria";
    private String applicationName = "Geometria";
    private String applicationVersion = "3.1";
    private String svnRevision = "Unknown";
    private Map<String, GVersionHistoryItem> versionHistory;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static GVersionManager instance;

    private GVersionManager() {
        this.loadVersionHistory();
        this.loadApplicationData();
    }

    public static GVersionManager getInstance() {
        if (instance == null) {
            instance = new GVersionManager();
        }
        return instance;
    }

    private void loadVersionHistory() {
        this.versionHistory = new HashMap<String, GVersionHistoryItem>();
        InputStream in = GVersionManager.class.getResourceAsStream(FILE);
        Element docElement = null;
        try {
            docElement = GXmlUtils.read(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NodeList nodes = docElement.getElementsByTagName("version");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            GVersionHistoryItem versionHistoryItem = new GVersionHistoryItem();
            versionHistoryItem.make(node);
            String version = versionHistoryItem.getVersion();
            this.versionHistory.put(version, versionHistoryItem);
        }
    }

    private void loadApplicationData() {
        logger.info((Object)"");
        Package p = GVersionManager.class.getPackage();
        String s = p.getSpecificationVendor();
        this.vendor = s != null ? s : this.vendor;
        s = p.getSpecificationTitle();
        this.applicationName = s != null ? s : this.applicationName;
        s = p.getSpecificationVersion();
        this.applicationVersion = s != null ? s : this.applicationVersion;
        s = p.getImplementationVersion();
        this.svnRevision = s != null ? s : this.svnRevision;
    }

    public boolean versionExists(String version) {
        return this.versionHistory.containsKey(version);
    }

    public String getSolidSchema(String version) {
        return this.versionHistory.get(version).getSolidSchema();
    }

    public String getProblemSchema(String version) {
        return this.versionHistory.get(version).getProblemSchema();
    }

    public String getSolutionSchema(String version) {
        return this.versionHistory.get(version).getSolutionSchema();
    }

    public String getOptionsSchema(String version) {
        return this.versionHistory.get(version).getOptionsSchema();
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getSvnRevision() {
        return this.svnRevision;
    }
}

