/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.geocentral.geometria.util.GDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GValidateDictionaryReferences {
    public static final Pattern PATTERN = Pattern.compile(GDictionary.class.getSimpleName() + ".get\\(\"(.*?)\"");
    public static final String[] LANGUAGES = new String[]{"en"};

    public static void main(String[] args) throws Exception {
        String src = args[0];
        File file = new File(src);
        for (String language : LANGUAGES) {
            System.out.println("Validating dictionary for " + language);
            Map<String, String> dictionary = GValidateDictionaryReferences.getDictionary(language);
            GValidateDictionaryReferences.validateSources(file, dictionary, language);
        }
        System.out.println("Done validating dictionaries.");
    }

    private static Map<String, String> getDictionary(String language) throws Exception {
        String line;
        TreeMap<String, String> dictionary = new TreeMap<String, String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(GDictionary.class.getResourceAsStream("/dictionary/" + language + "/dictionary.txt")));
        while ((line = in.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            int pos = line.indexOf(61);
            String key = line.substring(0, pos).trim();
            String value = new String(line.substring(pos + 1).trim().getBytes(), "UTF-8");
            dictionary.put(key, value);
        }
        return dictionary;
    }

    private static void validateSources(File file, Map<String, String> dictionary, String language) throws Exception {
        String line;
        if (file.isDirectory()) {
            String[] fs;
            for (String f : fs = file.list()) {
                GValidateDictionaryReferences.validateSources(new File(file, f), dictionary, language);
            }
            return;
        }
        if (!file.getName().endsWith(".java")) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            buf.append(line);
        }
        in.close();
        String text = String.valueOf(buf).replaceAll("\\s+", "");
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (dictionary.containsKey(key)) continue;
            System.out.println(file.getName() + ": Missing " + language.toUpperCase() + " dictionary entry for key " + key);
        }
    }
}

