/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;

public class GStringUtils {
    public static final Pattern COORDS_PATTERN = Pattern.compile("\\s*([0-9\\+\\-\\.E]+)\\s+([0-9\\+\\-\\.E]+)\\s+([0-9\\+\\-\\.E]+)\\s*");

    public static Point3d coordsFromString(String stringCoords) {
        Matcher matcher = COORDS_PATTERN.matcher(stringCoords);
        if (!matcher.matches()) {
            return null;
        }
        try {
            double x = Double.valueOf(matcher.group(1));
            double y = Double.valueOf(matcher.group(2));
            double z = Double.valueOf(matcher.group(3));
            return new Point3d(x, y, z);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String coordsToString(Point3d coords) {
        return GStringUtils.coordsToString(coords, false);
    }

    public static String coordsToString(Point3d coords, boolean bracket) {
        StringBuffer buf = new StringBuffer();
        if (bracket) {
            buf.append('[');
        }
        buf.append(coords.x).append(' ').append(coords.y).append(' ').append(coords.z);
        if (bracket) {
            buf.append(']');
        }
        return String.valueOf(buf);
    }

    public static String stackTraceToString(Exception exception) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        exception.printStackTrace(out);
        return ((Object)writer).toString();
    }

    public static String fromXml(String str) {
        str = str.replace("&lt;", "<");
        str = str.replace("&gt;", ">");
        str = str.replace("&quot;", "\"");
        str = str.replace("&#39;", "'");
        str = str.replace("&amp;", "&");
        return str;
    }

    public static String toXml(String str) {
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\"", "&quot;");
        str = str.replace("'", "&#39;");
        return str;
    }
}

