/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSphere {
    private Point3d center;
    private double radius;

    public GSphere() {
        this.center = new Point3d();
    }

    public GSphere(Point3d p1) {
        this.center = new Point3d();
        this.center.set((Tuple3d)p1);
        this.radius = 0.0;
    }

    public GSphere(Point3d p1, Point3d p2) {
        this.center = new Point3d();
        this.center.add((Tuple3d)p1, (Tuple3d)p2);
        this.center.scale(0.5);
        this.radius = this.center.distance(p1);
    }

    public GSphere(Point3d p1, Point3d p2, Point3d p3) {
        Vector3d a = new Vector3d();
        a.sub((Tuple3d)p2, (Tuple3d)p1);
        Vector3d b = new Vector3d();
        b.sub((Tuple3d)p3, (Tuple3d)p1);
        Vector3d ab = new Vector3d();
        ab.cross(a, b);
        double denominator = 2.0 * ab.dot(ab);
        Vector3d aba = new Vector3d();
        aba.cross(ab, a);
        Vector3d bab = new Vector3d();
        bab.cross(b, ab);
        aba.scale(b.dot(b));
        bab.scale(a.dot(a));
        Vector3d o = new Vector3d();
        o.add((Tuple3d)aba, (Tuple3d)bab);
        o.scale(1.0 / denominator);
        this.center = new Point3d();
        this.center.add((Tuple3d)p1, (Tuple3d)o);
        this.radius = this.center.distance(p1);
    }

    public GSphere(Point3d p1, Point3d p2, Point3d p3, Point3d p4) {
        this.center = new Point3d();
        this.radius = 1000.0;
    }

    public GSphere(List<Point3d> points) {
        this.center = new Point3d();
        GSphere sphere = this.seb(points, 0, points.size(), 0);
        this.center.set((Tuple3d)sphere.center);
        this.radius = sphere.radius;
    }

    private GSphere seb(List<Point3d> points, int inStartIndex, int inPointCount, int onPointCount) {
        GSphere sphere = new GSphere();
        switch (onPointCount) {
            case 1: {
                sphere = new GSphere(points.get(inStartIndex - 1));
                break;
            }
            case 2: {
                sphere = new GSphere(points.get(inStartIndex - 1), points.get(inStartIndex - 2));
                break;
            }
            case 3: {
                sphere = new GSphere(points.get(inStartIndex - 1), points.get(inStartIndex - 2), points.get(inStartIndex - 3));
                break;
            }
            case 4: {
                sphere = new GSphere(points.get(inStartIndex - 1), points.get(inStartIndex - 2), points.get(inStartIndex - 3), points.get(inStartIndex - 4));
                return sphere;
            }
        }
        for (int i = 0; i < inPointCount; ++i) {
            if (!(sphere.distance(points.get(inStartIndex + i)) > 0.0)) continue;
            Point3d p = points.remove(inStartIndex + i);
            points.add(inStartIndex, p);
            sphere = this.seb(points, inStartIndex + 1, i, onPointCount + 1);
        }
        return sphere;
    }

    public double distance(Point3d p) {
        double d = this.center.distance(p);
        return d > this.radius ? d - this.radius : 0.0;
    }

    public Point3d getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }
}

