/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.evaluator.GEvaluator;
import net.geocentral.geometria.model.GNotepadVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMath {
    public static final int NEGATIVE = 0;
    public static final int POSITIVE = 1;
    public static final int UNDEFINED = 2;
    public static final double EPSILON = 1.0E-7;

    public static Double evaluate(String expression) {
        return GMath.evaluate(expression, null);
    }

    public static Double evaluate(String expression, List<GNotepadVariable> variables) {
        double value;
        GEvaluator evaluator = new GEvaluator(variables);
        try {
            value = evaluator.evaluate(expression);
        }
        catch (Exception exception) {
            return null;
        }
        return value;
    }

    public static boolean areCooriented(Vector3d v1, Vector3d v2, double epsilon) {
        double v1Length = v1.length();
        if (v1Length < epsilon) {
            return true;
        }
        Vector3d v = new Vector3d(v1);
        v.scale(v2.length() / v1Length);
        return v.epsilonEquals((Tuple3d)v2, epsilon);
    }

    public static boolean areCollinear(Vector3d v1, Vector3d v2, double epsilon) {
        Vector3d v = new Vector3d();
        v.cross(v1, v2);
        return v.length() < epsilon;
    }

    public static boolean areCollinear(Point3d[] ps, double epsilon) {
        for (int i = 0; i < ps.length - 2; ++i) {
            if (ps[i].epsilonEquals((Tuple3d)ps[i + 1], epsilon)) continue;
            Vector3d v = new Vector3d((Tuple3d)ps[i + 1]);
            v.sub((Tuple3d)ps[i]);
            return GMath.areCollinear(ps, i + 1, v, epsilon);
        }
        return true;
    }

    private static boolean areCollinear(Point3d[] ps, int index, Vector3d v, double epsilon) {
        for (int i = index; i < ps.length - 1; ++i) {
            Vector3d vi = new Vector3d((Tuple3d)ps[i + 1]);
            vi.sub((Tuple3d)ps[i]);
            if (GMath.areCollinear(vi, v, epsilon)) continue;
            return false;
        }
        return true;
    }

    public static Point3d intersect(Point3d p11, Point3d p12, Point3d p21, Point3d p22, double epsilon) {
        Vector3d v1 = new Vector3d();
        v1.sub((Tuple3d)p12, (Tuple3d)p11);
        Vector3d v2 = new Vector3d();
        v2.sub((Tuple3d)p22, (Tuple3d)p21);
        if (GMath.areCollinear(v1, v2, epsilon)) {
            return null;
        }
        double k = v1.x * v2.y - v1.y * v2.x;
        double t = Math.abs(k) / v1.length() * v2.length() > 1.0E-7 ? (v2.y * (p21.x - p11.x) - v2.x * (p21.y - p11.y)) / k : (Math.abs(k = v1.y * v2.z - v1.z * v2.y) / v1.length() * v2.length() > 1.0E-7 ? (v2.z * (p21.y - p11.y) - v2.y * (p21.z - p11.z)) / k : (v2.x * (p21.z - p11.z) - v2.z * (p21.x - p11.x)) / (v1.z * v2.x - v1.x * v2.z));
        return new Point3d(p11.x + v1.x * t, p11.y + v1.y * t, p11.z + v1.z * t);
    }

    public static Vector3d cross(Point3d p1, Point3d p2, Point3d p3) {
        Vector3d v1 = new Vector3d();
        v1.sub((Tuple3d)p2, (Tuple3d)p1);
        Vector3d v2 = new Vector3d();
        v2.sub((Tuple3d)p3, (Tuple3d)p1);
        Vector3d v = new Vector3d();
        v.cross(v1, v2);
        return v;
    }

    public static Point3d project(Point3d p, Point3d p1, Point3d p2) {
        Vector3d p1p = new Vector3d();
        p1p.sub((Tuple3d)p, (Tuple3d)p1);
        Vector3d p1p2 = new Vector3d();
        p1p2.sub((Tuple3d)p2, (Tuple3d)p1);
        double k = p1p.dot(p1p2) / p1p2.lengthSquared();
        Point3d projection = new Point3d();
        projection.add((Tuple3d)p2);
        projection.sub((Tuple3d)p1);
        projection.scale(k);
        projection.add((Tuple3d)p1);
        return projection;
    }

    public static double simpleRatio(Point3d p1, Point3d p2, Point3d p) {
        Vector3d v1 = new Vector3d();
        v1.sub((Tuple3d)p, (Tuple3d)p1);
        Vector3d v2 = new Vector3d();
        v2.sub((Tuple3d)p2, (Tuple3d)p);
        double k = v1.length() / v2.length();
        return v1.dot(v2) > 0.0 ? k : -k;
    }

    public static boolean isBetween(Point3d p, Point3d p1, Point3d p2, double epsilon) {
        return p.epsilonEquals((Tuple3d)p1, epsilon) || p.epsilonEquals((Tuple3d)p2, epsilon) || GMath.areCollinear(new Point3d[]{p, p1, p2}, epsilon) && GMath.simpleRatio(p1, p2, p) > 0.0;
    }

    public static boolean isStrictlyBetween(Point3d p, Point3d p1, Point3d p2, double epsilon) {
        return GMath.areCollinear(new Point3d[]{p, p1, p2}, epsilon) && GMath.simpleRatio(p1, p2, p) > 0.0;
    }

    public static Vector3d divideAngle(Point3d p0, Point3d p1, Point3d p2, double k) {
        Vector3d v1 = new Vector3d((Tuple3d)p1);
        v1.sub((Tuple3d)p0);
        v1.normalize();
        Vector3d v2 = new Vector3d((Tuple3d)p2);
        v2.sub((Tuple3d)p0);
        v2.normalize();
        double phi = Math.acos(v1.dot(v2));
        Vector3d v = new Vector3d(v2);
        v.sub((Tuple3d)v1);
        v.scale(0.5 * (1.0 - Math.tan(0.5 * phi * (1.0 - k) / (1.0 + k)) / Math.tan(phi / 2.0)));
        v.add((Tuple3d)v1);
        return v;
    }

    public static List<Point3d> intersectSphere(Point3d p1, Point3d p2, Point3d c, double r) {
        ArrayList<Point3d> ps = new ArrayList<Point3d>();
        ArrayList<Double> ts = new ArrayList<Double>();
        Vector3d v12 = new Vector3d((Tuple3d)p2);
        v12.sub((Tuple3d)p1);
        Vector3d v1c = new Vector3d((Tuple3d)p1);
        v1c.sub((Tuple3d)c);
        double k = v12.lengthSquared();
        double m = v12.dot(v1c);
        double n = v1c.lengthSquared() - r * r;
        double d = m * m - k * n;
        if (d / (m * m) < -1.0E-7) {
            return ps;
        }
        if (d / (m * m) < 1.0E-7) {
            ts.add(-m / k);
        } else {
            double srd = Math.sqrt(d);
            ts.add((-m - srd) / k);
            ts.add((-m + srd) / k);
        }
        Iterator i$ = ts.iterator();
        while (i$.hasNext()) {
            double t = (Double)i$.next();
            if (!(t < 1.0000001) || !(t > -1.0E-7)) continue;
            Point3d p = new Point3d(p1);
            Vector3d sv12 = new Vector3d(v12);
            sv12.scale(t);
            p.add((Tuple3d)sv12);
            ps.add(p);
        }
        return ps;
    }

    public static double distanceToPlane(Point3d p0, Point3d p1, Point3d p2, Point3d p3) {
        Vector3d n = GMath.cross(p1, p2, p3);
        Vector3d v = new Vector3d((Tuple3d)p0);
        v.sub((Tuple3d)p1);
        double distance = Math.abs(v.dot(n)) / n.length();
        return distance;
    }

    public static double area(Point3d p1, Point3d p2, Point3d p3) {
        return 0.5 * GMath.cross(p1, p2, p3).length();
    }

    public static Point3d intersectPlane(Point3d p1, Point3d p2, Point3d p0, Vector3d n) {
        Vector3d p1p2 = new Vector3d((Tuple3d)p2);
        p1p2.sub((Tuple3d)p1);
        double p1p2n = p1p2.dot(n);
        if (Math.abs(p1p2n / (p1p2.length() * n.length())) < 1.0E-7) {
            return null;
        }
        double t = (n.x * (p0.x - p1.x) + n.y * (p0.y - p1.y) + n.z * (p0.z - p1.z)) / p1p2n;
        if (t < 1.0000001 && t > -1.0E-7) {
            p1p2.scale(t);
            Point3d p = new Point3d(p1);
            p.add((Tuple3d)p1p2);
            return p;
        }
        return null;
    }

    public static boolean isInPlane(Point3d p, Point3d p0, Vector3d n) {
        Vector3d p0p = new Vector3d((Tuple3d)p);
        p0p.sub((Tuple3d)p0);
        if (p0p.length() / n.length() < 1.0E-7) {
            return true;
        }
        return Math.abs(p0p.dot(n) / (p0p.length() * n.length())) < 1.0E-7;
    }

    public static Vector3d[] layAngle(Vector3d v, Vector3d n, double angle) {
        double lv = v.length();
        double k = lv * Math.cos(angle);
        Vector3d[] u = new Vector3d[2];
        double d = v.x * n.y - v.y * n.x;
        if (Math.abs(d / (lv * n.length())) > 1.0E-7) {
            u = GMath.solve(v, n, k);
        } else {
            d = v.y * n.z - v.z * n.y;
            if (Math.abs(d / (lv * n.length())) > 1.0E-7) {
                Vector3d vyzx = new Vector3d(v.y, v.z, v.x);
                Vector3d nyzx = new Vector3d(n.y, n.z, n.x);
                u = GMath.solve(vyzx, nyzx, k);
                u[0] = new Vector3d(u[0].z, u[0].x, u[0].y);
                u[1] = new Vector3d(u[1].z, u[1].x, u[1].y);
            } else {
                d = v.x * n.z - v.z * n.x;
                Vector3d vxzy = new Vector3d(v.x, v.z, v.y);
                Vector3d nxzy = new Vector3d(n.x, n.z, n.y);
                u = GMath.solve(vxzy, nxzy, k);
                u[0] = new Vector3d(u[0].x, u[0].z, u[0].y);
                u[1] = new Vector3d(u[1].x, u[1].z, u[1].y);
            }
        }
        return u;
    }

    private static Vector3d[] solve(Vector3d v, Vector3d n, double k) {
        double d = v.x * n.y - v.y * n.x;
        double r1 = v.z * n.y - v.y * n.z;
        double r2 = v.z * n.x - v.x * n.z;
        double a = r1 * r1 + r2 * r2 + d * d;
        double b = r1 * k * n.y + r2 * k * n.x;
        double c = k * k * (n.x * n.x + n.y * n.y) - d * d;
        double m = Math.sqrt(b * b - a * c);
        double[] z = new double[]{(b + m) / a, (b - m) / a};
        Vector3d[] u = new Vector3d[2];
        for (int i = 0; i < 2; ++i) {
            double x = (k * n.y - z[i] * r1) / d;
            double y = (-k * n.x + z[i] * r2) / d;
            u[i] = new Vector3d(x, y, z[i]);
        }
        return u;
    }

    public static Point3d scale(Point3d p, Point3d p0, Vector3d n, double factor) {
        double pn = p.x * n.x + p.y * n.y + p.z * n.z;
        double n2 = n.lengthSquared();
        Vector3d sn = new Vector3d(n);
        sn.scale(pn / n2 * (factor - 1.0));
        Point3d sp = new Point3d(p);
        sp.add((Tuple3d)sn);
        return sp;
    }

    public static Point3d shear(Point3d p, Point3d p0, Vector3d v1, Vector3d v2) {
        Vector3d v3 = new Vector3d(v1);
        v3.scale(-v1.dot(v2) / v1.lengthSquared());
        v3.add((Tuple3d)v2);
        Vector3d r = new Vector3d((Tuple3d)p);
        r.sub((Tuple3d)p0);
        double m = r.dot(v3) / v3.lengthSquared();
        Vector3d w = new Vector3d(v2);
        w.sub((Tuple3d)v3);
        w.scale(m);
        Point3d s = new Point3d(p);
        s.add((Tuple3d)w);
        return s;
    }

    public static Point3d undoShear(Point3d p, Point3d p0, Vector3d v1, Vector3d v2) {
        Vector3d v3 = new Vector3d(v1);
        v3.scale(-v1.dot(v2) / v1.lengthSquared());
        v3.add((Tuple3d)v2);
        Vector3d v4 = new Vector3d(v3);
        v4.scale(2.0);
        v4.sub((Tuple3d)v2);
        Vector3d v5 = new Vector3d(v1);
        v5.scale(-1.0);
        return GMath.shear(p, p0, v5, v4);
    }

    public static List<Integer> matchCircular(List<Double> list1, List<Double> list2, boolean flipList2, double epsilon) {
        ArrayList<Integer> matchIndexes = new ArrayList<Integer>();
        int size = list1.size();
        if (list2.size() != size) {
            return matchIndexes;
        }
        for (int i1 = 0; i1 < size; ++i1) {
            boolean goodI1 = true;
            for (int i2 = 0; i2 < size; ++i2) {
                boolean match;
                if (!flipList2) {
                    match = Math.abs(list2.get(i2) - list1.get((i1 + i2) % size)) < epsilon;
                } else {
                    boolean bl = match = Math.abs(list2.get((size - i2 - 1) % size) - list1.get((i1 + i2) % size)) < epsilon;
                }
                if (match) continue;
                goodI1 = false;
                break;
            }
            if (!goodI1) continue;
            matchIndexes.add(i1);
        }
        return matchIndexes;
    }

    public static void orthize(Vector3d v1, Vector3d v2) {
        v1.normalize();
        Vector3d v = new Vector3d(v1);
        v.scale(v1.dot(v2));
        v.sub((Tuple3d)v2);
        v.scale(-1.0);
        v2.set((Tuple3d)v);
        v2.normalize();
    }

    public static int getOrientation(Point3d p1, Point3d p2, Point3d p3, Point3d p4) {
        Vector3d v3 = new Vector3d((Tuple3d)p4);
        v3.sub((Tuple3d)p1);
        return GMath.getOrientation(p1, p2, p3, v3);
    }

    public static int getOrientation(Point3d p1, Point3d p2, Point3d p3, Vector3d v) {
        Vector3d v1 = new Vector3d((Tuple3d)p2);
        v1.sub((Tuple3d)p1);
        Vector3d v2 = new Vector3d((Tuple3d)p3);
        v2.sub((Tuple3d)p1);
        Vector3d v12 = new Vector3d();
        v12.cross(v1, v2);
        v12.normalize();
        v.normalize();
        double signedVolume = v12.dot(v);
        if (signedVolume > 1.0E-7) {
            return 1;
        }
        if (signedVolume < -1.0E-7) {
            return 0;
        }
        return 2;
    }
}

