/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.MainWindow;
import javax.help.Map;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.model.GOptions;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GOptionsManager;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import org.apache.log4j.Logger;

public class GHelpManager {
    private static GHelpManager instance;
    private HelpSet hs;
    private MainWindow mainWindow;
    private static Logger logger;

    private GHelpManager() {
    }

    public static GHelpManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new GHelpManager();
        return instance;
    }

    public void init() throws Exception {
        GOptions options = GOptionsManager.getInstance().getOptions();
        String language = options.getLanguage();
        logger.info((Object)String.format("Creating helpset for %s", language));
        if (this.mainWindow != null) {
            this.mainWindow.setDisplayed(false);
        }
        String file = String.format("/javahelp/%s/jhelpset.hs", language);
        URL url = GHelpManager.class.getResource(file);
        this.hs = new HelpSet(null, url);
        this.hs.createHelpBroker().initPresentation();
        this.mainWindow = (MainWindow)MainWindow.getPresentation((HelpSet)this.hs, (String)"mainWindow");
        Frame owner = GDocumentHandler.getInstance().getOwnerFrame();
        this.mainWindow.setActivationWindow((Window)owner);
        Font font = options.getFont();
        this.mainWindow.setFont(font);
    }

    public void fontChanged() {
        GOptions options = GOptionsManager.getInstance().getOptions();
        Font font = options.getFont();
        this.mainWindow.setFont(font);
    }

    public void displayContents() {
        logger.info((Object)"");
        this.mainWindow.setCurrentView("TOC");
        String title = String.format("%s - %s", GDictionary.get("Help", new String[0]), GVersionManager.getInstance().getApplicationName());
        this.mainWindow.setTitle(title);
        this.displayPage("top", null);
    }

    public void displaySearch() {
        logger.info((Object)"");
        this.mainWindow.setCurrentView("Search");
        String title = String.format("%s - %s", GDictionary.get("Help", new String[0]), GVersionManager.getInstance().getApplicationName());
        this.mainWindow.setTitle(title);
        this.displayPage("top", null);
    }

    public void displayPage(String pageId, Window owner) {
        logger.info((Object)pageId);
        try {
            this.mainWindow.setCurrentID(Map.ID.create((String)pageId, (HelpSet)this.hs));
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            return;
        }
        if (owner != null) {
            this.mainWindow.setActivationWindow(owner);
        }
        this.mainWindow.setDisplayed(true);
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

