/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.model.GCamera;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.view.GFigurePane;

public class GFigureMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    public static final int MAX_SPIN_START_DELAY = 250;
    private GFigure figure;
    private GCamera camera;
    private int xDown;
    private int yDown;
    private int xUp;
    private int yUp;
    private Date lastDragged;
    private int lastStroke;
    private int lastStrokeTime;
    private boolean cameraSpinEligible;

    public GFigureMouseAdapter(GFigurePane figurePane, GFigure figure) {
        this.figure = figure;
        this.camera = figure.getCamera();
        figurePane.addMouseListener(this);
        figurePane.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent e) {
        this.xDown = e.getX();
        this.yDown = e.getY();
        this.camera.seize();
        if (e.isPopupTrigger()) {
            this.figure.popupMenu(e.getX(), e.getY());
            return;
        }
        if (e.getButton() == 1 && GDocumentHandler.getInstance().isSelectorOn()) {
            this.figure.select(e);
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.xUp = e.getX();
        this.yUp = e.getY();
        if (e.isPopupTrigger()) {
            this.figure.popupMenu(e.getX(), e.getY());
            return;
        }
        if (GDocumentHandler.getInstance().isSelectorOn()) {
            return;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (GDocumentHandler.getInstance().isSelectorOn()) {
            return;
        }
        int nextXDown = e.getX();
        int nextYDown = e.getY();
        int dx = nextXDown - this.xDown;
        int dy = nextYDown - this.yDown;
        this.lastDragged = new Date();
        Vector3d axis = new Vector3d((double)dy, (double)dx, 0.0);
        this.lastStroke = (int)Math.sqrt(dx * dx + dy * dy);
        this.lastStrokeTime = (int)(new Date().getTime() - this.lastDragged.getTime());
        this.camera.turn(axis, this.lastStroke, this.figure);
        this.cameraSpinEligible = true;
        this.xDown = nextXDown;
        this.yDown = nextYDown;
    }

    public void mouseMoved(MouseEvent e) {
        if (GDocumentHandler.getInstance().isSelectorOn()) {
            return;
        }
        int nextXUp = e.getX();
        int nextYUp = e.getY();
        int dx = nextXUp - this.xUp;
        int dy = nextYUp - this.yUp;
        if (this.lastDragged != null && new Date().getTime() - this.lastDragged.getTime() <= 250L && this.cameraSpinEligible) {
            this.cameraSpinEligible = false;
            Vector3d axis = new Vector3d((double)dy, (double)dx, 0.0);
            this.camera.spin(axis, Math.max(this.lastStroke, 1), Math.max(this.lastStrokeTime, 10), this.figure);
        }
        this.xUp = nextXUp;
        this.yUp = nextYUp;
    }
}

