/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.geocentral.geometria.action.GAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GOpenFigureAction;
import net.geocentral.geometria.action.GOpenProblemAction;
import net.geocentral.geometria.action.GOpenSolutionAction;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.util.GXmlUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class GDragAndDropHandler
extends TransferHandler {
    DataFlavor dataFlavor = DataFlavor.stringFlavor;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public void init(JComponent target) throws Exception {
        logger.info((Object)"");
        target.setTransferHandler(this);
    }

    public boolean canImport(TransferHandler.TransferSupport info) {
        return info.isDataFlavorSupported(this.dataFlavor);
    }

    public boolean importData(TransferHandler.TransferSupport info) {
        GDocument document;
        GAction action;
        String filePath;
        GXmlEntity xmlEntity;
        if (!info.isDrop()) {
            return false;
        }
        Transferable transferable = info.getTransferable();
        if (!transferable.isDataFlavorSupported(this.dataFlavor)) {
            return false;
        }
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        try {
            int c;
            Reader reader = this.dataFlavor.getReaderForText(transferable);
            StringBuffer buf = new StringBuffer();
            while ((c = reader.read()) >= 0) {
                buf.append((char)c);
            }
            String uri = String.valueOf(buf).trim();
            InputSource source = new InputSource(uri);
            xmlEntity = GXmlUtils.readXmlEntity(source);
            if (!(xmlEntity instanceof GDocument) && !(xmlEntity instanceof GSolid)) {
                return false;
            }
            filePath = new File(new URI(uri)).getPath();
        }
        catch (Exception exception) {
            return false;
        }
        if (xmlEntity instanceof GProblem) {
            if (!documentHandler.onCloseDocument()) {
                return false;
            }
            action = new GOpenProblemAction();
            ((GOpenProblemAction)action).execute((GProblem)xmlEntity);
            ((GOpenProblemAction)action).setFilePath(filePath);
            documentHandler.updateActionHandlerStates();
            return true;
        }
        if (xmlEntity instanceof GSolution) {
            if (!documentHandler.onCloseDocument()) {
                return false;
            }
            action = new GOpenSolutionAction();
            ((GOpenSolutionAction)action).execute((GSolution)xmlEntity);
            ((GOpenSolutionAction)action).setFilePath(filePath);
            documentHandler.updateActionHandlerStates();
            return true;
        }
        if (xmlEntity instanceof GSolid && (document = documentHandler.getActiveDocument()) instanceof GProblem) {
            GOpenFigureAction action2 = new GOpenFigureAction();
            action2.execute((GSolid)xmlEntity);
            action2.setFilePath(filePath);
            documentHandler.addAction(action2);
            documentHandler.setDocumentModified(true);
            documentHandler.updateActionHandlerStates();
            return true;
        }
        return false;
    }
}

