/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer.condition;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.condition.GCondition;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GPointSetFactory;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GPerpendicularToLineCondition
implements GCondition {
    private Point3d[] coords;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("coords");
        if (ns.getLength() != 2) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        this.coords = new Point3d[2];
        for (int i = 0; i < 2; ++i) {
            String coordsString = ns.item(i).getTextContent();
            this.coords[i] = GStringUtils.coordsFromString(coordsString);
            if (this.coords != null) continue;
            logger.error((Object)coordsString);
            throw new Exception();
        }
    }

    public void validate(String valueString, GDocument document) throws Exception {
        logger.info((Object)valueString);
        GFigure figure = document.getSelectedFigure();
        Point3d[] cs = GPointSetFactory.getInstance().fromString(valueString, figure);
        if (cs.length != 2) {
            logger.info((Object)cs.length);
            throw new Exception(GDictionary.get("Enter2RefPoints", new String[0]));
        }
        this.coords = cs;
    }

    public boolean verify(Point3d[] cs, GDocument document) {
        logger.info(Arrays.asList(cs));
        Vector3d n = GMath.cross(cs[0], cs[1], cs[2]);
        n.normalize();
        Vector3d v = new Vector3d((Tuple3d)this.coords[1]);
        v.sub((Tuple3d)this.coords[0]);
        v.normalize();
        return GMath.areCollinear(v, n, 1.0E-7);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<condition>");
        buf.append("\n<type>perpendicularToLine</type>");
        for (int i = 0; i < this.coords.length; ++i) {
            buf.append("\n<coords>");
            buf.append(GStringUtils.coordsToString(this.coords[i]));
            buf.append("</coords>");
        }
        buf.append("\n</condition>");
    }

    public String getStringValue() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.coords.length; ++i) {
            buf.append(GStringUtils.coordsToString(this.coords[i], true));
            if (i >= this.coords.length - 1) continue;
            buf.append(" , ");
        }
        return String.valueOf(buf);
    }

    public String getDescription() {
        return GDictionary.get("PerpendicularToLine", new String[0]);
    }
}

