/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer.condition;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.answer.condition.GFigureCondition;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GParallelogramCondition
implements GFigureCondition {
    private String figureName;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() < 1) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        if (document.getFigure(this.figureName) == null) {
            logger.error((Object)this.figureName);
            throw new Exception();
        }
    }

    public void validate(String valueString, GDocument document) throws Exception {
        logger.info((Object)valueString);
        GFigure figure = document.getSelectedFigure();
        if (figure == null) {
            logger.info((Object)"No figure selected");
            throw new Exception(GDictionary.get("NoFigureSelected", new String[0]));
        }
        this.figureName = figure.getName();
    }

    public boolean verify(Point3d[] cs, GDocument document) {
        logger.info(Arrays.asList(cs));
        GFigure figure = document.getFigure(this.figureName);
        if (figure == null) {
            return false;
        }
        GSolid solid = figure.getSolid();
        Vector3d n = GMath.cross(cs[0], cs[1], cs[2]);
        n.normalize();
        GSolid fragment = solid.clone();
        try {
            fragment.cutOff(cs[0], n);
        }
        catch (Exception exception) {
            return false;
        }
        int faceCount = fragment.faceCount();
        GFace face = fragment.faceAt(faceCount - 1);
        return face.isParallelogram(fragment);
    }

    public void figureRenamed(GRenameFigureAction action) {
        logger.info((Object)"");
        if (action.getOldFigureName().equals(this.figureName)) {
            this.figureName = action.getNewFigureName();
        }
    }

    public void renameFigureUndone(GRenameFigureAction action) {
        logger.info((Object)"");
        if (action.getNewFigureName().equals(this.figureName)) {
            this.figureName = action.getOldFigureName();
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<condition>");
        buf.append("\n<type>parallelogram</type>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        buf.append("\n</condition>");
    }

    public String getDescription() {
        return GDictionary.get("Parallelogram", new String[0]);
    }

    public String getStringValue() {
        return "Not implemented";
    }

    public String getFigureName() {
        return this.figureName;
    }
}

