/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer;

import java.util.List;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GNumberAnswer
implements GAnswer {
    private double value;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GNumberAnswer() {
        this.value = 0.0;
    }

    public GNumberAnswer(double value) {
        logger.info((Object)value);
        this.value = value;
    }

    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("value");
        if (ns.getLength() != 1) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        String valueString = ns.item(0).getTextContent();
        if (valueString.length() > 0) {
            try {
                this.value = Double.parseDouble(valueString);
            }
            catch (Exception exception) {
                logger.error((Object)valueString);
                throw new Exception();
            }
        }
    }

    public void validateInput(String inputString, GDocument document) throws Exception {
        logger.info((Object)inputString);
        if (inputString.length() == 0) {
            throw new Exception(GDictionary.get("EnterValidExpression", new String[0]));
        }
        GNotepadVariable variable = document.getVariable(inputString);
        if (variable != null) {
            this.value = variable.getValue();
        } else {
            List<GNotepadVariable> variables = document.getNotepad().getVariables();
            Double v = GMath.evaluate(inputString, variables);
            if (v == null) {
                logger.info((Object)("Bad expression: " + inputString));
                throw new Exception(GDictionary.get("EnterValidExpression", new String[0]));
            }
            this.value = v;
        }
    }

    public boolean validate(String valueString, String figureName, GDocument document) {
        logger.info((Object)valueString);
        List<GNotepadVariable> variables = document.getNotepad().getVariables();
        Double v = GMath.evaluate(valueString, variables);
        if (v == null) {
            return false;
        }
        return Math.abs(this.value - v) < 1.0E-7;
    }

    public boolean verify(GNumberAnswer answer, double epsilon) {
        logger.info((Object)(answer.value + ", " + epsilon));
        return Math.abs(this.value - answer.value) < epsilon;
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<answer>");
        buf.append("\n<type>number</type>");
        buf.append("\n<value>");
        buf.append(String.valueOf(this.value));
        buf.append("</value>");
        buf.append("\n</answer>");
    }

    public Double getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

