/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GPointSetFactory;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GFixedPlaneAnswer
implements GAnswer {
    private Point3d[] coords;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GFixedPlaneAnswer() {
    }

    public GFixedPlaneAnswer(Point3d[] coords) {
        logger.info(Arrays.asList(coords));
        this.coords = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            this.coords[i] = new Point3d(coords[i]);
        }
    }

    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("coords");
        if (ns.getLength() != 3) {
            logger.error((Object)ns.getLength());
            throw new Exception();
        }
        this.coords = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            String coordsString = ns.item(i).getTextContent();
            this.coords[i] = GStringUtils.coordsFromString(coordsString);
            if (this.coords[i] != null) continue;
            logger.error((Object)coordsString);
            throw new Exception();
        }
        if (GMath.areCollinear(this.coords, 1.0E-7)) {
            logger.error((Object)("Collinear: " + Arrays.asList(this.coords)));
            throw new Exception();
        }
    }

    public boolean validate(String valueString, String figureName, GDocument document) {
        Point3d[] cs;
        try {
            cs = GPointSetFactory.getInstance().fromString(valueString, figureName, document);
        }
        catch (Exception exception) {
            return false;
        }
        GFigure figure = document.getFigure(figureName);
        double epsilon = figure == null ? 1.0E-7 : figure.getSolid().getEpsilon();
        return this.verify(cs, epsilon);
    }

    public boolean verify(Point3d[] cs, double epsilon) {
        logger.info((Object)(Arrays.asList(cs) + ", " + epsilon));
        Vector3d v1 = GMath.cross(this.coords[0], this.coords[1], this.coords[2]);
        Vector3d v2 = GMath.cross(cs[0], cs[1], cs[2]);
        v1.normalize();
        v2.normalize();
        return GMath.areCollinear(v1, v2, epsilon);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<answer>");
        buf.append("\n<type>fixedPlane</type>");
        for (int i = 0; i < 3; ++i) {
            buf.append("\n<coords>");
            buf.append(GStringUtils.coordsToString(this.coords[i]));
            buf.append("</coords>");
        }
        buf.append("\n</answer>");
    }

    public Point3d[] getCoords() {
        Point3d[] cs = new Point3d[3];
        for (int i = 0; i < 3; ++i) {
            cs[i] = new Point3d(this.coords[i]);
        }
        return cs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            buf.append(GStringUtils.coordsToString(this.coords[i], true));
            if (i >= 2) continue;
            buf.append(" , ");
        }
        return String.valueOf(buf);
    }
}

